/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.interp.commands;

import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.interp.AbstractIDLCommand;
import com.rsi.jdml.DMLAccess;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class CommandSet
extends AbstractIDLCommand {
    private Vector<Command> m_commands = new Vector(10, 10);
    boolean m_silent;

    public CommandSet() {
        this(true);
    }

    public CommandSet(boolean silent) {
        this.m_silent = silent;
    }

    public void addCommand(String s) {
        this.m_commands.add(new Command(s));
    }

    public void addCommand(AbstractIDLCommand c) {
        this.m_commands.add(new Command(c));
    }

    public void addCommand(String s, Object o, String m) {
        this.m_commands.add(new Command(s, o, m));
    }

    public void addCommand(AbstractIDLCommand c, Object o, String m) {
        this.m_commands.add(new Command(c, o, m));
    }

    public boolean isDuplicate(AbstractIDLCommand command) {
        return false;
    }

    public synchronized void activate(IIDLProcessProxy idl) {
        try {
            long id = idl.getDebugID();
            int i = 0;
            while (i < this.m_commands.size()) {
                Command c = this.m_commands.get(i);
                if (c.execute(idl, id)) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {}
    }

    private class Command {
        protected String m_string;
        protected AbstractIDLCommand m_command;
        protected Object m_object;
        protected Method m_method;

        public Command(String s) {
            this.init(s, null, null, null);
        }

        public Command(AbstractIDLCommand c) {
            this.init(null, c, null, null);
        }

        public Command(String s, Object o, String m) {
            this.init(s, null, o, m);
        }

        public Command(AbstractIDLCommand c, Object o, String m) {
            this.init(null, c, o, m);
        }

        private void init(String s, AbstractIDLCommand cmd, Object object, String methodName) {
            this.m_string = s;
            this.m_command = cmd;
            this.m_object = null;
            this.m_method = null;
            if (object != null && methodName != null) {
                Class<?> c = object.getClass();
                Class[] parameterTypes = new Class[]{};
                Method method = null;
                try {
                    method = c.getMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                this.m_object = object;
                this.m_method = method;
            }
        }

        public boolean execute(IIDLProcessProxy idl, long id) {
            boolean continueExecuting = true;
            if (this.m_string != null) {
                if (CommandSet.this.m_silent) {
                    DMLAccess.silentExecuteString(id, this.m_string);
                } else {
                    DMLAccess.executeString(id, this.m_string);
                }
            } else if (this.m_command != null) {
                this.m_command.activate(idl);
            }
            if (this.m_method != null) {
                try {
                    Object[] parameters = new Object[]{};
                    Boolean b = (Boolean)this.m_method.invoke(this.m_object, parameters);
                    continueExecuting = b;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    continueExecuting = false;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continueExecuting = false;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    continueExecuting = false;
                }
            }
            return continueExecuting;
        }
    }
}

