/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.dom;

import com.rsi.idldt.core.internal.dom.IDLRoutine;
import com.rsi.idldt.core.internal.dom.RestructuredTextDOMTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Text2HTML {
    StringBuffer m_htmlBuffer = new StringBuffer();
    ArrayList<String> m_rawLines;
    final String newline = System.getProperty("line.separator");
    String m_col1;
    String m_col2;
    HashSet<String> m_subheadset;
    IDLRoutine m_idlRoutine;

    public Text2HTML(IDLRoutine idlRoutine) {
        this.m_idlRoutine = idlRoutine;
    }

    public String getHTML(String rawText) {
        this.m_htmlBuffer.setLength(0);
        this.m_rawLines = this.makeLines(rawText, false);
        if (this.looksLikeRSTFormat()) {
            this.generate_HTML_using_RST_algorithm();
        } else {
            this.m_subheadset = new HashSet();
            this.m_subheadset.add("@param");
            this.m_subheadset.add("@keyword");
            this.m_subheadset.add("@field");
            this.m_subheadset.add("@key");
            this.m_subheadset.add("@property");
            this.generate_HTML_using_generic_algorithm();
        }
        return this.m_htmlBuffer.toString();
    }

    protected boolean looksLikeRSTFormat() {
        int i = 0;
        while (i < this.m_rawLines.size()) {
            String line = this.m_rawLines.get(i);
            line = line.replaceAll("\t", " ");
            String[] tokens = line.split(" ");
            int j = 0;
            while (j < tokens.length) {
                if (RestructuredTextDOMTree.getRoutineTagTreeSet().contains(tokens[j].toLowerCase())) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    protected void generate_HTML_using_RST_algorithm() {
        RestructuredTextDOMTree tree = new RestructuredTextDOMTree(this.m_idlRoutine, this.m_rawLines);
        this.m_htmlBuffer = tree.getHTMLStringBuffer();
    }

    protected void generate_HTML_using_generic_algorithm() {
        int i = 0;
        while (i < this.m_rawLines.size()) {
            String line = this.m_rawLines.get(i);
            if (this.allWhitespace(line)) {
                this.addBlankRowL();
            } else if (this.looksLike2Columns(line)) {
                this.addRowL(this.m_col1, this.m_col2);
            } else {
                this.addSpanningRowL(line);
            }
            ++i;
        }
    }

    protected void addBlankRowL() {
        this.m_htmlBuffer.append("<p class=\"subhead\">&nbsp;</p>" + this.newline);
    }

    protected void addRowL(String theCol1, String theCol2) {
        String col1 = theCol1;
        String col2 = theCol2;
        if (col1 != null && col1.length() > 0) {
            this.m_htmlBuffer.append("<h1>" + col1 + "</h1>" + this.newline);
        }
        if (col1 != null && col2.length() > 0) {
            if (col2.length() > 3 && col2.charAt(0) == ' ' && col2.charAt(1) == ' ' && col2.charAt(2) == ' ') {
                col2 = col2.substring(2);
            }
            this.m_htmlBuffer.append("<pre class=\"generic\">" + col2 + "</pre>" + this.newline);
        }
    }

    protected void addSpanningRowL(String row) {
        this.addRowL("", row);
    }

    protected boolean allWhitespace(String line) {
        return line.trim().length() == 0;
    }

    protected boolean looksLike2Columns(String theRow) {
        String row = theRow;
        StringTokenizer st = new StringTokenizer(row, " \t");
        boolean bYes2Columns = false;
        if (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (!this.first4CharsAreWhitespace(row) && (tok.endsWith(":") || tok.startsWith("@"))) {
                tok = tok.replaceAll(":", "");
                String sav_tok = tok.toLowerCase();
                tok = tok.replaceFirst("@", "");
                bYes2Columns = true;
                this.m_col1 = tok;
                this.m_col2 = "";
                if (st.hasMoreTokens()) {
                    this.m_col2 = this.m_subheadset.contains(sav_tok) ? String.valueOf(this.m_col2) + "<b class=\"subhead\">" + st.nextToken() + "</b> " : String.valueOf(this.m_col2) + st.nextToken() + " ";
                }
                while (st.hasMoreTokens()) {
                    this.m_col2 = String.valueOf(this.m_col2) + st.nextToken() + " ";
                }
            }
        }
        if (!bYes2Columns && this.first4CharsAreWhitespace(row)) {
            bYes2Columns = true;
            this.m_col1 = "";
            this.m_col2 = row;
        }
        if (!bYes2Columns && this.looksLikeOneColumnHeader(row)) {
            bYes2Columns = true;
            row = row.replaceAll(":", "");
            this.m_col1 = "<b>" + row + "</b>";
            this.m_col2 = "";
        }
        return bYes2Columns;
    }

    protected boolean looksLikeOneColumnHeader(String row) {
        boolean result = false;
        if (!this.first4CharsAreWhitespace(row) && this.lineEndsWithOneColon(row)) {
            result = true;
        }
        return result;
    }

    protected boolean lineEndsWithOneColon(String row) {
        String lastToken = this.getLastToken(row);
        if (lastToken.endsWith("::")) {
            return false;
        }
        return lastToken.endsWith(":");
    }

    protected String getLastToken(String row) {
        StringTokenizer st = new StringTokenizer(row, " \t");
        String tok = "";
        while (st.hasMoreTokens()) {
            tok = st.nextToken();
        }
        return tok;
    }

    protected boolean first4CharsAreWhitespace(String row) {
        return row.length() >= 4 && Character.isWhitespace(row.charAt(0)) && Character.isWhitespace(row.charAt(1)) && Character.isWhitespace(row.charAt(2)) && Character.isWhitespace(row.charAt(3));
    }

    protected ArrayList<String> makeLines(String content, boolean bTrimLeadingAndTrailing) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer line = new StringBuffer();
        int i = 0;
        while (i < content.length()) {
            char c = content.charAt(i);
            if (c == '\n') {
                if (bTrimLeadingAndTrailing) {
                    lines.add(line.toString().trim());
                } else {
                    lines.add(line.toString());
                }
                line.delete(0, line.length());
            } else if (c != '\r') {
                line.append(c);
            }
            ++i;
        }
        if (bTrimLeadingAndTrailing) {
            lines.add(line.toString().trim());
        } else {
            lines.add(line.toString());
        }
        return lines;
    }
}

