/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.dom;

import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.internal.dom.IDLRoutine;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestructuredTextDOMTree {
    public static final int INCLUDE_FILE_TAGS = 1;
    public static final int INCLUDE_ROUTINE_TAGS = 2;
    static final int SECTION = 1;
    static final int SECTION_WITH_VALUE = 2;
    static final int SUBHEADING = 3;
    static final int SUBHEADING_WITH_ATTRIBUTES = 4;
    static final int SUBHEADING_VALUE = 5;
    static final int PARAGRAPH = 6;
    static final int PARAGRAPH_END = 7;
    ArrayList<String> m_rawText;
    IDLdocTreeNode m_dom;
    IDLdocTreeNode m_currentNode;
    String m_currentLine;
    String m_nextLine;
    int m_currentLineIndentation;
    int m_nextLineIndentation;
    IDLRoutine m_idlRoutine;
    boolean m_bAlreadyInList;
    boolean m_bCodeBlock;
    int m_codeBlockIndentation;
    protected static TreeSet<String> m_sectionNamesContainingSubHeadingsTreeSet = null;
    protected String m_currentSectionName;
    protected static TreeSet<String> m_rstRoutineTagTreeSet = null;
    protected static TreeSet<String> m_rstFileTagTreeSet = null;
    protected static TreeSet<String> m_rstAttributeTreeSet = null;

    public RestructuredTextDOMTree(IDLRoutine idlRoutine, ArrayList<String> rawText) {
        this.m_currentNode = this.m_dom = new IDLdocTreeNode(0, null, 0);
        this.m_bAlreadyInList = false;
        this.m_bCodeBlock = false;
        this.m_codeBlockIndentation = 0;
        if (m_sectionNamesContainingSubHeadingsTreeSet == null) {
            m_sectionNamesContainingSubHeadingsTreeSet = new TreeSet();
            m_sectionNamesContainingSubHeadingsTreeSet.add("Properties");
            m_sectionNamesContainingSubHeadingsTreeSet.add("Fields");
            m_sectionNamesContainingSubHeadingsTreeSet.add("Keywords");
            m_sectionNamesContainingSubHeadingsTreeSet.add("Params");
        }
        this.m_rawText = rawText;
        this.m_idlRoutine = idlRoutine;
        this.parse();
    }

    public static TreeSet<String> getRoutineTagTreeSet() {
        if (m_rstRoutineTagTreeSet == null) {
            RestructuredTextDOMTree.buildRstDocRoutineTagTreeSet();
        }
        return m_rstRoutineTagTreeSet;
    }

    public static TreeSet<String> getFileTagTreeSet() {
        if (m_rstFileTagTreeSet == null) {
            RestructuredTextDOMTree.buildRstDocFileTagTreeSet();
        }
        return m_rstFileTagTreeSet;
    }

    public static TreeSet<String> getAttributeTreeSet() {
        if (m_rstAttributeTreeSet == null) {
            RestructuredTextDOMTree.buildRstAttributeTreeSet();
        }
        return m_rstAttributeTreeSet;
    }

    public static String[] findIDLdocTags(String key, int flags) {
        boolean bDoRoutineTags;
        TreeSet<String> hs = new TreeSet<String>();
        boolean bDoFileTags = (flags & 1) != 0;
        boolean bl = bDoRoutineTags = (flags & 2) != 0;
        if (bDoFileTags) {
            hs.addAll(RestructuredTextDOMTree.getFileTagTreeSet());
        }
        if (bDoRoutineTags) {
            hs.addAll(RestructuredTextDOMTree.getRoutineTagTreeSet());
        }
        Vector<String> v = new Vector<String>();
        for (String tag : hs) {
            boolean ok = tag.startsWith(key);
            if (!ok) continue;
            StringBuffer sb = new StringBuffer(tag);
            sb.setCharAt(1, Character.toUpperCase(sb.charAt(1)));
            v.add(sb.toString());
        }
        return v.toArray(new String[v.size()]);
    }

    public static String[] findIDLdocAttributes(String key) {
        TreeSet<String> hs = RestructuredTextDOMTree.getAttributeTreeSet();
        Vector<String> v = new Vector<String>();
        for (String tag : hs) {
            boolean ok = tag.startsWith(key);
            if (!ok) continue;
            StringBuffer sb = new StringBuffer(tag);
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            v.add(sb.toString());
        }
        return v.toArray(new String[v.size()]);
    }

    public static void buildRstAttributeTreeSet() {
        if (m_rstAttributeTreeSet != null) {
            return;
        }
        m_rstAttributeTreeSet = new TreeSet();
        m_rstAttributeTreeSet.add("in");
        m_rstAttributeTreeSet.add("out");
        m_rstAttributeTreeSet.add("optional");
        m_rstAttributeTreeSet.add("private");
        m_rstAttributeTreeSet.add("hidden");
        m_rstAttributeTreeSet.add("required");
        m_rstAttributeTreeSet.add("type=");
        m_rstAttributeTreeSet.add("default=");
    }

    public static void buildRstDocFileTagTreeSet() {
        if (m_rstFileTagTreeSet != null) {
            return;
        }
        m_rstFileTagTreeSet = new TreeSet();
        m_rstFileTagTreeSet.add(":author:");
        m_rstFileTagTreeSet.add(":copyright:");
        m_rstFileTagTreeSet.add(":examples:");
        m_rstFileTagTreeSet.add(":hidden:");
        m_rstFileTagTreeSet.add(":history:");
        m_rstFileTagTreeSet.add(":private:");
        m_rstFileTagTreeSet.add(":properties:");
        m_rstFileTagTreeSet.add(":version:");
    }

    public static void buildRstDocRoutineTagTreeSet() {
        if (m_rstRoutineTagTreeSet != null) {
            return;
        }
        m_rstRoutineTagTreeSet = new TreeSet();
        m_rstRoutineTagTreeSet.add(":description:");
        m_rstRoutineTagTreeSet.add(":author:");
        m_rstRoutineTagTreeSet.add(":copyright:");
        m_rstRoutineTagTreeSet.add(":examples:");
        m_rstRoutineTagTreeSet.add(":hidden:");
        m_rstRoutineTagTreeSet.add(":history:");
        m_rstRoutineTagTreeSet.add(":private:");
        m_rstRoutineTagTreeSet.add(":version:");
        m_rstRoutineTagTreeSet.add(":bugs:");
        m_rstRoutineTagTreeSet.add(":categories:");
        m_rstRoutineTagTreeSet.add(":customer_id:");
        m_rstRoutineTagTreeSet.add(":examples:");
        m_rstRoutineTagTreeSet.add(":fields:");
        m_rstRoutineTagTreeSet.add(":file_comments:");
        m_rstRoutineTagTreeSet.add(":hidden:");
        m_rstRoutineTagTreeSet.add(":hidden_file:");
        m_rstRoutineTagTreeSet.add(":history:");
        m_rstRoutineTagTreeSet.add(":inherits:");
        m_rstRoutineTagTreeSet.add(":keywords:");
        m_rstRoutineTagTreeSet.add(":obsolete:");
        m_rstRoutineTagTreeSet.add(":params:");
        m_rstRoutineTagTreeSet.add(":post:");
        m_rstRoutineTagTreeSet.add(":pre:");
        m_rstRoutineTagTreeSet.add(":private:");
        m_rstRoutineTagTreeSet.add(":private_file:");
        m_rstRoutineTagTreeSet.add(":requires:");
        m_rstRoutineTagTreeSet.add(":returns:");
        m_rstRoutineTagTreeSet.add(":todo:");
        m_rstRoutineTagTreeSet.add(":uses:");
        m_rstRoutineTagTreeSet.add(":version:");
    }

    public StringBuffer getHTMLStringBuffer() {
        StringBuffer html = new StringBuffer();
        this.m_dom.appendHTML(html);
        return html;
    }

    protected int getIndentation(String line) {
        int i = 0;
        while (i < line.length()) {
            if (!Character.isWhitespace(line.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int getNextLine(int i, int nlines) {
        this.m_currentLine = this.m_rawText.get(i);
        this.m_currentLineIndentation = this.getIndentation(this.m_currentLine);
        if (i + 1 < nlines) {
            this.m_nextLine = this.m_rawText.get(i + 1);
            this.m_nextLineIndentation = this.getIndentation(this.m_nextLine);
        } else {
            this.m_nextLine = null;
            this.m_nextLineIndentation = -1;
        }
        return this.getCurrentLineType();
    }

    protected boolean lineIsSectionWithValue(String theLine) {
        String line = theLine;
        String[] tokens = (line = line.replace('\t', ' ').trim()).split(" +");
        return tokens.length >= 2 && tokens[0].startsWith(":") && tokens[0].endsWith(":");
    }

    protected boolean lineIsSection(String theLine) {
        String line = theLine;
        String[] tokens = (line = line.replace('\t', ' ').trim()).split(" +");
        return tokens.length == 1 && tokens[0].startsWith(":") && tokens[0].endsWith(":");
    }

    protected boolean lineIsSubHeadingWithValue(String theLine) {
        String line = theLine;
        String[] tokens = (line = line.replace('\t', ' ').trim()).split(" +");
        if (tokens.length >= 2) {
            if (tokens[0].endsWith(":")) {
                return true;
            }
            if (tokens[1].equals(":")) {
                return true;
            }
        }
        return false;
    }

    protected boolean justOneWord(String theLine) {
        String line = theLine;
        String[] tokens = (line = line.replace('\t', ' ').trim()).split(" +");
        return tokens.length == 1;
    }

    protected boolean inASectionThatCanContainSubHeadings() {
        return m_sectionNamesContainingSubHeadingsTreeSet.contains(this.m_currentSectionName);
    }

    protected int getCurrentLineType() {
        if (this.m_currentLineIndentation == -1) {
            return 7;
        }
        if (this.lineIsSectionWithValue(this.m_currentLine)) {
            return 2;
        }
        if (this.lineIsSection(this.m_currentLine)) {
            return 1;
        }
        if (this.m_currentNode.getType() == 3) {
            if (this.m_currentLineIndentation == this.m_currentNode.getIndentation()) {
                return 3;
            }
            return 5;
        }
        if (this.m_currentNode.getType() == 2 || this.m_currentNode.getType() == 1) {
            if (this.m_currentLineIndentation == this.m_currentNode.getIndentation()) {
                return 6;
            }
            if (this.inASectionThatCanContainSubHeadings()) {
                if (this.lineIsSubHeadingWithValue(this.m_currentLine)) {
                    return 4;
                }
                if (this.justOneWord(this.m_currentLine)) {
                    return 3;
                }
            }
        }
        return 6;
    }

    protected void addSectionToDOM() {
        String heading = this.m_currentLine.replace(':', ' ').trim().toUpperCase();
        if (heading.length() > 1) {
            char firstChar = heading.charAt(0);
            heading = String.valueOf(firstChar) + heading.substring(1).toLowerCase();
        }
        IDLdocTreeNode node = new IDLdocTreeNode(1, heading, this.m_currentLineIndentation);
        this.m_currentNode.addChild(node);
        this.m_currentNode = node;
        this.m_currentSectionName = heading;
    }

    protected boolean currentLineMeetsCodeBlockCriteria() {
        if (this.m_currentLineIndentation > this.m_codeBlockIndentation) {
            return true;
        }
        return this.m_currentLineIndentation == -1;
    }

    protected void addParagraphToDOM() {
        String lineTrim = this.m_currentLine.trim();
        if (lineTrim.startsWith("* ") || lineTrim.startsWith("- ")) {
            String decoration;
            if (this.m_bAlreadyInList) {
                decoration = "<li>";
            } else {
                decoration = "<ul><li>";
                this.m_bAlreadyInList = true;
            }
            lineTrim = String.valueOf(decoration) + lineTrim.substring(1).trim();
        }
        if (!this.m_bCodeBlock && this.m_currentNode.getType() == 2) {
            this.m_currentNode.addData(" " + lineTrim);
        } else {
            IDLdocTreeNode node = new IDLdocTreeNode(2, lineTrim, this.m_currentLineIndentation);
            if (this.m_bCodeBlock) {
                if (this.currentLineMeetsCodeBlockCriteria()) {
                    node.setCodeBlockAttrib();
                } else {
                    this.m_bCodeBlock = false;
                }
            }
            this.m_currentNode.addChild(node);
            this.m_currentNode = node;
        }
        if (lineTrim.endsWith("::")) {
            this.m_bCodeBlock = true;
            this.m_codeBlockIndentation = this.m_currentLineIndentation;
        }
    }

    protected void addSectionWithValueToDOM() {
        StringBuffer value = new StringBuffer();
        String line = this.m_currentLine.replace('\t', ' ').trim();
        String[] tokens = line.split(" ");
        int i = 1;
        while (i < tokens.length) {
            value.append(" " + tokens[i]);
            ++i;
        }
        String heading = tokens[0].replace(':', ' ').trim().toUpperCase();
        if (heading.length() > 1) {
            char firstChar = heading.charAt(0);
            heading = String.valueOf(firstChar) + heading.substring(1).toLowerCase();
        }
        IDLdocTreeNode headingNode = new IDLdocTreeNode(1, heading, this.m_currentLineIndentation);
        this.m_currentNode.addChild(headingNode);
        this.m_currentNode = headingNode;
        this.m_currentNode.addChild(new IDLdocTreeNode(2, value.toString().trim(), this.m_currentLineIndentation));
        this.m_currentNode = headingNode.getParent();
        this.m_currentSectionName = heading;
    }

    protected void addSubHeadingToDOM() {
        IDLdocTreeNode node = new IDLdocTreeNode(3, this.m_currentLine.trim(), this.m_currentLineIndentation);
        this.m_currentNode.addChild(node);
        this.m_currentNode = node;
    }

    protected void addSubHeadingValueToDOM() {
        IDLdocTreeNode node = new IDLdocTreeNode(4, null, this.m_currentLineIndentation);
        this.m_currentNode.addChild(node);
        this.m_currentNode = node;
        this.addParagraphToDOM();
    }

    protected void parse() {
        int nlines = this.m_rawText.size();
        int i = 0;
        while (i < nlines) {
            int lineType = this.getNextLine(i, nlines);
            if (this.m_currentNode.getType() == 2 && lineType != 6) {
                if (this.m_bAlreadyInList) {
                    this.m_currentNode.addData("</ul>");
                    this.m_bAlreadyInList = false;
                }
                this.m_currentNode = this.m_currentNode.getParent();
            }
            if (this.m_currentNode.getType() == 4 && lineType != 6) {
                this.m_currentNode = this.m_currentNode.getParent();
            }
            if (lineType != 6 && lineType != 7) {
                this.m_bCodeBlock = false;
            }
            switch (lineType) {
                case 1: {
                    this.addSectionToDOM();
                    break;
                }
                case 2: {
                    this.addSectionWithValueToDOM();
                    break;
                }
                case 3: 
                case 4: {
                    this.addSubHeadingToDOM();
                    break;
                }
                case 5: {
                    this.addSubHeadingValueToDOM();
                    break;
                }
                case 6: {
                    this.addParagraphToDOM();
                    break;
                }
                case 7: {
                    if (!this.m_bCodeBlock) break;
                    this.addParagraphToDOM();
                }
            }
            ++i;
        }
    }

    class IDLdocTreeNode {
        static final int TREETOP = 0;
        static final int HEAD = 1;
        static final int P = 2;
        static final int DT = 3;
        static final int DD = 4;
        protected int m_type;
        protected String m_data;
        protected ArrayList<IDLdocTreeNode> m_kids;
        protected IDLdocTreeNode m_parent = null;
        protected int m_indentation;
        protected boolean m_bCodeBlock1 = false;

        public IDLdocTreeNode(int type, String data, int indentation) {
            this.m_type = type;
            this.m_data = data;
            this.m_indentation = indentation;
        }

        public void addData(String data) {
            this.m_data = String.valueOf(this.m_data) + data;
        }

        public void addChild(IDLdocTreeNode node) {
            node.m_parent = this;
            if (this.m_kids == null) {
                this.m_kids = new ArrayList();
            }
            this.m_kids.add(node);
        }

        public IDLdocTreeNode getParent() {
            return this.m_parent;
        }

        public void setCodeBlockAttrib() {
            this.m_bCodeBlock1 = true;
            if (this.m_data.length() == 0) {
                this.m_data = "&nbsp;";
            }
        }

        public int getType() {
            return this.m_type;
        }

        public int getIndentation() {
            return this.m_indentation;
        }

        protected void appendHTMLforKids(StringBuffer html) {
            if (this.m_kids != null) {
                int i = 0;
                while (i < this.m_kids.size()) {
                    IDLdocTreeNode node = this.m_kids.get(i);
                    node.appendHTML(html);
                    ++i;
                }
            }
        }

        protected boolean findTwoOccurrences(String source, String pattern) {
            int i2;
            int i1 = source.indexOf(pattern);
            return i1 > -1 && (i2 = source.indexOf(pattern, i1 + 1)) > -1;
        }

        protected String replaceSequencePair(String source, String pattern, String pat1, String pat2) {
            String result = source.replaceFirst(pattern, pat1);
            result = result.replaceFirst(pattern, pat2);
            return result;
        }

        protected String getSourceFolderName() {
            String pathSep = System.getProperty("file.separator");
            String folderName = "";
            IIDLCompilationUnit cu = RestructuredTextDOMTree.this.m_idlRoutine.getCompilationUnit();
            if (cu == null) {
                return folderName;
            }
            folderName = cu.getDOMFile().getCanonicalPath();
            int i = folderName.lastIndexOf(pathSep);
            folderName = folderName.substring(0, i + 1);
            return folderName;
        }

        protected String replaceImageReferences(String theData) {
            String data = theData;
            int index = data.toLowerCase().indexOf(".. image::");
            while (index > -1) {
                int file_start = -1;
                int file_end = -1;
                int i = index + 10;
                while (i < data.length()) {
                    if (data.charAt(i) != ' ') {
                        file_start = i;
                        break;
                    }
                    ++i;
                }
                if (file_start > -1) {
                    i = file_start;
                    while (i < data.length()) {
                        char ch = data.charAt(i);
                        if (Character.isWhitespace(ch) || ch == '<') break;
                        file_end = i++;
                    }
                    if (file_end > file_start) {
                        String image_filename = data.substring(file_start, file_end + 1);
                        String sourceFolderName = this.getSourceFolderName();
                        String the_image = String.valueOf(sourceFolderName) + image_filename;
                        data = String.valueOf(data.substring(0, index)) + "<img align=\"absmiddle\" src=\"" + the_image + "\"" + " alt=\"" + the_image + "\"" + "/>" + data.substring(file_end + 1);
                    } else {
                        data = data.replaceFirst(".. image::", ".. image ::");
                    }
                } else {
                    data = data.replaceFirst(".. image::", ".. image ::");
                }
                index = data.toLowerCase().indexOf(".. image::");
            }
            return data;
        }

        protected String fixMarkup(String theData) {
            String data = theData;
            data = data.trim();
            boolean found = this.findTwoOccurrences(data, "**");
            while (found) {
                data = this.replaceSequencePair(data, "\\*\\*", "<b>", "</b>");
                found = this.findTwoOccurrences(data, "**");
            }
            found = this.findTwoOccurrences(data, "*");
            while (found) {
                data = this.replaceSequencePair(data, "\\*", "<i>", "</i>");
                found = this.findTwoOccurrences(data, "*");
            }
            data = this.replaceImageReferences(data);
            return data;
        }

        public void appendHTML(StringBuffer html) {
            switch (this.m_type) {
                case 4: {
                    html.append("\n    <div class=\"subheadval\">");
                    this.appendHTMLforKids(html);
                    html.append("\n    </div>");
                    return;
                }
                case 3: {
                    String line = this.m_data.replace('\t', ' ').trim();
                    StringBuffer attribs = new StringBuffer();
                    String[] tokens = line.split(" ");
                    int i = 1;
                    while (i < tokens.length) {
                        attribs.append(" " + tokens[i]);
                        ++i;
                    }
                    String sattribs = attribs.toString();
                    sattribs = sattribs.replaceAll("\\\\", "");
                    sattribs = sattribs.replaceAll("\"", "");
                    this.m_data = String.valueOf(tokens[0]) + "<i>" + sattribs + "</i>";
                    html.append("\n  <p class=\"subhead\">" + this.m_data + "</p>");
                    break;
                }
                case 1: {
                    html.append("\n<h1>" + this.m_data + "</h1>");
                    break;
                }
                case 2: {
                    if (this.m_bCodeBlock1) {
                        html.append("<p class=\"code\">" + this.m_data + "</p>");
                        break;
                    }
                    String new_data = this.fixMarkup(this.m_data);
                    html.append("<p>" + new_data + "</p>");
                    break;
                }
                default: {
                    html.append("\n");
                }
            }
            this.appendHTMLforKids(html);
        }
    }
}

