/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.dom;

import com.rsi.idldt.core.dom.IDOMFile;
import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.IIDLField;
import com.rsi.idldt.core.dom.IIDLStructure;
import com.rsi.idldt.core.internal.dom.IDLCUMember;
import com.rsi.idldt.core.internal.dom.IDLField;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;

public class IDLStructure
extends IDLCUMember
implements IIDLStructure {
    private static final long serialVersionUID = 1L;
    private static final String ANONYMOUS_STRUCT_PREFIX = "IDLAnonymousStruct";
    private static int anonymousCount = 0;
    protected boolean m_isNamed;
    protected boolean m_isClass;
    protected boolean m_isResolved;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public IDLStructure(IDOMNode parent, String name, int offset, int length, int nameOffset, int nameLen) throws IllegalArgumentException {
        super(parent, name != null ? name : ANONYMOUS_STRUCT_PREFIX, offset, length, nameOffset, nameLen);
        if (name == null) {
            Class<IDLStructure> clazz = IDLStructure.class;
            // MONITORENTER : com.rsi.idldt.core.internal.dom.IDLStructure.class
            this.m_name = String.valueOf(this.m_name) + ++anonymousCount;
            // MONITOREXIT : clazz
        }
        this.m_isNamed = name != null;
        this.m_isClass = this.determineIsClass();
        this.m_isResolved = false;
    }

    public IIDLField createField(String name, String contents, boolean isInherit, String structureName, int offset, int length, int nameOffset, int nameLen) {
        IDLField field = new IDLField(this, name, contents, isInherit, structureName, offset, length, nameOffset, nameLen);
        this.addChild(field);
        return field;
    }

    public IIDLField getField(String name) {
        return (IIDLField)this.getChildOfTypeAndName(2, name);
    }

    public IIDLField[] getFields() {
        ArrayList<IDOMNode> list = this.getChildrenOfType(2);
        IIDLField[] a = new IIDLField[list.size()];
        list.toArray(a);
        return a;
    }

    public boolean inherits() {
        return false;
    }

    public String[] getSuperclassNames() {
        return null;
    }

    public IIDLStructure[] getTypes() {
        return null;
    }

    public boolean isNamed() {
        return this.m_isNamed;
    }

    public boolean isClass() {
        return this.m_isClass;
    }

    public void setClass(boolean isClass) {
        this.m_isClass = isClass;
    }

    public String getElementDebugName() {
        return "Struct:" + this.getElementName();
    }

    public int getElementType() {
        return 3;
    }

    public String toString() {
        return "Structure '" + this.m_name + "'";
    }

    public static void reset() {
        anonymousCount = 0;
    }

    private boolean determineIsClass() {
        boolean isClass = false;
        if (this.isNamed()) {
            String s = String.valueOf(this.getElementName()) + "__define";
            IDOMNode p = this.getParent();
            isClass = p != null && p.getChildOfTypeAndName(5, s) != null;
        }
        return isClass;
    }

    public String getFilename() {
        String filename = null;
        IIDLCompilationUnit cu = this.getCompilationUnit();
        IDOMFile domFile = cu.getDOMFile();
        if (domFile == null) {
            return null;
        }
        if (cu.isResource()) {
            IFile f = domFile.getResource();
            filename = f.getLocationURI().getPath();
        } else {
            filename = domFile.getCanonicalPath();
        }
        return filename;
    }
}

