/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.dom;

import com.rsi.idldt.core.dom.IDOMFile;
import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.IIDLDoc;
import com.rsi.idldt.core.dom.IIDLKeyword;
import com.rsi.idldt.core.dom.IIDLParameter;
import com.rsi.idldt.core.dom.IIDLRoutine;
import com.rsi.idldt.core.internal.dom.IDLCUMember;
import com.rsi.idldt.core.internal.dom.IDLDoc;
import com.rsi.idldt.core.internal.dom.IDLKeyword;
import com.rsi.idldt.core.internal.dom.IDLParameter;
import com.rsi.idldt.core.internal.dom.Text2HTML;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;

public class IDLRoutine
extends IDLCUMember
implements IIDLRoutine {
    private static final long serialVersionUID = 1L;
    private static boolean m_bIncludeAllCommentsAdjacentToProcedure = false;
    protected boolean m_isFunction;
    protected boolean m_bRetrievedIDLDoc = false;
    protected static HashSet<String> m_idlDocTagHashSet = null;
    protected Text2HTML m_text2HTMLConverter = new Text2HTML(this);

    public IDLRoutine(IDOMNode parent, String name, boolean isFunction, int offset, int length, int nameOffset, int nameLength) throws IllegalArgumentException {
        super(parent, name, offset, length, nameOffset, nameLength);
        this.m_isFunction = isFunction;
        if (m_idlDocTagHashSet == null) {
            this.buildIDLDocTagHashSet();
        }
    }

    public static void setOnlyIDLDocInHoverHelp(boolean value) {
        m_bIncludeAllCommentsAdjacentToProcedure = value;
    }

    public boolean hasIDLDOC() {
        return this.m_bRetrievedIDLDoc;
    }

    public int compareTo(IIDLRoutine r1) {
        return this.getRoutineName().compareToIgnoreCase(r1.getRoutineName());
    }

    public String getRoutineName() {
        String name = this.getElementName();
        int x = name.indexOf("::");
        if (x != -1) {
            name = name.substring(x + 2);
        }
        return name;
    }

    public boolean isFunction() {
        return this.m_isFunction;
    }

    public boolean isClassMethod() {
        return this.getElementName().indexOf("::") != -1;
    }

    public boolean isInit() {
        return this.getElementName().toLowerCase().endsWith("::init");
    }

    public boolean isMainRoutine() {
        return this.getElementName() == null;
    }

    public IIDLParameter createParameter(String name, int offset, int length, int nameOffset, int nameLen) {
        IDLParameter param = new IDLParameter(this, name, offset, length, nameOffset, nameLen);
        this.addChild(param);
        return param;
    }

    public int getNumberOfParameters() {
        return this.getParameters().length;
    }

    public IIDLParameter[] getParameters() {
        ArrayList<IDOMNode> list = this.getChildrenOfType(6);
        IIDLParameter[] a = new IIDLParameter[list.size()];
        list.toArray(a);
        return a;
    }

    public IIDLParameter getParameter(String name) {
        return (IIDLParameter)this.getChildOfTypeAndName(6, name);
    }

    public IIDLKeyword createKeyword(String name, String varName, int offset, int length, int nameOffset, int nameLen) {
        IDLKeyword keyword = new IDLKeyword(this, name, varName, offset, length, nameOffset, nameLen);
        this.addChild(keyword);
        return keyword;
    }

    public int getNumberOfKeywords() {
        return this.getKeywords().length;
    }

    public IIDLKeyword[] getKeywords() {
        ArrayList<IDOMNode> list = this.getChildrenOfType(7);
        IIDLKeyword[] a = new IIDLKeyword[list.size()];
        list.toArray(a);
        return a;
    }

    public IIDLKeyword getKeyword(String name) {
        return (IIDLKeyword)this.getChildOfTypeAndName(7, name);
    }

    public IIDLDoc createDoc() {
        IDLDoc doc = new IDLDoc(this);
        this.addChild(doc);
        return doc;
    }

    public IIDLDoc getDoc() {
        ArrayList<IDOMNode> list = this.getChildrenOfType(8);
        IIDLDoc[] a = new IIDLDoc[list.size()];
        list.toArray(a);
        return a.length > 0 ? a[0] : null;
    }

    private StringBuffer readRoutineCommentBlockAboveRoutineFromDisk() {
        BufferedReader is = null;
        StringBuffer idlDocComments = new StringBuffer();
        try {
            String fname = this.getFilename();
            if (fname != null) {
                int target_offset = this.m_sourceRange.getOffset();
                is = new BufferedReader(new FileReader(fname));
                char[] bytes = new char[target_offset + 1];
                is.read(bytes, 0, target_offset);
                is.close();
                boolean bHaveBeginTag = false;
                boolean bHaveEndTag = false;
                if (m_bIncludeAllCommentsAdjacentToProcedure) {
                    bHaveBeginTag = true;
                    bHaveEndTag = true;
                }
                ArrayList<String> headerLineList = new ArrayList<String>();
                boolean bDone = false;
                CommentGathererBottomToTop cg = new CommentGathererBottomToTop(bytes);
                while (!bDone) {
                    String line = cg.getNextLine();
                    if (line.startsWith(";")) {
                        if (line.startsWith(";-")) {
                            bHaveEndTag = true;
                        }
                        if (bHaveEndTag && line.startsWith(";+")) {
                            bHaveBeginTag = true;
                            bDone = true;
                        }
                        String aline = line.substring(1);
                        headerLineList.add(aline);
                        continue;
                    }
                    if (line.equals("done")) {
                        bDone = true;
                        continue;
                    }
                    if (line.length() <= 0 || line.startsWith(";")) continue;
                    bDone = true;
                }
                String newline = System.getProperty("line.separator");
                if (headerLineList.size() > 0 && bHaveBeginTag && bHaveEndTag) {
                    boolean bInsideIDLDoc = false;
                    int i = headerLineList.size() - 1;
                    while (i >= 0) {
                        String line = (String)headerLineList.get(i);
                        if (line.startsWith("+")) {
                            bInsideIDLDoc = true;
                        }
                        if (line.startsWith("-")) {
                            bInsideIDLDoc = false;
                        }
                        if (m_bIncludeAllCommentsAdjacentToProcedure || bInsideIDLDoc && !line.startsWith("+")) {
                            this.m_bRetrievedIDLDoc = true;
                            idlDocComments.append("  ");
                            idlDocComments.append(line);
                            idlDocComments.append(newline);
                        }
                        --i;
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
        return idlDocComments;
    }

    private StringBuffer readRoutineCommentBlockBelowRoutineFromDisk() {
        BufferedReader is = null;
        StringBuffer idlDocComments = new StringBuffer();
        try {
            String fname = this.getFilename();
            if (fname != null) {
                int target_offset = this.m_sourceRange.getOffset();
                int target_length = this.m_sourceRange.getLength();
                if (target_length <= 0 || target_offset <= 0) {
                    return idlDocComments;
                }
                is = new BufferedReader(new FileReader(fname));
                char[] bytes = new char[target_length + 1];
                is.skip(target_offset);
                is.read(bytes, 0, target_length);
                is.close();
                boolean bHaveBeginTag = false;
                boolean bHaveEndTag = false;
                if (m_bIncludeAllCommentsAdjacentToProcedure) {
                    bHaveBeginTag = true;
                    bHaveEndTag = true;
                }
                ArrayList<String> headerLineList = new ArrayList<String>();
                boolean bDone = false;
                CommentGathererTopToBottom cg = new CommentGathererTopToBottom(bytes);
                while (!bDone) {
                    String line = cg.getNextLine();
                    if (line.startsWith(";")) {
                        if (line.startsWith(";+")) {
                            bHaveBeginTag = true;
                        }
                        if (bHaveBeginTag && line.startsWith(";-")) {
                            bHaveEndTag = true;
                        }
                        String aline = line.substring(1);
                        headerLineList.add(aline);
                        continue;
                    }
                    if (line.equals("done")) {
                        bDone = true;
                        continue;
                    }
                    if (line.length() <= 0 || line.startsWith(";")) continue;
                    bDone = true;
                }
                String newline = System.getProperty("line.separator");
                if (headerLineList.size() > 0 && bHaveBeginTag && bHaveEndTag) {
                    boolean bInsideIDLDoc = false;
                    int i = 0;
                    while (i < headerLineList.size()) {
                        String line = (String)headerLineList.get(i);
                        if (line.startsWith("+")) {
                            bInsideIDLDoc = true;
                        }
                        if (line.startsWith("-")) {
                            bInsideIDLDoc = false;
                        }
                        if (m_bIncludeAllCommentsAdjacentToProcedure || bInsideIDLDoc && !line.startsWith("+")) {
                            this.m_bRetrievedIDLDoc = true;
                            idlDocComments.append("  ");
                            idlDocComments.append(line);
                            idlDocComments.append(newline);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
        return idlDocComments;
    }

    private String buildSyntaxPortionOfDocString(boolean bFullHTMLSupport, boolean bIncludeKeywords) {
        IIDLKeyword[] keywords;
        int i;
        StringBuffer description = new StringBuffer();
        String breakSpace = "<p>&#160; &#160;";
        if (bFullHTMLSupport) {
            description.append("<h1>Syntax</h1><p>");
        } else {
            description.append("<b>Syntax</b>");
            description.append(breakSpace);
        }
        IIDLDoc doc = this.getDoc();
        if (doc != null) {
            String syntax = doc.getSyntax();
            syntax = bFullHTMLSupport ? syntax.replaceAll("\n", "<br>") : syntax.replaceAll("\n", breakSpace);
            description.append(syntax);
        } else {
            IIDLParameter[] parameters = this.getParameters();
            if (this.isFunction()) {
                description.append("Result = " + this.getElementName() + "(");
            } else {
                description.append(this.getElementName());
                if (parameters.length > 0) {
                    description.append(", ");
                }
            }
            i = 0;
            while (i < parameters.length) {
                if (i > 0) {
                    description.append(", ");
                }
                description.append(parameters[i].getElementName());
                ++i;
            }
            if (this.isFunction()) {
                if (parameters.length == 0) {
                    description.append(' ');
                }
                description.append(')');
            }
        }
        if (bFullHTMLSupport) {
            description.append("</p>");
        } else {
            description.append("<br>");
        }
        if (bIncludeKeywords && (keywords = this.getKeywords()).length > 0) {
            if (bFullHTMLSupport) {
                description.append("<h1>Keywords</h1><p>");
            } else {
                description.append("<br><b>Keywords</b>");
                description.append(breakSpace);
            }
            i = 0;
            while (i < keywords.length) {
                if (i > 0) {
                    description.append(bFullHTMLSupport ? "<br>" : breakSpace);
                }
                description.append(keywords[i].getElementName());
                String varName = keywords[i].getVariableName();
                if (varName != null) {
                    description.append(" = ");
                    description.append(varName);
                }
                ++i;
            }
            if (bFullHTMLSupport) {
                description.append("</p>");
            } else {
                description.append("<br>");
            }
        }
        return description.toString();
    }

    public String getDocString(boolean bFullHTMLSupport) {
        String idlDocString = null;
        StringBuffer idlDocComments = this.readRoutineCommentBlockBelowRoutineFromDisk();
        if (idlDocComments.length() == 0) {
            idlDocComments = this.readRoutineCommentBlockAboveRoutineFromDisk();
        }
        if (this.m_bRetrievedIDLDoc) {
            if (bFullHTMLSupport) {
                idlDocString = this.m_text2HTMLConverter.getHTML(idlDocComments.toString());
            } else {
                idlDocComments.insert(0, "<br><b>Documentation</b><br/><pre>");
                idlDocComments.append("</pre>");
                idlDocString = idlDocComments.toString();
            }
        }
        String docString = this.buildSyntaxPortionOfDocString(bFullHTMLSupport, !this.m_bRetrievedIDLDoc);
        if (idlDocString != null) {
            docString = String.valueOf(docString) + idlDocString;
        }
        return docString;
    }

    protected void buildIDLDocTagHashSet() {
        m_idlDocTagHashSet = new HashSet();
        m_idlDocTagHashSet.add("@abstract");
        m_idlDocTagHashSet.add("@author");
        m_idlDocTagHashSet.add("@bugs");
        m_idlDocTagHashSet.add("@categories");
        m_idlDocTagHashSet.add("@copyright");
        m_idlDocTagHashSet.add("@customer_id");
        m_idlDocTagHashSet.add("@examples");
        m_idlDocTagHashSet.add("@field");
        m_idlDocTagHashSet.add("@hidden");
        m_idlDocTagHashSet.add("@history");
        m_idlDocTagHashSet.add("@inherits");
        m_idlDocTagHashSet.add("@keyword");
        m_idlDocTagHashSet.add("@obsolete");
        m_idlDocTagHashSet.add("@param");
        m_idlDocTagHashSet.add("@pre");
        m_idlDocTagHashSet.add("@post");
        m_idlDocTagHashSet.add("@private");
        m_idlDocTagHashSet.add("@requires");
        m_idlDocTagHashSet.add("@restrictions");
        m_idlDocTagHashSet.add("@returns");
        m_idlDocTagHashSet.add("@todo");
        m_idlDocTagHashSet.add("@uses");
        m_idlDocTagHashSet.add("@version");
        m_idlDocTagHashSet.add("@file_comments");
        m_idlDocTagHashSet.add("@hidden_file");
        m_idlDocTagHashSet.add("@private_file");
        m_idlDocTagHashSet.add("@dir");
    }

    public String getFilename() {
        String filename = null;
        IIDLCompilationUnit cu = this.getCompilationUnit();
        IDOMFile domFile = cu.getDOMFile();
        if (domFile != null) {
            filename = domFile.getCanonicalPath();
        }
        return filename;
    }

    public int getElementType() {
        return 5;
    }

    public String getElementDebugName() {
        return "Meth:" + this.getElementName();
    }

    public String toString() {
        return "Routine [" + (this.m_isFunction ? "function" : "procedure") + " '" + this.m_name + "']";
    }

    protected class CommentGathererBottomToTop {
        private int m_offset;
        private char[] m_bytes;

        public CommentGathererBottomToTop(char[] bytes) {
            this.m_offset = bytes.length <= 0 ? 0 : bytes.length - 1;
            this.m_bytes = bytes;
            int i = this.m_offset;
            while (i >= 0) {
                if (this.m_bytes[i] == '\n') {
                    i = i - 1 >= 0 ? i - 1 : i;
                    break;
                }
                --i;
            }
            this.m_offset = i < 0 ? 0 : i;
        }

        public String getNextLine() {
            StringBuffer sb = new StringBuffer();
            if (this.m_bytes[this.m_offset] == '\r') {
                --this.m_offset;
                int n = this.m_offset = this.m_offset < 0 ? 0 : this.m_offset;
            }
            if (this.m_offset == 0) {
                return "done";
            }
            int i = this.m_offset;
            while (i >= 0) {
                if (this.m_bytes[i] == '\n') {
                    if (i - 1 >= 0 && this.m_bytes[i - 1] == '\r') {
                        --i;
                    }
                    this.m_offset = i - 1;
                    this.m_offset = this.m_offset < 0 ? 0 : this.m_offset;
                    break;
                }
                sb.append(this.m_bytes[i]);
                --i;
            }
            if (i == -1) {
                this.m_offset = 0;
            }
            sb.reverse();
            String finalLine = sb.toString().trim();
            return finalLine;
        }
    }

    protected class CommentGathererTopToBottom {
        private int m_offset = 0;
        private char[] m_bytes;

        public CommentGathererTopToBottom(char[] bytes) {
            this.m_bytes = bytes;
            String lineStr = this.getNextLine();
            if (lineStr.endsWith("$")) {
                lineStr = this.getNextLine();
                while (!lineStr.equals("done")) {
                    if (!lineStr.endsWith("$") && !lineStr.startsWith(";") && lineStr.length() != 0) break;
                    lineStr = this.getNextLine();
                }
            }
        }

        public String getNextLine() {
            StringBuffer sb = new StringBuffer();
            if (this.m_offset == this.m_bytes.length) {
                return "done";
            }
            int i = this.m_offset;
            while (i < this.m_bytes.length) {
                if (this.m_bytes[i] == '\r' && ++i == this.m_bytes.length) break;
                if (this.m_bytes[i] == '\n') {
                    this.m_offset = ++i;
                    break;
                }
                sb.append(this.m_bytes[i]);
                ++i;
            }
            String finalLine = sb.toString().trim();
            return finalLine;
        }
    }
}

