/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.dom;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.Messages;
import com.rsi.idldt.core.dom.IDOMFile;
import com.rsi.idldt.core.dom.IDOMJob;
import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.IIDLDOMListener;
import com.rsi.idldt.core.dom.IIDLDOMManager;
import com.rsi.idldt.core.dom.IIDLRoutine;
import com.rsi.idldt.core.dom.IIDLScopeVar;
import com.rsi.idldt.core.dom.IIDLStructure;
import com.rsi.idldt.core.dom.IIDLSysVar;
import com.rsi.idldt.core.internal.dom.DOMFile;
import com.rsi.idldt.core.internal.dom.DOMRoutineList;
import com.rsi.idldt.core.internal.dom.DOMScopeVarList;
import com.rsi.idldt.core.internal.dom.DOMStructureList;
import com.rsi.idldt.core.internal.dom.DOMSysVarList;
import com.rsi.idldt.core.internal.dom.IDLCatalogParser;
import com.rsi.idldt.core.internal.dom.IDLCompilationUnit;
import com.rsi.idldt.core.internal.dom.IDLField;
import com.rsi.idldt.core.internal.dom.IDLStructure;
import com.rsi.idldt.core.internal.parser.IDLLexer;
import com.rsi.idldt.core.internal.parser.IDLParser;
import com.rsi.idldt.core.projects.IIDLProjectManager;
import com.rsi.idldt.core.utils.Tracer;
import com.rsi.idldt.debug.internal.model.IDLDebugTarget;
import com.rsi.idldt.debug.internal.model.IDLStackFrame;
import com.rsi.idldt.debug.internal.model.IDLThread;
import com.rsi.idldt.debug.internal.model.IDLVariable;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDLDOMManager
implements IIDLDOMManager,
IDebugEventSetListener {
    FileMap m_fileMap = new FileMap(10000);
    private static final String IDL_CORE_KEY = "IDL_CORE";
    private DOMRoutineList m_routineList = new DOMRoutineList();
    private DOMStructureList m_structureList = new DOMStructureList();
    private DOMSysVarList m_sysVarList = new DOMSysVarList();
    private DOMScopeVarList m_scopeVarList = new DOMScopeVarList();
    private Vector<IIDLDOMListener> m_listeners = new Vector(8);
    volatile boolean m_isNotificationNeeded = false;
    private Timer m_notificationTimer = new Timer(true);
    private final long m_notificationFrequency = 5000L;
    private ProgressJob m_progressJob;
    private final long m_jobThreshold = 100L;
    private final long m_monitorWaitTime = 100L;
    LinkedList<IDOMJob> m_queue;
    private Object m_queueLock;
    private DOMWorker[] m_worker;
    long m_streamOpen;
    long m_createParser;
    long m_parseStream;
    long m_synchLists;
    long m_totalTime;

    public IDLDOMManager() {
        this.m_notificationTimer.scheduleAtFixedRate((TimerTask)new ChangeNotificationTask(this), 0L, 5000L);
        this.m_queue = new LinkedList();
        this.m_queueLock = this;
        int n = Runtime.getRuntime().availableProcessors();
        this.m_worker = new DOMWorker[n];
        int i = 0;
        while (i < n) {
            this.m_worker[i] = new DOMWorker(this.m_queueLock, i, i == 0);
            this.m_worker[i].start();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(IIDLDOMListener listener) {
        Vector<IIDLDOMListener> vector = this.m_listeners;
        synchronized (vector) {
            if (listener != null && !this.m_listeners.contains(listener)) {
                this.m_listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IIDLDOMListener listener) {
        Vector<IIDLDOMListener> vector = this.m_listeners;
        synchronized (vector) {
            this.m_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListeners() {
        Vector<IIDLDOMListener> vector = this.m_listeners;
        synchronized (vector) {
            int n = this.m_listeners.size();
            int i = 0;
            while (i < n) {
                this.m_listeners.get(i).IDLDOMChanged(this);
                ++i;
            }
        }
    }

    @Override
    public synchronized void addResource(IResource r) {
        if (r instanceof IFile) {
            this.m_queue.add(new DOMJobAddFile((IFile)r, this));
            this.notifyAll();
        }
    }

    @Override
    public synchronized void removeResource(IResource r) {
        if (r instanceof IFile) {
            this.m_queue.add(new DOMJobRemoveFile((IFile)r));
            this.notifyAll();
        }
    }

    @Override
    public synchronized void parseCompilationUnit(IFile f) {
        this.m_queue.add(new DOMJobParse(f));
        this.notifyAll();
    }

    @Override
    public synchronized void parseCompilationUnit(File f) {
        this.m_queue.add(new DOMJobParse(f));
        this.notifyAll();
    }

    @Override
    public synchronized void parseCompilationUnitNow(IFile f) {
        this.m_queue.addFirst(new DOMJobNotifyChangeListeners());
        this.m_queue.addFirst(new DOMJobParse(f));
        this.notifyAll();
    }

    @Override
    public synchronized void parseCompilationUnitNow(File f) {
        this.m_queue.addFirst(new DOMJobNotifyChangeListeners());
        this.m_queue.addFirst(new DOMJobParse(f));
        this.notifyAll();
    }

    @Override
    public synchronized void addDirectory(String directory) {
        this.m_queue.add(new DOMJobAddDirectory(directory, this));
        this.notifyAll();
    }

    @Override
    public synchronized void removeDirectory(String directory) {
        this.m_queue.add(new DOMJobRemoveDirectory(directory, this));
        this.notifyAll();
    }

    @Override
    public synchronized void addFile(File file) {
        this.m_queue.add(new DOMJobAddFile(file, this));
        this.notifyAll();
    }

    @Override
    public synchronized void removeFile(File file) {
        this.m_queue.add(new DOMJobRemoveFile(file));
        this.notifyAll();
    }

    @Override
    public synchronized void addEditor(Object file) {
        if (file instanceof IFile) {
            this.m_queue.addFirst(new DOMJobAddFile((IFile)file, this));
            this.notifyAll();
        } else if (file instanceof File) {
            this.m_queue.addFirst(new DOMJobAddFile((File)file, this));
            this.notifyAll();
        }
    }

    @Override
    public synchronized void removeEditor(Object file) {
        if (file instanceof IFile) {
            this.m_queue.add(new DOMJobRemoveFile((IFile)file));
            this.notifyAll();
        } else if (file instanceof File) {
            this.m_queue.add(new DOMJobRemoveFile((File)file));
            this.notifyAll();
        }
    }

    @Override
    public synchronized void addCoreCompilationUnit(IIDLCompilationUnit cu) {
        this.m_queue.addFirst(new DOMJobAddCore(cu));
        this.notifyAll();
    }

    @Override
    public synchronized void initialize() {
        this.m_queue.addFirst(new DOMJobInitialize(this));
        this.notifyAll();
    }

    @Override
    public synchronized void unserialize() {
    }

    @Override
    public synchronized void serialize() {
    }

    @Override
    public synchronized void clear() {
        this.m_queue.clear();
        this.m_queue.add(new DOMJobClear());
        this.notifyAll();
    }

    @Override
    public synchronized void syncLists() {
    }

    @Override
    public synchronized void synchronizeWithFileSystem() {
    }

    public static IIDLCompilationUnit temporaryParseString(String contents) {
        return IDLDOMManager.doTemporaryParseString(contents);
    }

    @Override
    public Collection<IIDLCompilationUnit> getAllCompilationUnits() {
        return this.m_fileMap.getValues();
    }

    @Override
    public IIDLCompilationUnit[] getAllCompilationUnitsAsArray() {
        Collection<IIDLCompilationUnit> c = this.getAllCompilationUnits();
        return c.toArray(new IIDLCompilationUnit[c.size()]);
    }

    @Override
    public IIDLCompilationUnit getCompilationUnit(IFile f) {
        return this.doGetCompilationUnit(f);
    }

    @Override
    public IIDLCompilationUnit getCompilationUnit(File f) {
        return this.doGetCompilationUnit(f);
    }

    @Override
    public void visitDescendantsOfType(IDOMNode n, int t, Object o, Method m, Object callData) {
        n.visitDescendantsOfType(t, o, m, callData);
    }

    @Override
    public IIDLRoutine[] findRoutines(String name, int theFlags) {
        int flags = theFlags;
        if (flags == 0) {
            flags = 127;
        }
        return this.m_routineList.findRoutines(name, flags);
    }

    @Override
    public IIDLStructure[] findStructures(String name, int theFlags) {
        int flags = theFlags;
        if (flags == 0) {
            flags = 127;
        }
        return this.m_structureList.findStructures(name, flags);
    }

    @Override
    public String[] getClassNames() {
        return this.m_structureList.getClassNames();
    }

    @Override
    public IIDLSysVar[] findSystemVariables(String name, int theFlags) {
        int flags = theFlags;
        if (flags == 0) {
            flags = 127;
        }
        flags &= 0xFFFFFFEF;
        flags &= 0xFFFFFFBF;
        return this.m_sysVarList.findSystemVariables(name, flags |= 0x20);
    }

    @Override
    public IIDLScopeVar[] findScopeVariables(String name, int flags) {
        return this.m_scopeVarList.findScopeVariables(name, flags);
    }

    public static IIDLDOMManager getActiveManager() {
        IIDLProjectManager projectManager;
        IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
        if (idl != null && (projectManager = idl.getProjectManager()) != null) {
            return projectManager.getDOMManager();
        }
        return null;
    }

    @Override
    @Deprecated
    public File getSerializedDOM() {
        return null;
    }

    @Override
    @Deprecated
    public boolean writeSerializedDOM() {
        return false;
    }

    @Override
    @Deprecated
    public boolean readSerializedDOM() {
        return false;
    }

    @Override
    public void parseFile(IFile f) {
        this.doParseFile(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitUntilIdle() {
        boolean idle;
        do {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Object e = this.m_queueLock;
            synchronized (e) {
                idle = this.m_queue.isEmpty();
            }
            int i = 0;
            while (idle && i < this.m_worker.length) {
                idle = idle && this.m_worker[i].isIdle();
                ++i;
            }
        } while (!idle);
    }

    void updateProgress(boolean blessed) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        if (!blessed) {
            return;
        }
        if (this.m_progressJob != null && this.m_progressJob.getState() == 0) {
            this.m_progressJob = null;
        }
        int n = this.m_queue.size();
        if (this.m_progressJob == null && (long)n >= 100L) {
            this.m_progressJob = new ProgressJob(Messages.IDLDOMManager_ProgressDescription);
            this.m_progressJob.schedule();
        }
    }

    void doAddDirectory(String directory, IIDLDOMManager manager) {
        File dir = new File(directory);
        File[] children = dir.listFiles(new ProFilter());
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                manager.addFile(children[i]);
                ++i;
            }
        }
    }

    void doRemoveDirectory(String directory, IIDLDOMManager manager) {
        File dir = new File(directory);
        File[] children = dir.listFiles(new ProFilter());
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                manager.removeFile(children[i]);
                ++i;
            }
        }
    }

    void doCreateCoreCompilationUnit(IIDLCompilationUnit cu) {
        if (cu != null) {
            this.m_fileMap.add(IDL_CORE_KEY, cu);
            this.m_routineList.sync(cu, true);
            this.m_structureList.sync(cu, true);
            this.m_sysVarList.sync(cu, true);
            this.m_scopeVarList.sync(cu, true);
        }
    }

    IIDLCompilationUnit doCreateCompilationUnit(Object f) {
        IDLCompilationUnit cu = null;
        if (f instanceof IFile) {
            cu = new IDLCompilationUnit((IFile)f, ((IFile)f).getName());
        } else if (f instanceof File) {
            cu = new IDLCompilationUnit((File)f, ((File)f).getName());
        } else {
            return null;
        }
        IDOMFile df = cu.getDOMFile();
        String path = df.getCanonicalPath();
        this.m_fileMap.add(path, cu);
        return cu;
    }

    void doRemoveCompilationUnit(IIDLCompilationUnit cu) {
        if (cu != null) {
            IDOMFile df = cu.getDOMFile();
            String path = df.getCanonicalPath();
            this.m_fileMap.remove(path);
            this.m_routineList.sync(cu, false);
            this.m_structureList.sync(cu, false);
            this.m_scopeVarList.sync(cu, false);
        }
    }

    synchronized void parseCompilationUnit(IIDLCompilationUnit cu) {
        this.m_queue.add(new DOMJobParse(cu));
        this.notifyAll();
    }

    private void doParseFile(Object f) {
        IIDLCompilationUnit cu = null;
        if (f instanceof IFile || f instanceof File) {
            cu = this.m_fileMap.get(DOMFile.getCanonicalPath(f));
        }
        if (cu != null) {
            this.doParseCompilationUnit(cu);
        }
    }

    void doParseCompilationUnit(IIDLCompilationUnit cu) {
        block19: {
            if (cu == null) {
                return;
            }
            Object f = cu.getDOMFile().getFile();
            if (f instanceof IFile && !((IFile)f).exists() || f instanceof File && !((File)f).exists()) {
                return;
            }
            cu.setHasMainProg(false);
            if (cu.hasChildren()) {
                this.m_routineList.sync(cu, false);
                this.m_structureList.sync(cu, false);
                cu.removeChildren();
            }
            long t0 = Tracer.IS_DEBUGGING ? System.currentTimeMillis() : 0L;
            BufferedInputStream stream = null;
            try {
                try {
                    if (f instanceof IFile) {
                        stream = new BufferedInputStream(((IFile)f).getContents());
                    } else if (f instanceof File) {
                        stream = new BufferedInputStream(new FileInputStream((File)f));
                    }
                    long t1 = Tracer.IS_DEBUGGING ? System.currentTimeMillis() : 0L;
                    IDLLexer lexer = new IDLLexer(stream);
                    IDLParser parser = new IDLParser(lexer, cu);
                    parser.setFilename(f.toString());
                    long t2 = Tracer.IS_DEBUGGING ? System.currentTimeMillis() : 0L;
                    parser.compilationUnit();
                    long t3 = Tracer.IS_DEBUGGING ? System.currentTimeMillis() : 0L;
                    this.m_routineList.sync(cu, true);
                    this.m_structureList.sync(cu, true);
                    this.m_scopeVarList.sync(cu, true);
                    if (Tracer.IS_DEBUGGING) {
                        long t4 = System.currentTimeMillis();
                        this.m_streamOpen += t1 - t0;
                        this.m_createParser += t2 - t1;
                        this.m_parseStream += t3 - t2;
                        this.m_synchLists += t4 - t3;
                        this.m_totalTime += t4 - t0;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (stream == null) break block19;
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static IIDLCompilationUnit doTemporaryParseString(String contents) {
        IDLCompilationUnit cu = new IDLCompilationUnit("temp");
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes());
            IDLLexer lexer = new IDLLexer(stream);
            IDLParser parser = new IDLParser(lexer, cu);
            parser.compilationUnit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cu;
    }

    void freeDOM() {
        this.m_fileMap.clear();
        this.m_routineList.clear();
        this.m_structureList.clear();
        this.m_sysVarList.clear();
        this.m_scopeVarList.clear();
        IDLStructure.reset();
        IDLField.reset();
    }

    boolean isProFile(Object f) {
        boolean result = false;
        try {
            String p = DOMFile.getCanonicalPath(f);
            String extension = p.substring(p.length() - 4);
            result = extension.equalsIgnoreCase(".pro");
        }
        catch (Exception exception) {}
        return result;
    }

    private IIDLCompilationUnit doGetCompilationUnit(Object f) {
        IIDLCompilationUnit cu = null;
        if (f instanceof IFile) {
            cu = this.m_fileMap.get((IFile)f);
        } else if (f instanceof File) {
            cu = this.m_fileMap.get((File)f);
        }
        return cu;
    }

    @Override
    public void updateVariables() {
        IDLStackFrame topFrame;
        IDLThread thread;
        IDLDebugTarget debugTarget;
        IIDLProcessProxy processProxy = IDLProcessManager.getActiveProcess();
        if (processProxy != null && (debugTarget = processProxy.getDebugTarget()) != null && (thread = debugTarget.getThread()) != null && (topFrame = thread.getTopIDLStackFrame()) != null) {
            String frameName = topFrame.getName();
            List<IDLVariable> varList = debugTarget.getIDLScopeVariables();
            IIDLCompilationUnit cu = null;
            if ("$MAIN$".equals(frameName)) {
                cu = this.m_fileMap.get(IDL_CORE_KEY);
            } else {
                String pathString = topFrame.getFilePath();
                File file = new File(pathString);
                cu = this.getCompilationUnit(file);
            }
            if (cu != null) {
                this.m_scopeVarList.clear();
                cu.clearScopeVariables();
                for (IDLVariable v : varList) {
                    cu.createScopeVariable(v.getName());
                }
                this.m_scopeVarList.sync(cu, true);
            }
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            int kind = events[i].getKind();
            if (kind == 4 || kind == 16 || kind == 2 || kind == 1) {
                this.updateVariables();
                break;
            }
            ++i;
        }
    }

    private class ChangeNotificationTask
    extends TimerTask {
        private Object m_queueLock1;

        public ChangeNotificationTask(Object lock) {
            this.m_queueLock1 = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (IDLDOMManager.this.m_isNotificationNeeded) {
                Object object = this.m_queueLock1;
                synchronized (object) {
                    DOMJobNotifyChangeListeners job = new DOMJobNotifyChangeListeners();
                    if (IDLDOMManager.this.m_queue.size() < 10) {
                        IDLDOMManager.this.m_queue.addLast(job);
                    } else {
                        IDLDOMManager.this.m_queue.addFirst(job);
                    }
                    this.m_queueLock1.notifyAll();
                    IDLDOMManager.this.m_isNotificationNeeded = false;
                    if (Tracer.IS_DEBUGGING && IDLDOMManager.this.m_queue.size() == 1 && IDLDOMManager.this.m_totalTime > 0L) {
                        System.out.println("Total time: " + (double)IDLDOMManager.this.m_totalTime / 1000.0);
                        System.out.println("  Open Stream: " + (double)IDLDOMManager.this.m_streamOpen / 1000.0 + " (" + 100.0 * (double)IDLDOMManager.this.m_streamOpen / (double)IDLDOMManager.this.m_totalTime + "%)");
                        System.out.println("  Create Parser: " + (double)IDLDOMManager.this.m_createParser / 1000.0 + " (" + 100.0 * (double)IDLDOMManager.this.m_createParser / (double)IDLDOMManager.this.m_totalTime + "%)");
                        System.out.println("  Parse: " + (double)IDLDOMManager.this.m_parseStream / 1000.0 + " (" + 100.0 * (double)IDLDOMManager.this.m_parseStream / (double)IDLDOMManager.this.m_totalTime + "%)");
                        System.out.println("  Synch Lists: " + (double)IDLDOMManager.this.m_synchLists / 1000.0 + " (" + 100.0 * (double)IDLDOMManager.this.m_synchLists / (double)IDLDOMManager.this.m_totalTime + "%)");
                        IDLDOMManager.this.m_streamOpen = 0L;
                        IDLDOMManager.this.m_createParser = 0L;
                        IDLDOMManager.this.m_parseStream = 0L;
                        IDLDOMManager.this.m_synchLists = 0L;
                        IDLDOMManager.this.m_totalTime = 0L;
                    }
                }
            }
        }
    }

    private class DOMJobAddCore
    extends DOMJobWriter {
        private IIDLCompilationUnit m_cu;

        public DOMJobAddCore(IIDLCompilationUnit cu) {
            this.m_cu = cu;
        }

        public void execute() {
            IDLDOMManager.this.doCreateCoreCompilationUnit(this.m_cu);
        }
    }

    private class DOMJobAddDirectory
    extends DOMJobWriter {
        private String m_directory;
        private IDLDOMManager m_manager;

        public DOMJobAddDirectory(String s, IDLDOMManager m) {
            this.m_manager = m;
            this.m_directory = s;
        }

        public void execute() {
            IDLDOMManager.this.doAddDirectory(this.m_directory, this.m_manager);
        }
    }

    class DOMJobAddFile
    extends DOMJobWriter {
        private IDLDOMManager m_manager;
        private Object m_file;

        DOMJobAddFile(IFile f, IDLDOMManager m) {
            this.m_manager = m;
            this.m_file = f;
        }

        DOMJobAddFile(File f, IDLDOMManager m) {
            this.m_manager = m;
            this.m_file = f;
        }

        public void execute() {
            if (IDLDOMManager.this.isProFile(this.m_file)) {
                IIDLCompilationUnit cu;
                IIDLCompilationUnit iIDLCompilationUnit = cu = this.m_file instanceof IFile ? IDLDOMManager.this.m_fileMap.get((IFile)this.m_file) : IDLDOMManager.this.m_fileMap.get((File)this.m_file);
                if (cu == null) {
                    cu = IDLDOMManager.this.doCreateCompilationUnit(this.m_file);
                    if (cu == null) {
                        return;
                    }
                    this.m_manager.parseCompilationUnit(cu);
                }
                IDOMFile df = cu.getDOMFile();
                df.incrementReferenceCount();
                if (this.m_file instanceof IFile) {
                    String path = df.getCanonicalPath();
                    IDLDOMManager.this.m_fileMap.add((IFile)this.m_file, path);
                }
            }
        }
    }

    class DOMJobClear
    extends DOMJobWriter {
        DOMJobClear() {
        }

        public void execute() {
            IDLDOMManager.this.freeDOM();
        }
    }

    private class DOMJobInitialize
    extends DOMJobWriter {
        private IDLDOMManager m_manager;

        public DOMJobInitialize(IDLDOMManager m) {
            this.m_manager = m;
        }

        public void execute() {
            IDLCatalogParser.parseCatalog(this.m_manager);
        }
    }

    class DOMJobNotifyChangeListeners
    extends DOMJobReader {
        DOMJobNotifyChangeListeners() {
        }

        public void execute() {
            IDLDOMManager.this.notifyListeners();
        }
    }

    private class DOMJobParse
    extends DOMJobWriter {
        private IIDLCompilationUnit m_cu;

        public DOMJobParse(IFile f) {
            this.m_cu = IDLDOMManager.this.m_fileMap.get(f);
        }

        public DOMJobParse(File f) {
            this.m_cu = IDLDOMManager.this.m_fileMap.get(f);
        }

        public DOMJobParse(IIDLCompilationUnit cu) {
            this.m_cu = cu;
        }

        public boolean isParseJob() {
            return true;
        }

        public void execute() {
            IDLDOMManager.this.doParseCompilationUnit(this.m_cu);
        }
    }

    abstract class DOMJobReader
    implements IDOMJob {
        DOMJobReader() {
        }

        public boolean isParseJob() {
            return false;
        }

        public boolean isWriter() {
            return false;
        }
    }

    private class DOMJobRemoveDirectory
    extends DOMJobWriter {
        private String m_directory;
        private IDLDOMManager m_manager;

        public DOMJobRemoveDirectory(String s, IDLDOMManager m) {
            this.m_manager = m;
            this.m_directory = s;
        }

        public void execute() {
            IDLDOMManager.this.doRemoveDirectory(this.m_directory, this.m_manager);
        }
    }

    private class DOMJobRemoveFile
    extends DOMJobWriter {
        private Object m_file;

        public DOMJobRemoveFile(IFile f) {
            this.m_file = f;
        }

        public DOMJobRemoveFile(File f) {
            this.m_file = f;
        }

        public void execute() {
            IIDLCompilationUnit cu = null;
            if (this.m_file instanceof IFile) {
                cu = IDLDOMManager.this.m_fileMap.get((IFile)this.m_file);
            } else if (this.m_file instanceof File) {
                cu = IDLDOMManager.this.m_fileMap.get((File)this.m_file);
            }
            if (cu != null) {
                IDOMFile df = cu.getDOMFile();
                df.decrementReferenceCount();
                if (df.getReferenceCount() <= 0) {
                    IDLDOMManager.this.doRemoveCompilationUnit(cu);
                }
            }
            if (this.m_file instanceof IFile) {
                IDLDOMManager.this.m_fileMap.remove((IFile)this.m_file);
            }
        }
    }

    abstract class DOMJobWriter
    implements IDOMJob {
        DOMJobWriter() {
        }

        public boolean isParseJob() {
            return false;
        }

        public boolean isWriter() {
            return true;
        }
    }

    private class DOMWorker
    extends Thread {
        private Object m_queueLock1;
        private boolean m_blessed;
        private boolean m_idle;

        public DOMWorker(Object queueLock, int n) {
            this(queueLock, n, false);
        }

        public DOMWorker(Object queueLock, int n, boolean blessed) {
            this.setName("IDLDT DOM Worker-" + n);
            this.setDaemon(false);
            this.setPriority(1);
            this.m_queueLock1 = queueLock;
            this.m_blessed = blessed;
        }

        public void start() {
            super.start();
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.doWork();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doWork() throws InterruptedException {
            IDOMJob job;
            Object object = this.m_queueLock1;
            synchronized (object) {
                IDLDOMManager.this.updateProgress(this.m_blessed);
                this.m_idle = true;
                while (IDLDOMManager.this.m_queue.size() == 0) {
                    this.m_queueLock1.wait();
                }
                this.m_idle = false;
                job = IDLDOMManager.this.m_queue.getFirst();
                job = this.m_blessed || job.isParseJob() ? IDLDOMManager.this.m_queue.removeFirst() : null;
            }
            if (job != null) {
                job.execute();
                if (job.isWriter()) {
                    IDLDOMManager.this.m_isNotificationNeeded = true;
                }
            }
        }

        public boolean isIdle() {
            return this.m_idle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileMap {
        private HashMap<String, IIDLCompilationUnit> m_mapPath;
        private HashMap<IFile, String> m_mapIFile;

        public FileMap(int initialCapacity) {
            this.m_mapPath = new HashMap(initialCapacity);
            this.m_mapIFile = new HashMap(initialCapacity);
        }

        public synchronized void add(String canonicalPath, IIDLCompilationUnit cu) {
            this.m_mapPath.put(canonicalPath, cu);
        }

        public synchronized void add(IFile f, String canonicalPath) {
            this.m_mapIFile.put(f, canonicalPath);
        }

        public synchronized void remove(String canonicalPath) {
            this.m_mapPath.remove(canonicalPath);
        }

        public synchronized void remove(IFile f) {
            this.m_mapIFile.remove(f);
        }

        public synchronized IIDLCompilationUnit get(String canonicalPath) {
            return this.m_mapPath.get(canonicalPath);
        }

        public synchronized IIDLCompilationUnit get(IFile f) {
            String canonicalPath = DOMFile.getCanonicalPath(f);
            if (canonicalPath == null) {
                canonicalPath = this.m_mapIFile.get(f);
            }
            return this.m_mapPath.get(canonicalPath);
        }

        public synchronized IIDLCompilationUnit get(File f) {
            String canonicalPath = DOMFile.getCanonicalPath(f);
            return this.get(canonicalPath);
        }

        public synchronized Collection<IIDLCompilationUnit> getValues() {
            return this.m_mapPath.values();
        }

        public synchronized void clear() {
            this.m_mapPath.clear();
            this.m_mapIFile.clear();
        }
    }

    class ProFilter
    implements FilenameFilter {
        ProFilter() {
        }

        public boolean accept(File dir, String name) {
            String extension = "";
            try {
                extension = name.substring(name.length() - 4);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            return extension.toLowerCase().compareTo(".pro") == 0;
        }
    }

    private class ProgressJob
    extends Job {
        public ProgressJob(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            int top_count;
            int numberOfJobsInQueue;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            LinkedList<IDOMJob> e = IDLDOMManager.this.m_queue;
            synchronized (e) {
                numberOfJobsInQueue = IDLDOMManager.this.m_queue.size();
            }
            int last_count = top_count = numberOfJobsInQueue;
            monitor.beginTask(Messages.IDLDOMManager_ProgressDescription, top_count);
            do {
                e = IDLDOMManager.this.m_queue;
                synchronized (e) {
                    numberOfJobsInQueue = IDLDOMManager.this.m_queue.size();
                    monitor.subTask("" + numberOfJobsInQueue);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                int jobsCompleted = last_count - numberOfJobsInQueue;
                jobsCompleted = jobsCompleted > 0 ? jobsCompleted : 0;
                monitor.worked(jobsCompleted);
                last_count = numberOfJobsInQueue;
            } while (numberOfJobsInQueue > 0);
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

