/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.dom;

import com.rsi.idldt.core.dom.IDOMFile;
import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.IIDLRoutine;
import com.rsi.idldt.core.dom.IIDLScopeVar;
import com.rsi.idldt.core.dom.IIDLStructure;
import com.rsi.idldt.core.dom.IIDLSysVar;
import com.rsi.idldt.core.dom.ISourceCodeRange;
import com.rsi.idldt.core.internal.dom.DOMFile;
import com.rsi.idldt.core.internal.dom.IDLRoutine;
import com.rsi.idldt.core.internal.dom.IDLScopeVar;
import com.rsi.idldt.core.internal.dom.IDLStructure;
import com.rsi.idldt.core.internal.dom.IDLSysVar;
import com.rsi.idldt.core.internal.dom.LazyLoadable;
import com.rsi.idldt.core.internal.dom.SourceCodeRange;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class IDLCompilationUnit
extends LazyLoadable
implements IIDLCompilationUnit {
    private static final long serialVersionUID = 1L;
    protected String m_name;
    protected DOMFile m_file;
    protected int m_sourceLength;
    private boolean m_hasMainProg = false;

    public IDLCompilationUnit(IFile file, String name) {
        super(null);
        this.m_name = name;
        this.m_file = new DOMFile(file);
    }

    public IDLCompilationUnit(File file, String name) {
        super(null);
        this.m_name = name;
        this.m_file = new DOMFile(file);
    }

    public IDLCompilationUnit(String name) {
        super(null);
        this.m_name = name;
        this.m_file = null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IDLCompilationUnit)) {
            return false;
        }
        return super.equals(obj);
    }

    public boolean exists() {
        return true;
    }

    public String getElementName() {
        return this.m_name;
    }

    public String getElementDebugName() {
        return "CU:" + this.m_name;
    }

    public int getElementType() {
        return 1;
    }

    public IPath getResourcePath() {
        return this.m_file.getResourcePath();
    }

    public IResource getResource() {
        return this.m_file.getResource();
    }

    public boolean isResource() {
        return this.m_file.isResource();
    }

    public IDOMFile getDOMFile() {
        return this.m_file;
    }

    public void setDOMFile(IDOMFile file) {
        this.m_file = (DOMFile)file;
    }

    public IIDLRoutine createRoutine(String name, boolean isFunction, int offset, int length, int nameOffset, int nameLen) {
        IDLRoutine routine = new IDLRoutine(this, name, isFunction, offset, length, nameOffset, nameLen);
        if (name != null && name.trim().length() > 0) {
            this.addChild(routine);
        }
        return routine;
    }

    public IIDLRoutine getRoutine(String name) {
        return (IIDLRoutine)this.getChildOfTypeAndName(5, name);
    }

    public IIDLRoutine[] getRoutines() {
        ArrayList<IDOMNode> list = this.getChildrenOfType(5);
        IIDLRoutine[] a = new IIDLRoutine[list.size()];
        list.toArray(a);
        return a;
    }

    public boolean hasRoutine() {
        ArrayList<IDOMNode> list = this.getChildrenOfType(5);
        return !list.isEmpty();
    }

    public IIDLSysVar createSystemVariable(String name) {
        IDLSysVar v = new IDLSysVar(this, name, -1, -1, -1, -1);
        this.addChild(v);
        return v;
    }

    public IIDLScopeVar createScopeVariable(String name) {
        IDLScopeVar v = new IDLScopeVar(this, name, -1, -1, -1, -1);
        this.addChild(v);
        return v;
    }

    public IIDLStructure createStructure(String name, int offset, int length, int nameOffset, int nameLen) {
        IDLStructure structure = new IDLStructure(this, name, offset, length, nameOffset, nameLen);
        this.addChild(structure);
        return structure;
    }

    public IIDLStructure getStructure(String name) {
        return (IIDLStructure)this.getChildOfTypeAndName(3, name);
    }

    public IIDLStructure[] getStructures() {
        ArrayList<IDOMNode> list = this.getChildrenOfType(3);
        IIDLStructure[] a = new IIDLStructure[list.size()];
        list.toArray(a);
        return a;
    }

    public boolean hasResourceChanged() {
        return false;
    }

    public ISourceCodeRange getSourceRange() {
        return new SourceCodeRange(0, this.m_sourceLength);
    }

    public IDOMNode[] codeSelect(int offset, int length) {
        return null;
    }

    public String toString() {
        return "CU ['" + this.m_name + "', '" + this.m_file + "']";
    }

    public IIDLRoutine getRoutineAt(int position) {
        IDOMNode[] children = this.getChildren();
        IIDLRoutine r = null;
        int i = 0;
        while (i < children.length) {
            ISourceCodeRange range;
            int offset;
            if (children[i] instanceof IIDLRoutine && position >= (offset = (range = (r = (IIDLRoutine)children[i]).getSourceRange()).getOffset()) && position <= offset + range.getLength()) {
                return r;
            }
            ++i;
        }
        return null;
    }

    public IIDLRoutine getRoutineClosestTo(int position) {
        IDOMNode[] children = this.getChildren();
        IIDLRoutine match = null;
        int i = children.length - 1;
        while (i >= 0) {
            if (children[i] instanceof IIDLRoutine) {
                ISourceCodeRange range;
                int end;
                IIDLRoutine r = (IIDLRoutine)children[i];
                if (match == null) {
                    match = r;
                }
                if (position <= (end = (range = r.getSourceRange()).getOffset() + range.getLength())) {
                    match = r;
                } else if (position > end) break;
            }
            --i;
        }
        return match;
    }

    public void setHasMainProg(boolean b) {
        this.m_hasMainProg = b;
    }

    public boolean hasMainProg() {
        return this.m_hasMainProg;
    }

    public void clearScopeVariables() {
        IDOMNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IIDLScopeVar) {
                this.removeChild(children[i]);
            }
            ++i;
        }
    }
}

