/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.dom;

import com.rsi.idldt.core.IDLDTCorePlugin;
import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.IIDLDOMManager;
import com.rsi.idldt.core.dom.IIDLDoc;
import com.rsi.idldt.core.dom.IIDLRoutine;
import com.rsi.idldt.core.dom.IIDLStructure;
import com.rsi.idldt.core.internal.dom.IDLCompilationUnit;
import com.rsi.idldt.core.utils.Tracer;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class IDLCatalogParser {
    private static final boolean DEBUG = false;
    private static IIDLCompilationUnit m_cu;
    private static ArrayList<String> m_initProperties;
    private static ArrayList<String> m_setProperties;
    private static ArrayList<String> m_getProperties;

    static {
        m_initProperties = new ArrayList();
        m_setProperties = new ArrayList();
        m_getProperties = new ArrayList();
    }

    public static void parseCatalog(IIDLDOMManager domManager) {
        File[] f = IDLCatalogParser.findCatalogFile();
        if (f == null) {
            return;
        }
        m_cu = new IDLCompilationUnit("Core");
        int i = 0;
        while (i < f.length) {
            Status status;
            try {
                if (f[i] != null && f[i].canRead()) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    long t0 = System.currentTimeMillis();
                    Document doc = builder.parse(f[i]);
                    long t1 = System.currentTimeMillis();
                    IDLCatalogParser.processCatalog(doc.getDocumentElement());
                    long t2 = System.currentTimeMillis();
                    domManager.addCoreCompilationUnit(m_cu);
                    Tracer.trace(Tracer.IS_DEBUGGING, "IDLCatalogParser: " + f[i] + " parse = " + (double)(t1 - t0) / 1000.0 + 's' + ", total = " + (double)(t2 - t0) / 1000.0 + 's');
                }
            }
            catch (SAXParseException e) {
                e.printStackTrace();
                status = new Status(4, "com.rsi.idldt.core", 0, "XML Error Parsing File: " + f[i].getName() + " - Line: " + e.getLineNumber() + ", Column: " + e.getColumnNumber() + "\n" + e.toString(), (Throwable)e);
                IDLDTCorePlugin.getDefault().getLog().log((IStatus)status);
            }
            catch (Exception e) {
                e.printStackTrace();
                status = new Status(4, "com.rsi.idldt.core", 0, "Error With File: " + f[i].getName() + "\n" + e.toString(), (Throwable)e);
                IDLDTCorePlugin.getDefault().getLog().log((IStatus)status);
            }
            ++i;
        }
    }

    private static File[] findCatalogFile() {
        File[] f = new File[2];
        String p = IDLProcessManager.getIdlDir();
        if (p != null) {
            String[] enviDirs;
            String fileSep = System.getProperty("file.separator");
            StringBuffer sb = new StringBuffer(p);
            sb.append(fileSep);
            sb.append("help");
            sb.append(fileSep);
            sb.append("idl_catalog.xml");
            f[0] = new File(sb.toString());
            sb = new StringBuffer(p);
            sb.append(fileSep);
            sb.append("products");
            File enviDir = new File(sb.toString());
            class Filter
            implements FilenameFilter {
                Filter() {
                }

                public boolean accept(File dir, String name) {
                    String filename = name.toLowerCase();
                    return filename.matches("envi[0-9]*");
                }
            }
            if (enviDir.exists() && (enviDirs = enviDir.list(new Filter())).length > 0) {
                sb.append(fileSep);
                sb.append(enviDirs[0]);
                sb.append(fileSep);
                sb.append("help");
                sb.append(fileSep);
                sb.append("envi_catalog.xml");
                f[1] = new File(sb.toString());
            }
        }
        return f;
    }

    private static void processCatalog(Node c) {
        NodeList children = c.getChildNodes();
        int n = children.getLength();
        int i = 0;
        while (i < n) {
            Node child = children.item(i);
            if (child instanceof Element) {
                IDLCatalogParser.processElement((Element)child);
            }
            ++i;
        }
    }

    private static void processElement(Element e) {
        String tagName = e.getTagName();
        if (tagName.compareTo("ROUTINE") == 0 || tagName.compareTo("METHOD") == 0) {
            IDLCatalogParser.processRoutine(e, false);
        } else if (tagName.compareTo("CLASS") == 0) {
            IDLCatalogParser.processClass(e);
        } else if (tagName.compareTo("SYSVAR") == 0) {
            IDLCatalogParser.processSysVar(e);
        }
    }

    private static void addRoutine(Element r, String routineName, boolean isFunction, String usage, boolean bAddUnderScoreExtraKeyword) {
        IDLCatalogParser.doPrintln(String.valueOf(isFunction ? "FUNCTION" : "PROCEDURE") + ": " + routineName);
        IIDLRoutine routine = m_cu.createRoutine(routineName, isFunction, -1, -1, -1, -1);
        if (usage != null) {
            IIDLDoc doc = routine.createDoc();
            doc.setSyntax(usage);
        }
        NodeList arguments = r.getElementsByTagName("ARGUMENT");
        int n = arguments.getLength();
        int i = 0;
        while (i < n) {
            Element arg = (Element)arguments.item(i);
            String argName = arg.getAttribute("name");
            routine.createParameter(argName, -1, -1, -1, -1);
            IDLCatalogParser.doPrintln("  ARGUMENT: " + argName);
            ++i;
        }
        NodeList keywords = r.getElementsByTagName("KEYWORD");
        n = keywords.getLength();
        int i2 = 0;
        while (i2 < n) {
            Element keyword = (Element)keywords.item(i2);
            String keyName = keyword.getAttribute("name");
            routine.createKeyword(keyName, null, -1, -1, -1, -1);
            IDLCatalogParser.doPrintln("  KEYWORD: " + keyName);
            ++i2;
        }
        if (m_initProperties.size() > 0 && routineName.toLowerCase().indexOf("::init") > -1) {
            for (String propName : m_initProperties) {
                routine.createKeyword(propName, null, -1, -1, -1, -1);
            }
        }
        if (m_getProperties.size() > 0 && routineName.toLowerCase().indexOf("::getproperty") > -1) {
            for (String propName : m_getProperties) {
                routine.createKeyword(propName, null, -1, -1, -1, -1);
            }
        }
        if (m_getProperties.size() > 0 && routineName.toLowerCase().indexOf("::setproperty") > -1) {
            for (String propName : m_setProperties) {
                routine.createKeyword(propName, null, -1, -1, -1, -1);
            }
        }
        if (bAddUnderScoreExtraKeyword) {
            IDLCatalogParser.addUnderscoreExtraKeywordToRoutine(routine);
        }
    }

    private static void processRoutine(Element r, boolean bAddUnderScoreExtraKeyword) {
        String routineNames = r.getAttribute("name");
        String aliasto = r.getAttribute("alias_to");
        if (aliasto.length() > 0) {
            return;
        }
        String usage = null;
        boolean isFunction = false;
        boolean isProcedure = false;
        NodeList syntaxes = r.getElementsByTagName("SYNTAX");
        if (syntaxes.getLength() > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < syntaxes.getLength()) {
                Element syntax = (Element)syntaxes.item(i);
                usage = syntax.getAttribute("name");
                if (usage.length() > 0) {
                    if (syntax.getAttribute("type").equals("func")) {
                        isFunction = true;
                    } else {
                        isProcedure = true;
                    }
                    if (i > 0) {
                        sb.append('\n');
                    }
                    sb.append(usage);
                }
                ++i;
            }
            if (sb.length() > 0) {
                usage = sb.toString();
            }
        }
        if (!isFunction) {
            isProcedure = true;
        }
        StringTokenizer st = new StringTokenizer(routineNames, "/");
        while (st.hasMoreTokens()) {
            String routineName = st.nextToken();
            if (isFunction) {
                IDLCatalogParser.addRoutine(r, routineName, true, usage, bAddUnderScoreExtraKeyword);
            }
            if (!isProcedure) continue;
            IDLCatalogParser.addRoutine(r, routineName, false, usage, bAddUnderScoreExtraKeyword);
        }
    }

    private static void addUnderscoreExtraKeywordToRoutine(IIDLRoutine routine) {
        if (routine.isClassMethod()) {
            routine.createKeyword("_extra", null, -1, -1, -1, -1);
        }
    }

    private static void processClass(Element c) {
        boolean bAddUnderScoreExtraKeyword = false;
        String className = c.getAttribute("name");
        IDLCatalogParser.doPrintln("CLASS: " + className);
        IIDLStructure structure = m_cu.createStructure(className, -1, -1, -1, -1);
        structure.setClass(true);
        NodeList superClasses = c.getElementsByTagName("SUPERCLASS");
        int n = superClasses.getLength();
        int i = 0;
        while (i < n) {
            Element superClass = (Element)superClasses.item(i);
            String superName = superClass.getAttribute("name");
            structure.createField(null, null, true, superName, -1, -1, -1, -1);
            IDLCatalogParser.doPrintln("  SUPERCLASS: " + superName);
            bAddUnderScoreExtraKeyword = true;
            ++i;
        }
        NodeList properties = c.getElementsByTagName("PROPERTY");
        n = properties.getLength();
        int i2 = 0;
        while (i2 < n) {
            String initProperty;
            String setProperty;
            Element property = (Element)properties.item(i2);
            String propertyName = property.getAttribute("name");
            structure.createField(propertyName, null, false, null, -1, -1, -1, -1);
            String getProperty = property.getAttribute("get");
            if (getProperty.equalsIgnoreCase("yes")) {
                m_getProperties.add(propertyName);
            }
            if ((setProperty = property.getAttribute("set")).equalsIgnoreCase("yes")) {
                m_setProperties.add(propertyName);
            }
            if ((initProperty = property.getAttribute("init")).equalsIgnoreCase("yes")) {
                m_initProperties.add(propertyName);
            }
            IDLCatalogParser.doPrintln("  PROPERTY: " + propertyName);
            ++i2;
        }
        NodeList methods = c.getElementsByTagName("METHOD");
        n = methods.getLength();
        int i3 = 0;
        while (i3 < n) {
            IDLCatalogParser.processRoutine((Element)methods.item(i3), bAddUnderScoreExtraKeyword);
            ++i3;
        }
        m_getProperties.clear();
        m_setProperties.clear();
        m_initProperties.clear();
    }

    private static void processSysVar(Element v) {
        String sysVarName = v.getAttribute("name");
        IDLCatalogParser.doPrintln("SYSVAR: " + sysVarName);
        m_cu.createSystemVariable(sysVarName);
        NodeList fields = v.getElementsByTagName("FIELD");
        int n = fields.getLength();
        if (n > 0) {
            IIDLStructure structure = m_cu.createStructure(sysVarName, -1, -1, -1, -1);
            structure.setClass(false);
            int i = 0;
            while (i < n) {
                Element field = (Element)fields.item(i);
                String fieldName = field.getAttribute("name");
                structure.createField(fieldName, null, false, null, -1, -1, -1, -1);
                IDLCatalogParser.doPrintln("  FIELD: " + fieldName);
                ++i;
            }
        }
    }

    private static void doPrintln(String s) {
    }
}

