/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.dom;

import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IIDLCUMember;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.ISourceCodeRange;
import com.rsi.idldt.core.internal.dom.DOMNode;
import com.rsi.idldt.core.internal.dom.SourceCodeRange;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public abstract class IDLCUMember
extends DOMNode
implements IIDLCUMember {
    private static final long serialVersionUID = 1L;
    protected String m_name;
    protected ISourceCodeRange m_sourceRange;
    protected ISourceCodeRange m_nameRange;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IDLCUMember) {
            IDLCUMember cu = (IDLCUMember)obj;
            if (this.getElementType() != cu.getElementType()) {
                return false;
            }
            if (this.m_name != null && this.m_nameRange != null) {
                return this.m_nameRange.equals(cu.getNameRange()) && this.m_name.equals(cu.getElementName());
            }
        }
        return super.equals(obj);
    }

    protected IDLCUMember(IDOMNode parent, String name, int offset, int length, int nameOffset, int nameLen) throws IllegalArgumentException {
        super(parent);
        this.m_name = name;
        this.m_nameRange = new SourceCodeRange(nameOffset, nameLen);
        this.m_sourceRange = new SourceCodeRange(offset, length);
    }

    public String getElementName() {
        return this.m_name;
    }

    public IIDLCompilationUnit getCompilationUnit() {
        return (IIDLCompilationUnit)this.getAncestor(1);
    }

    public ISourceCodeRange getSourceRange() {
        return this.m_sourceRange;
    }

    public IPath getResourcePath() {
        return this.getCompilationUnit().getResourcePath();
    }

    public IResource getResource() {
        return this.getCompilationUnit().getResource();
    }

    public boolean isResource() {
        return false;
    }

    public ISourceCodeRange getNameRange() {
        return this.m_nameRange;
    }

    public void setLength(int len) {
        this.m_sourceRange = new SourceCodeRange(this.m_sourceRange.getOffset(), len);
    }
}

