/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.dom;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.dom.IDOMFile;
import com.rsi.idldt.core.dom.IIDLStructure;
import com.rsi.idldt.core.internal.dom.DOMNodeList;
import com.rsi.idldt.core.internal.dom.IDLCompilationUnit;
import com.rsi.jdml.PlatformSupport;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class DOMStructureList
extends DOMNodeList {
    static String m_idlLibDir = null;

    public DOMStructureList() {
        super(3, 256, 128);
    }

    public static String getIDLLibDir() {
        if (m_idlLibDir == null) {
            String idldir = IDLProcessManager.getIdlDir();
            File file = new File(idldir);
            try {
                String pathSep = System.getProperty("file.separator");
                m_idlLibDir = String.valueOf(file.getCanonicalPath()) + pathSep;
            }
            catch (IOException iOException) {
                m_idlLibDir = idldir;
            }
            if (PlatformSupport.isWindows()) {
                m_idlLibDir = m_idlLibDir.toLowerCase();
            }
        }
        return m_idlLibDir;
    }

    public synchronized IIDLStructure[] getStructures() {
        return (IIDLStructure[])this.getListItemValues();
    }

    public synchronized IIDLStructure[] findStructures(String theKey, int flags) {
        DOMNodeList.Range range;
        Vector<IIDLStructure> v = new Vector<IIDLStructure>(256, 64);
        String key = theKey.toUpperCase();
        boolean doNames = (flags & 0x800) == 0;
        boolean doStarts = (flags & 0x200) != 0;
        boolean doNormal = (flags & 4) != 0;
        boolean doClass = (flags & 8) != 0;
        boolean doFiles = (flags & 0x10) != 0;
        boolean doInternal = (flags & 0x20) != 0;
        boolean doLibDir = (flags & 0x40) != 0;
        DOMNodeList.Range range2 = range = doNames ? this.findRange(key, doStarts) : new DOMNodeList.Range(0, this.m_list.size() - 1);
        if (range.first < 0 || range.last < 0) {
            return v.toArray(new IIDLStructure[0]);
        }
        int i = range.first;
        while (i <= range.last) {
            boolean ok;
            IIDLStructure s = (IIDLStructure)this.getItemValue(i);
            boolean isClassItem = s.isClass();
            boolean bl = ok = doNormal && !isClassItem || doClass && isClassItem;
            if (ok) {
                IDOMFile df = ((IDLCompilationUnit)s.getParent()).getDOMFile();
                boolean bl2 = ok = doFiles && df != null || doInternal && df == null;
                if (ok) {
                    if (!doLibDir) {
                        boolean bl3 = ok = !this.isStructureFromIDL_LIBDIR(s);
                    }
                    if (ok) {
                        v.add(s);
                    }
                }
            }
            ++i;
        }
        return v.toArray(new IIDLStructure[v.size()]);
    }

    public synchronized String[] getClassNames() {
        int n = this.m_list.size();
        Vector<String> v = new Vector<String>(n);
        int i = 0;
        while (i < n) {
            IIDLStructure s = (IIDLStructure)this.getItemValue(i);
            if (s.isClass() && !this.isStructureFromIDL_LIBDIR(s)) {
                v.add(s.getElementName());
            }
            ++i;
        }
        return v.toArray(new String[v.size()]);
    }

    private boolean isStructureFromIDL_LIBDIR(IIDLStructure s) {
        String struct_source_filename = s.getFilename();
        if (struct_source_filename == null) {
            return false;
        }
        if (PlatformSupport.isWindows()) {
            struct_source_filename = struct_source_filename.toLowerCase();
        }
        return struct_source_filename.startsWith(DOMStructureList.getIDLLibDir());
    }
}

