/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.dom;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.dom.IDOMFile;
import com.rsi.idldt.core.dom.IIDLRoutine;
import com.rsi.idldt.core.internal.dom.DOMNodeList;
import com.rsi.idldt.core.internal.dom.IDLCompilationUnit;
import com.rsi.jdml.PlatformSupport;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class DOMRoutineList
extends DOMNodeList {
    static String m_idlLibDir = null;

    public DOMRoutineList() {
        super(5, 8192, 1024);
    }

    public static String getIDLLibDir() {
        if (m_idlLibDir == null) {
            String idldir = IDLProcessManager.getIdlDir();
            File file = new File(idldir);
            try {
                String pathSep = System.getProperty("file.separator");
                m_idlLibDir = String.valueOf(file.getCanonicalPath()) + pathSep;
            }
            catch (IOException iOException) {
                m_idlLibDir = idldir;
            }
            if (PlatformSupport.isWindows()) {
                m_idlLibDir = m_idlLibDir.toLowerCase();
            }
        }
        return m_idlLibDir;
    }

    public synchronized IIDLRoutine[] findRoutines(String theKey, int flags) {
        DOMNodeList.Range range;
        boolean doNames = (flags & 0x800) == 0;
        boolean doStarts = (flags & 0x200) != 0;
        boolean doJustMethod = (flags & 0x400) != 0;
        boolean doProcedures = (flags & 1) != 0;
        boolean doFunctions = (flags & 2) != 0;
        boolean doNormal = (flags & 4) != 0;
        boolean doClass = (flags & 8) != 0;
        boolean doFiles = (flags & 0x10) != 0;
        boolean doInternal = (flags & 0x20) != 0;
        boolean doLibDir = (flags & 0x40) != 0;
        String key = theKey.toUpperCase();
        Vector<IIDLRoutine> v = new Vector<IIDLRoutine>(256, 128);
        DOMNodeList.Range range2 = range = !doNames || doJustMethod ? new DOMNodeList.Range(0, this.m_list.size() - 1) : this.findRange(key, doStarts);
        if (range.first < 0 || range.last < 0) {
            return v.toArray(new IIDLRoutine[v.size()]);
        }
        int i = range.first;
        while (i <= range.last) {
            block11: {
                boolean ok;
                IIDLRoutine r;
                block10: {
                    r = (IIDLRoutine)this.getItemValue(i);
                    if (!doNames || !doJustMethod) break block10;
                    String name = r.getRoutineName().toUpperCase();
                    boolean bl = ok = doStarts ? name.startsWith(key) : name.equals(key);
                    if (!ok) break block11;
                }
                boolean isFunction = r.isFunction();
                boolean bl = ok = doProcedures && !isFunction || doFunctions && isFunction;
                if (ok) {
                    boolean isClassItem = r.isClassMethod();
                    boolean bl2 = ok = doNormal && !isClassItem || doClass && isClassItem;
                    if (ok) {
                        IDOMFile df = ((IDLCompilationUnit)r.getParent()).getDOMFile();
                        boolean bl3 = ok = doFiles && df != null || doInternal && df == null;
                        if (ok) {
                            if (!doLibDir) {
                                boolean bl4 = ok = !this.isRoutineFromIDL_LIBDIR(df);
                            }
                            if (ok) {
                                v.add(r);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return v.toArray(new IIDLRoutine[v.size()]);
    }

    protected boolean isRoutineFromIDL_LIBDIR(IDOMFile df) {
        if (df == null) {
            return false;
        }
        String p = df.getCanonicalPath();
        if (PlatformSupport.isWindows()) {
            p = p.toLowerCase();
        }
        return p.startsWith(DOMRoutineList.getIDLLibDir());
    }
}

