/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.dom;

import com.rsi.idldt.core.dom.IDOMNode;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public abstract class DOMNodeList {
    protected int m_type;
    protected Vector<ListItem> m_list;
    protected Comparator<Object> m_sortComparator = new ListItemComparator();
    protected Method m_add;
    protected Method m_remove;

    public DOMNodeList(int type, int initialCapacity, int capacityIncrement) {
        this.m_type = type;
        this.m_list = new Vector(initialCapacity, capacityIncrement);
        this.m_add = this.lookupMethod("addToList");
        this.m_remove = this.lookupMethod("removeFromList");
    }

    protected synchronized Method lookupMethod(String methodName) {
        Class<?> c = this.getClass();
        Class[] parameterTypes = new Class[]{IDOMNode.class, Object.class};
        Method m = null;
        try {
            m = c.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return m;
    }

    public synchronized void sync(IDOMNode root, boolean adding) {
        Method m = adding ? this.m_add : this.m_remove;
        root.visitDescendantsOfType(this.m_type, this, m, null);
    }

    public synchronized Boolean addToList(IDOMNode n, Object callData) {
        String key = this.getNodeSortKey(n);
        int x = Collections.binarySearch(this.m_list, key, this.m_sortComparator);
        if (x < 0) {
            x = -x - 1;
        }
        this.m_list.add(x, this.createListItem(key, n));
        return Boolean.TRUE;
    }

    public synchronized Boolean removeFromList(IDOMNode n, Object callData) {
        Range r = this.findRange(this.getNodeSortKey(n));
        if (r.first >= 0) {
            if (r.first == r.last) {
                this.m_list.remove(r.first);
            } else {
                int i = r.first;
                while (i >= 0 && i <= r.last) {
                    if (this.m_list.get((int)i).m_value == n) {
                        this.m_list.remove(i);
                        break;
                    }
                    ++i;
                }
            }
        }
        return Boolean.TRUE;
    }

    public synchronized void clear() {
        this.m_list.clear();
    }

    public synchronized IDOMNode[] getListItemValues() {
        int n = this.m_list.size();
        IDOMNode[] nodes = new IDOMNode[n];
        int i = 0;
        while (i < n) {
            nodes[i] = this.m_list.get((int)i).m_value;
            ++i;
        }
        return nodes;
    }

    protected String getNodeSortKey(IDOMNode n) {
        return n.getElementName().toUpperCase();
    }

    protected synchronized Range findRange(String key) {
        return this.findRange(key, false);
    }

    protected synchronized Range findRange(String key, boolean startsWith) {
        String s;
        IDOMNode r;
        int x = Collections.binarySearch(this.m_list, key, this.m_sortComparator);
        boolean bNeverFoundMatch = false;
        if (x < 0) {
            bNeverFoundMatch = true;
        }
        if (!startsWith && x < 0) {
            return new Range(x, x);
        }
        int b = x >= 0 ? x : -x - 1;
        int a = b;
        while (a - 1 >= 0) {
            IDOMNode r2 = this.m_list.get((int)(a - 1)).m_value;
            String s2 = this.getNodeSortKey(r2);
            if (startsWith && !s2.startsWith(key) || !startsWith && s2.compareTo(key) != 0) break;
            --a;
            bNeverFoundMatch = false;
        }
        int n = this.m_list.size();
        while (b + 1 < n) {
            r = this.m_list.get((int)(b + 1)).m_value;
            s = this.getNodeSortKey(r);
            if (startsWith && !s.startsWith(key) || !startsWith && key.compareTo(s) != 0) break;
            ++b;
            bNeverFoundMatch = false;
        }
        if (bNeverFoundMatch) {
            if (a < this.m_list.size()) {
                r = this.m_list.get((int)a).m_value;
                s = this.getNodeSortKey(r);
                if (startsWith && s.startsWith(key)) {
                    return new Range(a, b);
                }
                return new Range(-1, -1);
            }
            return new Range(-a, -b);
        }
        return new Range(a, b);
    }

    protected synchronized ListItem createListItem(String key, IDOMNode n) {
        return new ListItem(key, n);
    }

    protected synchronized Object getItemKey(int i) {
        return this.m_list.get((int)i).m_key;
    }

    protected synchronized IDOMNode getItemValue(int i) {
        return this.m_list.get((int)i).m_value;
    }

    protected class ListItem {
        protected String m_key;
        protected IDOMNode m_value;

        public ListItem(String key, IDOMNode value) {
            this.m_key = key.toUpperCase();
            this.m_value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ListItemComparator
    implements Comparator<Object> {
        protected ListItemComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = o1 instanceof String ? (String)o1 : ((ListItem)o1).m_key;
            String s2 = o2 instanceof String ? (String)o2 : ((ListItem)o2).m_key;
            return s1.compareTo(s2);
        }
    }

    protected class Range {
        public int first;
        public int last;

        public Range(int a, int b) {
            this.first = a;
            this.last = b;
        }
    }
}

