/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.dom;

import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IParent;
import com.rsi.idldt.core.dom.ISourceCodeRange;
import com.rsi.idldt.core.dom.ISourceCodeReference;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DOMNode
implements IDOMNode,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final DOMNode[] NO_ELEMENTS = new DOMNode[0];
    protected IDOMNode m_parent;
    protected IDOMNode[] m_children;

    protected DOMNode(IDOMNode parent) throws IllegalArgumentException {
        this.m_parent = parent;
        this.m_children = NO_ELEMENTS;
    }

    protected IDOMNode[] growAndAddToArray(IDOMNode[] theArray, IDOMNode addition) {
        IDOMNode[] old = theArray;
        IDOMNode[] array = new IDOMNode[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected boolean includesChild(IDOMNode child) {
        int i = 0;
        while (i < this.m_children.length) {
            if (this.m_children[i].equals(child)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected IDOMNode[] removeAndShrinkArray(IDOMNode[] array, IDOMNode deletion) {
        int x = 0;
        while (x < array.length) {
            if (array[x].equals(deletion)) break;
            ++x;
        }
        if (x < array.length) {
            int n = array.length;
            if (n == 1) {
                return NO_ELEMENTS;
            }
            IDOMNode[] newArray = new IDOMNode[n - 1];
            if (x > 0) {
                System.arraycopy(array, 0, newArray, 0, x);
            }
            if (x < newArray.length) {
                System.arraycopy(array, x + 1, newArray, x, n - 1 - x);
            }
            return newArray;
        }
        return array;
    }

    @Override
    public void setChildren(IDOMNode[] children) {
        this.m_children = children;
    }

    @Override
    public void addChild(IDOMNode child) {
        if (this.m_children == NO_ELEMENTS) {
            this.setChildren(new IDOMNode[]{child});
        } else if (!this.includesChild(child)) {
            this.setChildren(this.growAndAddToArray(this.m_children, child));
        }
    }

    @Override
    public void removeChild(IDOMNode child) {
        if (this.includesChild(child)) {
            this.setChildren(this.removeAndShrinkArray(this.m_children, child));
        }
    }

    @Override
    public void removeChildren() {
        this.m_children = NO_ELEMENTS;
    }

    @Override
    public IDOMNode getAncestor(int ancestorType) {
        IDOMNode element = this;
        while (element != null) {
            if (element.getElementType() == ancestorType) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Override
    public ArrayList<IDOMNode> getChildrenOfType(int type) {
        IDOMNode[] children = this.getChildren();
        int size = children.length;
        ArrayList<IDOMNode> list = new ArrayList<IDOMNode>(size);
        int i = 0;
        while (i < size) {
            DOMNode elt = (DOMNode)children[i];
            if (elt.getElementType() == type) {
                list.add(elt);
            }
            ++i;
        }
        return list;
    }

    @Override
    public IDOMNode getChildOfTypeAndName(int type, String name) {
        IDOMNode[] children = this.getChildren();
        int size = children.length;
        int i = 0;
        while (i < size) {
            IDOMNode element = children[i];
            if (element.getElementType() == type && element.getElementName().equalsIgnoreCase(name)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IDOMNode getChildOfName(String name) {
        IDOMNode[] children = this.getChildren();
        int size = children.length;
        int i = 0;
        while (i < size) {
            if (children[i].getElementName().equalsIgnoreCase(name)) {
                return children[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean visitDescendantsOfType(int type, Object o, Method m, Object callData) {
        int n = this.m_children.length;
        boolean continueTraversal = true;
        int i = 0;
        while (i < n && continueTraversal) {
            int nodeType = this.m_children[i].getElementType();
            if (nodeType == type) {
                Object[] parameters = new Object[]{this.m_children[i], callData};
                try {
                    Boolean b = (Boolean)m.invoke(o, parameters);
                    continueTraversal = b;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    continueTraversal = false;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continueTraversal = false;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    continueTraversal = false;
                }
            }
            if (continueTraversal) {
                boolean descendIntoChildren;
                switch (nodeType) {
                    case 1: {
                        descendIntoChildren = true;
                        break;
                    }
                    case 5: {
                        descendIntoChildren = type == 6 || type == 7 || type == 8;
                        break;
                    }
                    case 3: {
                        descendIntoChildren = type == 2;
                        break;
                    }
                    default: {
                        descendIntoChildren = false;
                    }
                }
                if (descendIntoChildren) {
                    continueTraversal = this.m_children[i].visitDescendantsOfType(type, o, m, callData);
                }
            }
            ++i;
        }
        return continueTraversal;
    }

    @Override
    public boolean hasChildren() {
        return this.getChildren() != NO_ELEMENTS;
    }

    @Override
    public IDOMNode[] getChildren() {
        return this.m_children;
    }

    @Override
    public String getElementName() {
        return "";
    }

    @Override
    public IDOMNode getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(IDOMNode p) {
        this.m_parent = p;
    }

    @Override
    public IDOMNode getElementAt(int position) {
        if (this instanceof ISourceCodeReference) {
            IDOMNode[] children = this.getChildren();
            int i = children.length - 1;
            while (i >= 0) {
                IDOMNode aChild = children[i];
                if (aChild instanceof ISourceCodeReference) {
                    ISourceCodeReference child = (ISourceCodeReference)((Object)children[i]);
                    ISourceCodeRange range = child.getSourceRange();
                    int start = range.getOffset();
                    int end = start + range.getLength();
                    if (start <= position && position <= end) {
                        if (child instanceof IParent) {
                            return child.getElementAt(position);
                        }
                        return (IDOMNode)((Object)child);
                    }
                }
                --i;
            }
        }
        return this;
    }
}

