/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal.dom;

import com.rsi.idldt.core.dom.IDOMFile;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class DOMFile
implements IDOMFile,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient IFile m_ifile;
    private transient File m_file;
    private String m_canonicalPath;
    private int m_referenceCount;

    public DOMFile() {
        this.m_ifile = null;
        this.m_file = null;
    }

    public DOMFile(IFile f) {
        this.m_ifile = f;
        this.m_file = null;
        this.m_canonicalPath = DOMFile.getCanonicalPath(f);
    }

    public DOMFile(File f) {
        this.m_ifile = null;
        this.m_file = f;
        this.m_canonicalPath = DOMFile.getCanonicalPath(f);
    }

    public boolean exists() {
        return this.m_ifile != null && this.m_file != null;
    }

    public Object getFile() {
        if (this.m_ifile != null) {
            return this.m_ifile;
        }
        return this.m_file;
    }

    public boolean isResource() {
        return this.m_ifile != null;
    }

    public IFile getResource() {
        if (this.m_ifile != null) {
            return this.m_ifile;
        }
        return null;
    }

    public IPath getResourcePath() {
        if (this.m_ifile != null) {
            return this.m_ifile.getFullPath();
        }
        return null;
    }

    public String getCanonicalPath() {
        if (this.m_canonicalPath != null) {
            return this.m_canonicalPath;
        }
        if (this.m_file != null) {
            return DOMFile.getCanonicalPath(this.m_file);
        }
        if (this.m_ifile != null) {
            return DOMFile.getCanonicalPath(this.m_ifile);
        }
        return null;
    }

    public static String getCanonicalPath(Object o) {
        File f = null;
        if (o instanceof IFile) {
            IFile workspaceFile = (IFile)o;
            IPath path = workspaceFile.getLocation();
            if (path != null) {
                f = path.toFile();
            }
        } else if (o instanceof File) {
            f = (File)o;
        } else if (o instanceof String) {
            f = new File((String)o);
        }
        String p = null;
        if (f != null) {
            try {
                p = f.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return p;
    }

    public int getReferenceCount() {
        return this.m_referenceCount;
    }

    public void incrementReferenceCount() {
        ++this.m_referenceCount;
    }

    public void decrementReferenceCount() {
        --this.m_referenceCount;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Object o = in.readObject();
        if (o instanceof URI) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile[] files = root.findFilesForLocationURI((URI)o);
            this.m_ifile = files.length > 0 ? files[0] : null;
        } else {
            this.m_file = new File((String)o);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.m_ifile != null) {
            out.writeObject(this.m_ifile.getLocationURI());
        } else {
            out.writeObject(this.m_file.getCanonicalPath().toString());
        }
    }
}

