/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal;

import com.rsi.idldt.core.ICommandHistory;
import com.rsi.idldt.core.ICommandLineHandler;
import com.rsi.idldt.core.IDLNotifyListener;
import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IGUIHandler;
import com.rsi.idldt.core.IHandlerChangedListener;
import com.rsi.idldt.core.IIDLOutputListener;
import com.rsi.idldt.core.IIDLPathListener;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.IOutputLogHandler;
import com.rsi.idldt.core.Messages;
import com.rsi.idldt.core.ResponseManager;
import com.rsi.idldt.core.internal.CommandManager;
import com.rsi.idldt.core.internal.dom.DOMFile;
import com.rsi.idldt.core.internal.interp.commands.UpdateDebugModelCommand;
import com.rsi.idldt.core.internal.model.CommandHistory;
import com.rsi.idldt.core.internal.projects.IDLProjectManager;
import com.rsi.idldt.core.internal.statemgr.InterpreterStateMachine;
import com.rsi.idldt.core.interp.AbstractIDLCommand;
import com.rsi.idldt.core.interp.ICommandListener;
import com.rsi.idldt.core.interp.IInterpreterCommands;
import com.rsi.idldt.core.interp.IInterpreterDebugListener;
import com.rsi.idldt.core.interp.IInterpreterStateChangeListener;
import com.rsi.idldt.core.interp.IInterpreterStateTracker;
import com.rsi.idldt.core.projects.IIDLProjectManager;
import com.rsi.idldt.debug.internal.model.IDLBreakpointManager;
import com.rsi.idldt.debug.internal.model.IDLDebugTarget;
import com.rsi.idldt.debug.model.IIDLBreakpoint;
import com.rsi.idldt.debug.model.IIDLDebugTargetListener;
import com.rsi.idldt.launching.IDLLaunchDelegate;
import com.rsi.jdml.CommandFinishedDTO;
import com.rsi.jdml.DMLAccess;
import com.rsi.jdml.IDLPreferencesDTO;
import com.rsi.jdml.IDLVariable;
import com.rsi.jdml.IErrorInfo;
import com.rsi.jdml.KeyboardEvent;
import java.io.File;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class IDLProcessProxy
implements IHandlerChangedListener,
IIDLProcessProxy {
    private long m_debugID;
    boolean bIsExiting = false;
    protected String m_IDLPrompt;
    protected String m_currentPrompt;
    private String m_IDLPath;
    private final InterpreterStateMachine m_stateMachine;
    private final ResponseManager m_responseMgr;
    private final CommandManager m_commandMgr;
    private final IIDLProjectManager m_projectMgr;
    private final AbstractList<IIDLOutputListener> m_idlOutputListeners = new Vector<IIDLOutputListener>(1);
    private final AbstractList<IIDLPathListener> m_idlPathListeners = new Vector<IIDLPathListener>(1);
    private final ICommandHistory m_history;
    IDLDebugTarget m_debugTarget;
    private HashMap<String, Long> m_fileCompileTimes;

    public IDLProcessProxy() {
        this.m_responseMgr = new ResponseManager(this);
        this.m_commandMgr = new CommandManager(this);
        this.m_history = new CommandHistory();
        this.m_stateMachine = new InterpreterStateMachine(this);
        this.m_responseMgr.setResponseHandler(this.m_stateMachine);
        this.m_projectMgr = new IDLProjectManager(this);
        this.m_IDLPrompt = Messages.InitialPrompt;
        this.m_currentPrompt = Messages.InitialPrompt;
        this.m_fileCompileTimes = new HashMap(128);
    }

    public synchronized long createAndStartProcess() {
        try {
            this.m_debugID = DMLAccess.createIDLInstance(this.m_responseMgr);
        }
        catch (Throwable e) {
            this.m_debugID = 0L;
            IDLProcessManager.handleFatalError(null, Messages.IDLProcessManager_ErrorStatus4, e);
        }
        if (this.m_debugID > 0L) {
            try {
                this.startProcess();
            }
            catch (Throwable e) {
                IDLProcessManager.handleFatalError(null, Messages.IDLProcessManager_ErrorStatus4, e);
            }
        }
        return this.m_debugID;
    }

    private void startProcess() {
        long isStarted = DMLAccess.startIDLInstance(this.m_debugID);
        if (isStarted < 0L) {
            this.m_debugID = 0L;
            return;
        }
        this.m_commandMgr.getRecallHistory(this.m_history);
        this.m_projectMgr.initialize();
        this.getStateManager().initDone();
        this.commandLineHandlerChanged(null, IDLProcessManager.getCommandLineHandler());
        this.guiHandlerChanged(null, IDLProcessManager.getGUIHandler());
        this.logHandlerChanged(null, IDLProcessManager.getLogWindowHandler());
        IDLProcessManager.addProcess(this);
        ILaunchConfiguration config = IDLProcessProxy.createConfiguration(this);
        if (config != null) {
            try {
                config.launch("debug", null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        ResponseManager.addIDLNotifyListener(new IDLNotifyListener("IDLExecute"){

            public void handleIDLNotification(IDLVariable parm1, IDLVariable parm2) {
                if (parm1 == null) {
                    return;
                }
                String command = parm1.getString();
                if (command == null || command.length() == 0) {
                    return;
                }
                IDLProcessManager.queueExecuteString(command);
            }
        });
        this.m_commandMgr.started();
    }

    private static ILaunchConfiguration createConfiguration(IIDLProcessProxy idl) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = IDLLaunchDelegate.getIDLLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, "IDL");
            wc.setAttribute("com.rsi.idldt.launching.DEBUG_ID", String.valueOf(idl.getDebugID()));
            config = wc.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return config;
    }

    public synchronized void resetProcess() {
        this.m_projectMgr.reset();
        this.m_fileCompileTimes.clear();
    }

    public void activate() {
        this.updateTTYSize();
    }

    public synchronized void deactivate() {
    }

    public synchronized void destroyProcess() {
        long id = this.m_debugID;
        this.m_debugID = 0L;
        this.getCommandManager().destroyProcess(id);
        this.removeInterpreterStateListener(this.getCommandLineHandler());
    }

    private boolean doTerminate(long millis) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                if (IDLProcessProxy.this.m_debugTarget.canTerminate()) {
                    try {
                        IDLProcessProxy.this.m_debugTarget.terminate();
                    }
                    catch (DebugException debugException) {}
                }
            }
        });
        t.start();
        try {
            t.join(millis);
            return !t.isAlive();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    private boolean doDestroy(long millis) {
        final IDLProcessProxy idl = this;
        Thread t = new Thread(new Runnable(){

            public void run() {
                idl.destroyProcess();
            }
        });
        t.start();
        try {
            t.join(millis);
            return !t.isAlive();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public void exiting() {
        if (this.bIsExiting) {
            return;
        }
        this.bIsExiting = true;
        if (!this.m_responseMgr.exitDoneSeen()) {
            if (!this.doTerminate(5000L)) {
                return;
            }
            if (!this.doDestroy(500L)) {
                return;
            }
        }
    }

    private void updateTTYSize() {
        IOutputLogHandler handler = this.getLogWindowHandler();
        if (handler != null) {
            this.m_commandMgr.setTTYSize(handler.getTTYSize());
        }
    }

    public synchronized void commandFinished(CommandFinishedDTO dto) {
        this.m_history.commandFinished(dto);
        this.m_commandMgr.commandFinished();
        this.getStateManager().commandFinished(dto);
    }

    public IInterpreterCommands getCommandManager() {
        return this.m_commandMgr;
    }

    public ResponseManager getResponseManager() {
        return this.m_responseMgr;
    }

    public ICommandHistory getCommandHistory() {
        return this.m_history;
    }

    public IIDLProjectManager getProjectManager() {
        return this.m_projectMgr;
    }

    public IInterpreterStateTracker getStateManager() {
        return this.m_stateMachine;
    }

    public long getDebugID() {
        return this.m_debugID;
    }

    public void addInterpreterStateListener(IInterpreterStateChangeListener l) {
        this.m_stateMachine.addStateChangeListener(l);
    }

    public void removeInterpreterStateListener(IInterpreterStateChangeListener l) {
        this.m_stateMachine.removeStateChangeListener(l);
    }

    public void addInterpreterDebugListener(IInterpreterDebugListener l) {
        this.m_responseMgr.addInterpreterDebugListener(l);
    }

    public void removeInterpreterDebugListener(IInterpreterDebugListener l) {
        this.m_responseMgr.removeInterpreterDebugListener(l);
    }

    public void addIDLDebugTargetListener(IIDLDebugTargetListener l) {
        this.m_debugTarget.addIDLDebugTargetListener(l);
    }

    public void removeIDLDebugTargetListener(IIDLDebugTargetListener l) {
        this.m_debugTarget.removeIDLDebugTargetListener(l);
    }

    public void addIDLOutputListener(IIDLOutputListener l) {
        if (l != null && !this.m_idlOutputListeners.contains(l)) {
            this.m_idlOutputListeners.add(l);
        }
    }

    public void removeIDLOutputListener(IIDLOutputListener l) {
        if (l != null) {
            this.m_idlOutputListeners.remove(l);
        }
    }

    public void addIDLPathListener(IIDLPathListener l) {
        if (l != null && !this.m_idlPathListeners.contains(l)) {
            this.m_idlPathListeners.add(l);
        }
    }

    public void removeIDLPathListener(IIDLPathListener l) {
        if (l != null) {
            this.m_idlPathListeners.remove(l);
        }
    }

    public void idlOutput(IIDLProcessProxy idl, int context, String s) {
        IOutputLogHandler lwh = this.getLogWindowHandler();
        if (lwh != null) {
            lwh.idlOutput(idl, context, s);
        }
        if (s.indexOf("Procedure was compiled while active:") >= 0) {
            this.queueCommand(new UpdateDebugModelCommand());
        }
        if (this.m_idlOutputListeners != null && this.m_idlOutputListeners.size() > 0) {
            IIDLOutputListener listener = null;
            int i = 0;
            while (i < this.m_idlOutputListeners.size()) {
                listener = this.m_idlOutputListeners.get(i);
                listener.idlOutput(this, context, s);
                ++i;
            }
        }
    }

    public synchronized void sendTextLine(String text) {
        this.m_stateMachine.sendTextLine(text);
    }

    public synchronized void sendKey(KeyboardEvent e) {
        this.m_stateMachine.sendKey(e);
    }

    public boolean isExecuting() {
        return this.m_stateMachine.isExecuting();
    }

    public boolean isExecutingReset() {
        return this.m_stateMachine.isExecutingReset();
    }

    public boolean isIdle() {
        if (this.m_stateMachine == null) {
            return false;
        }
        return this.m_stateMachine.isIdle();
    }

    public boolean isInitialized() {
        if (this.m_stateMachine == null) {
            return false;
        }
        return this.m_stateMachine.isInitialized();
    }

    public boolean isBlocked() {
        return this.m_stateMachine.isBlocked();
    }

    public boolean isExpectingKey() {
        return this.m_stateMachine.isExpectingKey();
    }

    public boolean useBufferedKeys() {
        return this.m_stateMachine.useBufferedKeys();
    }

    public boolean isKeyValid(KeyboardEvent e) {
        return this.m_stateMachine.isKeyValid(e);
    }

    public boolean isBufferingKeys() {
        return this.m_stateMachine.isBufferingKeys();
    }

    public boolean isExpectingTextLine() {
        return this.m_stateMachine.isExpectingTextLine();
    }

    public void setCompileTime(String fileName, long t) {
        String key = DOMFile.getCanonicalPath(new File(fileName));
        this.m_fileCompileTimes.put(key, new Long(t));
    }

    public long getCompileTime(String fileName) {
        String key = DOMFile.getCanonicalPath(new File(fileName));
        Long t = this.m_fileCompileTimes.get(key);
        return t != null ? t : -1L;
    }

    public void setBreakpointsAsCompiled(String theFileName) {
        String fileName = DOMFile.getCanonicalPath(new File(theFileName));
        IIDLBreakpoint[] breakpoints = IDLBreakpointManager.getAllFromFile(fileName);
        int i = 0;
        while (i < breakpoints.length) {
            breakpoints[i].setOnRecompile(false);
            ++i;
        }
    }

    public void commandLineHandlerChanged(ICommandLineHandler oldHandler, ICommandLineHandler newHandler) {
        this.removeInterpreterStateListener(oldHandler);
        this.addInterpreterStateListener(newHandler);
    }

    public void logHandlerChanged(IOutputLogHandler oldHandler, IOutputLogHandler newHandler) {
        this.updateTTYSize();
    }

    public void guiHandlerChanged(IGUIHandler oldHandler, IGUIHandler newHandler) {
    }

    public void setCommandLineHandler(ICommandLineHandler handler) {
        IDLProcessManager.setCommandLineHandler(handler);
    }

    public ICommandLineHandler getCommandLineHandler() {
        return IDLProcessManager.getCommandLineHandler();
    }

    public void setLogWindowHandler(IOutputLogHandler handler) {
        IDLProcessManager.setLogWindowHandler(handler);
    }

    public IGUIHandler getGUIHandler() {
        return IDLProcessManager.getGUIHandler();
    }

    public void setGUIHandler(IGUIHandler handler) {
        IDLProcessManager.setGUIHandler(handler);
    }

    public IOutputLogHandler getLogWindowHandler() {
        return IDLProcessManager.getLogWindowHandler();
    }

    public void queueCommand(AbstractIDLCommand cmd) {
        this.m_commandMgr.queueCommand(cmd);
    }

    public void queueExecuteString(String c) {
        this.m_commandMgr.queueExecuteString(c);
    }

    public int getLastError(IErrorInfo err) {
        return this.m_commandMgr.getLastError(err);
    }

    public synchronized void queueSilentExecuteString(String c) {
        this.m_commandMgr.queueSilentExecuteString(c, true);
    }

    public synchronized void queueSilentExecuteString(String c, boolean updateDebugModel) {
        this.m_commandMgr.queueSilentExecuteString(c, updateDebugModel);
    }

    public synchronized void queueSetIDLPreferences(IDLPreferencesDTO prefs) {
        this.m_commandMgr.queueSetIDLPreferences(prefs);
    }

    public synchronized void queueGetIDLPreferences(IDLPreferencesDTO prefs, ICommandListener listener) {
        this.m_commandMgr.queueGetIDLPreferences(prefs, listener);
    }

    public synchronized void queueGetDefaultIDLPreferences(IDLPreferencesDTO prefs, ICommandListener listener) {
        this.m_commandMgr.queueGetDefaultIDLPreferences(prefs, listener);
    }

    public void requestAbort() {
        this.m_commandMgr.requestAbort();
    }

    public synchronized boolean isIDLAvailable() {
        return this.isInitialized() && this.isIdle() && this.m_commandMgr.isQueueEmpty();
    }

    public String getIDLPrompt() {
        return this.m_IDLPrompt;
    }

    public String getCurrentPrompt() {
        return this.m_currentPrompt;
    }

    public void setIDLPrompt(String p) {
        this.m_IDLPrompt = p;
        this.internalPromptChange(p);
    }

    public void overrideIDLPrompt(String p) {
        this.internalPromptChange(p);
    }

    public void restoreIDLPrompt() {
        this.internalPromptChange(this.m_IDLPrompt);
    }

    public void internalPromptChange(String p) {
        this.m_currentPrompt = p;
        IDLProcessManager.getCommandLineHandler().promptChanged(this, p);
    }

    public void setIDLPath(String path) {
        this.m_IDLPath = path;
        if (this.m_idlPathListeners != null) {
            IIDLPathListener listener = null;
            int i = 0;
            while (i < this.m_idlPathListeners.size()) {
                listener = this.m_idlPathListeners.get(i);
                listener.idlPathChanged(this, this.m_IDLPath);
                ++i;
            }
        }
    }

    public String getIDLPath() {
        return this.m_IDLPath;
    }

    public String toString() {
        return "IDLProcessProxy [id=" + this.m_debugID + "]";
    }

    public void setDebugTarget(IDLDebugTarget target) {
        this.m_debugTarget = target;
    }

    public IDLDebugTarget getDebugTarget() {
        return this.m_debugTarget;
    }

    public void setCurrentWorkingDir(String dir) {
        this.m_projectMgr.setCurrentWorkingDir(dir);
    }
}

