/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal;

import com.rsi.idldt.core.Messages;
import com.rsi.idldt.core.utils.Tracer;
import com.rsi.jdml.INativeLocation;
import com.rsi.jdml.PlatformSupport;
import com.rsi.jdml.internal.NativeLocation;
import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class FileLocations {
    private static String g_installTop;
    private static boolean g_isInstalledUnderIDL;
    private static INativeLocation g_defaultIDLBinaryLocation;
    private static INativeLocation g_defaultIDLDTBinaryLocation;
    private static IPath g_workspaceTop;

    static {
        String top = Platform.getInstallLocation().getURL().getPath();
        g_installTop = PlatformSupport.convertFileURLToNativePath(top);
        FileLocations.calculateDefaultIDLLocation();
        try {
            g_workspaceTop = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        }
        catch (Exception e) {
            System.out.println("Error getting workspace top.");
            e.printStackTrace();
        }
    }

    public static IPath getWorkspaceTop() {
        return g_workspaceTop;
    }

    public static String getNativeWorkspaceTop() {
        String top = g_workspaceTop.toString();
        return PlatformSupport.convertPathToNativeSeparators(top);
    }

    public static String getNativeInstallLocation() {
        String top = g_installTop.toString();
        return PlatformSupport.convertPathToNativeSeparators(top);
    }

    public static boolean isInstalledUnderIDL() {
        return g_isInstalledUnderIDL;
    }

    public static INativeLocation getDefaultIDLLocation() {
        return g_defaultIDLBinaryLocation;
    }

    public static INativeLocation getDefaultIDLDTLocation() {
        return g_defaultIDLDTBinaryLocation;
    }

    private static void calculateDefaultIDLLocation() {
        g_isInstalledUnderIDL = false;
        g_defaultIDLBinaryLocation = new NativeLocation(null, Messages.FileLocations_Hint1);
        g_defaultIDLDTBinaryLocation = new NativeLocation(null, Messages.FileLocations_Hint1);
        Tracer.trace(Tracer.IS_DEBUGGING, "install top=" + g_installTop);
        String binPath = String.valueOf(g_installTop) + File.separator + ".." + File.separator + "bin" + File.separator + PlatformSupport.getPlatformBinDirectory();
        Tracer.trace(Tracer.IS_DEBUGGING, "s=" + binPath);
        File f = new File(String.valueOf(binPath) + File.separator + PlatformSupport.getIDLLibName());
        Tracer.trace(Tracer.IS_DEBUGGING, "f=" + f.getAbsolutePath());
        if (f.exists()) {
            g_defaultIDLBinaryLocation = new NativeLocation(binPath, Messages.FileLocations_Hint1);
            g_isInstalledUnderIDL = true;
        }
        binPath = String.valueOf(g_installTop) + File.separator + PlatformSupport.getIDLDTBinDirectory();
        Tracer.trace(Tracer.IS_DEBUGGING, "idlde lib path=" + binPath);
        g_defaultIDLDTBinaryLocation = new NativeLocation(binPath, Messages.FileLocations_Hint1);
    }
}

