/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal;

import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.IOutputLogHandler;
import com.rsi.idldt.core.utils.Rectangle;
import java.util.Vector;

public class DefaultOutputLogHandler
implements IOutputLogHandler {
    private boolean m_saveOutput;
    private Vector<StreamData> m_streamBuffer;
    private boolean m_bSuppressOutput;
    private Rectangle m_ttyRectangle;

    public DefaultOutputLogHandler() {
        this(true);
    }

    public DefaultOutputLogHandler(boolean saveOutput) {
        this.m_saveOutput = saveOutput;
        if (this.m_saveOutput) {
            this.m_streamBuffer = new Vector(256, 64);
        }
    }

    public void echoAfterPrompt(IIDLProcessProxy idl, String s) {
        if (this.m_saveOutput) {
            this.m_streamBuffer.add(new StreamData(idl, s));
        }
    }

    public Rectangle getTTYSize() {
        return this.m_ttyRectangle;
    }

    public void idlOutput(IIDLProcessProxy idl, int context, String s) {
        if (this.m_saveOutput && !this.m_bSuppressOutput) {
            this.m_streamBuffer.add(new StreamData(idl, context, s));
        }
    }

    public void setSuppressOutput(boolean value) {
        this.m_bSuppressOutput = value;
    }

    public void setTTYSize(Rectangle rect) {
        this.m_ttyRectangle = rect;
    }

    public void transfer(IOutputLogHandler log) {
        if (log != null) {
            log.setSuppressOutput(this.m_bSuppressOutput);
            log.setTTYSize(this.m_ttyRectangle);
            int i = 0;
            int n = this.m_streamBuffer.size();
            while (i < n) {
                StreamData d = this.m_streamBuffer.get(i);
                if (d.m_type == 1) {
                    log.echoAfterPrompt(d.m_idl, d.m_value);
                } else {
                    log.idlOutput(d.m_idl, d.m_context, d.m_value);
                }
                ++i;
            }
        }
    }

    private class StreamData {
        protected static final int ECHO = 1;
        protected static final int OUTPUT = 2;
        protected int m_type;
        protected IIDLProcessProxy m_idl;
        protected int m_context;
        protected String m_value;

        public StreamData(IIDLProcessProxy idl, String v) {
            this.m_type = 1;
            this.m_idl = idl;
            this.m_value = v;
        }

        public StreamData(IIDLProcessProxy idl, int c, String v) {
            this.m_type = 2;
            this.m_idl = idl;
            this.m_context = c;
            this.m_value = v;
        }
    }
}

