/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.internal.CompilerError;
import com.rsi.jdml.CompileErrorContext;
import java.util.AbstractList;
import java.util.ArrayList;

public class CompileErrorBuffer {
    private static final int INITIAL_CHARACTER_CAPACITY = 500;
    private static final int INITIAL_CONTEXTS_CAPACITY = 20;
    private AbstractList<CompileErrorContext> m_contexts = new ArrayList<CompileErrorContext>(20);
    private StringBuffer m_output = null;

    public CompileErrorBuffer() {
        this.reset();
    }

    private void reset() {
        this.m_output = new StringBuffer(500);
        this.m_contexts.clear();
    }

    public final synchronized void addOutput(String s) {
        this.m_output.append(String.valueOf(s) + "\n");
    }

    public final synchronized void addContext(CompileErrorContext ctx) {
        this.m_contexts.add(ctx);
    }

    public void parseCompileErrors() {
        int count = 0;
        String[] strs = this.m_output.toString().split("\n");
        String s2 = "";
        int i = 0;
        while (i < strs.length) {
            boolean foundCaret = strs[i].endsWith("^");
            if (foundCaret || strs[i].indexOf("End of file") >= 0) {
                CompileErrorContext ctx = this.m_contexts.get(count++);
                s2 = foundCaret ? "" : strs[i];
                ++i;
                while (i < strs.length && !strs[i].startsWith("  At:")) {
                    s2 = String.valueOf(s2) + strs[i] + " ";
                    ++i;
                }
                s2 = s2.replaceAll("\\. $", "\\.");
                CompilerError ce = new CompilerError(s2, ctx);
                IDLProcessManager.getGUIHandler().handleCompileError(ce);
            }
            ++i;
        }
        this.reset();
    }
}

