/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal;

import com.rsi.idldt.core.IDLDTCorePlugin;
import com.rsi.idldt.core.internal.CommandManager;
import com.rsi.idldt.core.internal.IDLProcessProxy;
import com.rsi.idldt.core.interp.AbstractIDLCommand;
import com.rsi.idldt.core.interp.IInterpreterCommands;
import com.rsi.idldt.core.utils.Tracer;
import java.util.List;
import java.util.Vector;

public class CommandQueue
extends Thread {
    private final IDLProcessProxy m_idl;
    private volatile boolean m_shutdown;
    private List<AbstractIDLCommand> m_queue = new Vector<AbstractIDLCommand>(25);
    private AbstractIDLCommand m_currentCommand;
    private static Object m_additionalLock = null;

    public CommandQueue(IDLProcessProxy idl) {
        this.m_idl = idl;
        this.m_shutdown = false;
        this.setName("CommandQueue=" + idl.getDebugID());
    }

    public static void setAdditionalLock(Object o) {
        m_additionalLock = o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        CommandManager commandManager = this.getCommandManager();
        while (!this.isShutdown()) {
            try {
                if (!this.m_idl.isInitialized() || this.isQueueEmpty() || commandManager.isAborting() || IDLDTCorePlugin.getDefault() == null) {
                    CommandQueue.sleep(100L);
                    continue;
                }
                if (!this.m_idl.isIdle()) {
                    CommandQueue.sleep(10L);
                    continue;
                }
                if (m_additionalLock != null) {
                    Object object = m_additionalLock;
                    synchronized (object) {
                        this.runCommand();
                        continue;
                    }
                }
                this.runCommand();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
            catch (Throwable e) {
                System.out.println("Throwable caught by CommandQueue.");
                e.printStackTrace();
            }
        }
    }

    protected void runCommand() {
        this.m_currentCommand = this.removeCommand(0);
        Tracer.trace(Tracer.IS_DEBUGGING, "\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   CommandQueue begin command=" + this.m_currentCommand);
        try {
            this.m_currentCommand.runCommand(this.m_idl);
        }
        catch (Throwable e) {
            System.out.println("Throwable caught while running command=" + this.m_currentCommand);
            e.printStackTrace();
        }
        Tracer.trace(Tracer.IS_DEBUGGING, "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<   CommandQueue end\n");
        this.m_currentCommand = null;
    }

    public synchronized boolean isQueueEmpty() {
        return this.m_queue.isEmpty();
    }

    public synchronized void shutdown() {
        this.m_queue.clear();
        this.m_shutdown = true;
    }

    private synchronized boolean isShutdown() {
        return this.m_shutdown;
    }

    public synchronized void reset() {
        this.m_queue.clear();
    }

    public synchronized void queueCommand(AbstractIDLCommand cmd) {
        if (cmd.shouldReplaceDuplicate()) {
            this.removeDuplicates(cmd);
        }
        if (cmd.addToFront()) {
            this.m_queue.add(0, cmd);
        } else {
            this.m_queue.add(cmd);
        }
    }

    private synchronized AbstractIDLCommand removeCommand(int i) {
        return this.m_queue.remove(i);
    }

    private synchronized void removeDuplicates(AbstractIDLCommand cmd) {
        if (this.m_queue.size() > 0) {
            int i = 0;
            while (i < this.m_queue.size()) {
                if (cmd.isDuplicate(this.m_queue.get(i))) {
                    this.m_queue.remove(i);
                }
                ++i;
            }
        }
    }

    public AbstractIDLCommand getCurrentCommand() {
        return this.m_currentCommand;
    }

    private CommandManager getCommandManager() {
        IInterpreterCommands ic = this.m_idl.getCommandManager();
        if (ic instanceof CommandManager) {
            return (CommandManager)ic;
        }
        return null;
    }
}

