/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core.internal;

import com.rsi.idldt.core.ICommandHistory;
import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IOutputLogHandler;
import com.rsi.idldt.core.internal.CommandQueue;
import com.rsi.idldt.core.internal.IDLProcessProxy;
import com.rsi.idldt.core.internal.interp.commands.DeleteVariableCommand;
import com.rsi.idldt.core.internal.interp.commands.ExecuteStringCommand;
import com.rsi.idldt.core.internal.interp.commands.GetDefaultIDLPreferencesCommand;
import com.rsi.idldt.core.internal.interp.commands.GetIDLPreferencesCommand;
import com.rsi.idldt.core.internal.interp.commands.RenameVariableCommand;
import com.rsi.idldt.core.internal.interp.commands.SetIDLPreferencesCommand;
import com.rsi.idldt.core.internal.interp.commands.SetTTYCommand;
import com.rsi.idldt.core.internal.interp.commands.SilentExecuteStringCommand;
import com.rsi.idldt.core.internal.interp.commands.UpdateVariableValueCommand;
import com.rsi.idldt.core.interp.AbstractIDLCommand;
import com.rsi.idldt.core.interp.ICommandListener;
import com.rsi.idldt.core.interp.IInterpreterCommands;
import com.rsi.idldt.core.utils.Rectangle;
import com.rsi.jdml.DMLAccess;
import com.rsi.jdml.IDLPreferencesDTO;
import com.rsi.jdml.IErrorInfo;
import com.rsi.jdml.KeyboardEvent;
import com.rsi.jdml.RecallHistoryList;

public class CommandManager
implements IInterpreterCommands {
    IDLProcessProxy m_idlProcess;
    CommandQueue m_queue;
    private volatile boolean m_aborting;

    public CommandManager(IDLProcessProxy idl) {
        this.m_idlProcess = idl;
        this.m_queue = new CommandQueue(idl);
    }

    public void started() {
        this.m_queue.start();
    }

    public void destroyProcess(long id) {
        DMLAccess.destroyIDLInstance(id);
        this.m_queue.shutdown();
    }

    public void answerReadProgramLine(String s) {
        DMLAccess.answerReadProgramLine(this.m_idlProcess.getDebugID(), s);
    }

    public void answerResetSessionConfirm(boolean answer) {
        DMLAccess.answerResetSessionConfirm(this.m_idlProcess.getDebugID(), answer);
    }

    public void answerModalMessage(boolean answer) {
        DMLAccess.answerModalMessage(this.m_idlProcess.getDebugID(), answer);
    }

    public void answerMoreQuery(KeyboardEvent key) {
        DMLAccess.answerMoreQuery(this.m_idlProcess.getDebugID(), key);
    }

    public void answerGetKeyboard(KeyboardEvent key) {
        DMLAccess.answerGetKeyboard(this.m_idlProcess.getDebugID(), key);
    }

    public void answerReadIOLine(String s) {
        DMLAccess.answerReadIOLine(this.m_idlProcess.getDebugID(), s);
    }

    public void echoAfterPrompt(String s) {
        IOutputLogHandler lwh = this.m_idlProcess.getLogWindowHandler();
        if (lwh != null) {
            lwh.echoAfterPrompt(this.m_idlProcess, s);
        }
    }

    public void queueCommand(AbstractIDLCommand cmd) {
        this.m_queue.queueCommand(cmd);
    }

    public void queueExecuteString(String cmd) {
        ExecuteStringCommand c = new ExecuteStringCommand(cmd);
        this.doubleCheckUpdating(cmd, c);
        this.m_queue.queueCommand(c);
    }

    public void queueSilentExecuteString(String cmd, boolean updateDebugModel) {
        SilentExecuteStringCommand c = new SilentExecuteStringCommand(cmd);
        c.setUpdateDebugModel(updateDebugModel);
        this.doubleCheckUpdating(cmd, c);
        this.m_queue.queueCommand(c);
    }

    public void queueSetIDLPreferences(IDLPreferencesDTO prefs) {
        SetIDLPreferencesCommand c = new SetIDLPreferencesCommand(prefs);
        this.m_queue.queueCommand(c);
    }

    public void queueGetIDLPreferences(IDLPreferencesDTO prefs, ICommandListener listener) {
        GetIDLPreferencesCommand c = new GetIDLPreferencesCommand(prefs, listener);
        this.m_queue.queueCommand(c);
    }

    public void queueGetDefaultIDLPreferences(IDLPreferencesDTO prefs, ICommandListener listener) {
        GetDefaultIDLPreferencesCommand c = new GetDefaultIDLPreferencesCommand(prefs, listener);
        this.m_queue.queueCommand(c);
    }

    public void getRecallHistory(ICommandHistory history) {
        RecallHistoryList idlhistory = new RecallHistoryList();
        DMLAccess.getRecallHistory(this.m_idlProcess.getDebugID(), idlhistory);
        history.initializeHistory(idlhistory);
    }

    public void clearRecallHistory() {
        DMLAccess.clearRecallHistory(this.m_idlProcess.getDebugID());
    }

    public int getLastError(IErrorInfo err) {
        return DMLAccess.getLastError(this.m_idlProcess.getDebugID(), err);
    }

    public void setTTYSize(Rectangle tty) {
        SetTTYCommand cmd = new SetTTYCommand(tty);
        this.m_queue.queueCommand(cmd);
    }

    public void setVariableValue(long varID, String value) {
        UpdateVariableValueCommand cmd = new UpdateVariableValueCommand(varID, value);
        this.m_queue.queueCommand(cmd);
    }

    public void renameVariable(String oldName, String newName) {
        RenameVariableCommand cmd = new RenameVariableCommand(oldName, newName);
        this.m_queue.queueCommand(cmd);
    }

    public void deleteVariable(String name) {
        DeleteVariableCommand cmd = new DeleteVariableCommand(name);
        this.m_queue.queueCommand(cmd);
    }

    public void setArrayIndex(int index) {
    }

    public String getRecallBuffer(boolean arrowUp) {
        ICommandHistory history = IDLProcessManager.getActiveProcess().getCommandHistory();
        String command = arrowUp ? history.previous() : history.next();
        return command;
    }

    public void commandFinished() {
    }

    public boolean isCurrentCommandUpdatingDebugModel() {
        AbstractIDLCommand c = this.m_queue.getCurrentCommand();
        return c == null ? false : c.shouldUpdateDebugModel();
    }

    public boolean isExecutingCommand() {
        return this.m_queue.getCurrentCommand() != null;
    }

    public synchronized boolean isQueueEmpty() {
        return this.m_queue.isQueueEmpty();
    }

    public void reset() {
        this.m_queue.reset();
        IDLProcessManager.reset(this.m_idlProcess);
    }

    public void requestAbort() {
        this.m_aborting = true;
        DMLAccess.requestAbort(this.m_idlProcess.getDebugID());
        this.m_aborting = false;
    }

    public boolean isAborting() {
        return this.m_aborting;
    }

    public void exiting() {
        this.m_queue.shutdown();
    }

    private void doubleCheckUpdating(String string, AbstractIDLCommand c) {
        String s = string.toLowerCase().trim();
        if (s.startsWith(".edit") || s.startsWith(".compile")) {
            c.setUpdateDebugModel(false);
        }
    }
}

