/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core;

import com.rsi.idldt.core.IDLDTCorePlugin;
import com.rsi.idldt.core.IDLNotifyListener;
import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.internal.CompileErrorBuffer;
import com.rsi.idldt.core.interp.AbstractIDLCommand;
import com.rsi.idldt.core.interp.IInterpreterDebugListener;
import com.rsi.idldt.core.utils.Tracer;
import com.rsi.idldt.debug.internal.model.IDLDebugTarget;
import com.rsi.idldt.debug.internal.model.IDLStackFrame;
import com.rsi.jdml.CommandFinishedDTO;
import com.rsi.jdml.CompileErrorContext;
import com.rsi.jdml.DebugInfoDTO;
import com.rsi.jdml.IDLVariable;
import com.rsi.jdml.IInterpreterResponses;
import com.rsi.jdml.IModalDialogInfo;
import java.util.AbstractList;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;

public class ResponseManager
implements IInterpreterResponses {
    private CompileErrorBuffer m_compileErrors;
    IInterpreterResponses m_stateTracker;
    IIDLProcessProxy m_idlProcess;
    private int m_IDLOutputContext;
    private final AbstractList<IInterpreterDebugListener> m_interpreterListeners = new Vector<IInterpreterDebugListener>(1);
    private boolean m_exitDoneSeen = false;
    private static boolean m_bBuildIsInProgress = false;
    protected static Vector<IDLNotifyListener> m_IDLnotifyListeners = new Vector();

    public ResponseManager(IIDLProcessProxy idl) {
        this.m_idlProcess = idl;
        this.m_compileErrors = new CompileErrorBuffer();
    }

    public void setResponseHandler(IInterpreterResponses tracker) {
        this.m_stateTracker = tracker;
    }

    public void initDone() {
    }

    public void commandStarted() {
        this.m_idlProcess.getStateManager().commandStarted();
        this.dispatchStarted();
    }

    public void commandFinished(CommandFinishedDTO err) {
        this.m_idlProcess.commandFinished(err);
        this.dispatchFinished();
    }

    public static void setBuildIsInProgress(boolean value) {
        m_bBuildIsInProgress = value;
    }

    public void exitDone() {
        Tracer.trace(Tracer.IS_DEBUGGING, "Exit the IDE...");
        this.m_exitDoneSeen = true;
        if (this.m_idlProcess.getStateManager().isIdle() || !this.m_idlProcess.getStateManager().isInitialized()) {
            IDLProcessManager.exiting();
            IDLDTCorePlugin.performIDEExit();
        }
    }

    public boolean exitDoneSeen() {
        return this.m_exitDoneSeen;
    }

    public void requestIOLine(String prompt) {
        this.m_idlProcess.overrideIDLPrompt(prompt);
        this.m_idlProcess.getStateManager().requestIOLine(prompt);
    }

    public void requestProgramLine() {
        this.m_idlProcess.overrideIDLPrompt("- ");
        this.m_idlProcess.getStateManager().requestProgramLine();
    }

    public void promptChanged(String p) {
        this.m_idlProcess.setIDLPrompt(p);
    }

    public void pathChanged(String p) {
        this.m_idlProcess.setIDLPath(p);
    }

    public void workingDirChanged(String newDir) {
        IDLProcessManager.getGUIHandler().handleWorkingDirChanged(newDir);
        this.m_idlProcess.setCurrentWorkingDir(newDir);
    }

    public void mainVariableDeleted(String varName) {
        try {
            IDLDebugTarget debugTarget = this.m_idlProcess.getDebugTarget().getIDLDebugTarget();
            debugTarget.getThread().getMainIDLStackFrame().removeIDLVariable(varName);
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void idlNotify(String notifyId, IDLVariable parm1, IDLVariable parm2) {
        for (IDLNotifyListener listener : m_IDLnotifyListeners) {
            if (!listener.isInterestedInEvent(notifyId)) continue;
            listener.handleIDLNotification(parm1, parm2);
        }
    }

    public static void addIDLNotifyListener(IDLNotifyListener listener) {
        m_IDLnotifyListeners.add(listener);
    }

    public static void removeIDLNotifyListener(IDLNotifyListener listener) {
        m_IDLnotifyListeners.remove(listener);
    }

    public void requestGetKeyboard(int flags) {
        this.m_idlProcess.getStateManager().requestGetKeyboard(flags);
    }

    public void deathHint() {
        if (PlatformUI.getWorkbench().isClosing() || PlatformUI.getWorkbench().getDisplay().isDisposed()) {
            return;
        }
        Tracer.trace(Tracer.IS_DEBUGGING, "Exit the IDE...death hint");
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                IDLProcessManager.getGUIHandler().handleDeathHint();
            }
        });
    }

    public void processGone() {
        Tracer.trace(Tracer.IS_DEBUGGING, "Exit the IDE...process gone");
        IDLProcessManager.getGUIHandler().handleIDLProcessGone();
    }

    protected void resetDebugModel() {
        IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
        if (idl == null) {
            return;
        }
        IDLStackFrame frame = idl.getDebugTarget().getThread().getMainIDLStackFrame();
        if (frame != null) {
            frame.removeAllVariablesInStackFrame();
        }
    }

    public void requestResetConfirm() {
        this.m_idlProcess.getStateManager().requestResetConfirm();
        boolean answer = IDLProcessManager.getGUIHandler().handleResetConfirm();
        if (answer) {
            this.resetDebugModel();
        }
        this.m_idlProcess.getStateManager().answerResetSessionConfirm(answer);
    }

    public void resetDone() {
        this.m_idlProcess.getStateManager().resetDone();
        IDLProcessManager.getGUIHandler().handleReset();
        this.idlNotify("IDLReset", null, null);
    }

    public void requestModalResponse(IModalDialogInfo modalInfo) {
        this.m_idlProcess.getStateManager().requestModalResponse(modalInfo);
        boolean answer = IDLProcessManager.getGUIHandler().handleModalResponse(modalInfo);
        this.m_idlProcess.getStateManager().answerModalMessage(answer);
    }

    public void requestMoreResponse() {
        this.m_idlProcess.getStateManager().requestMoreResponse();
    }

    public void setIDLOutputContext(int context, Object obj) {
        if (this.m_IDLOutputContext == 1 && context == 0) {
            this.m_compileErrors.parseCompileErrors();
        }
        if (context == 1) {
            this.m_compileErrors.addContext((CompileErrorContext)obj);
        }
        this.m_IDLOutputContext = context;
    }

    public void idlOutput(String s) {
        if (this.m_IDLOutputContext == 1) {
            this.m_compileErrors.addOutput(s);
        }
        String sModified = s;
        if (m_bBuildIsInProgress) {
            String sLastModified = "";
            while (!sModified.equals(sLastModified)) {
                sLastModified = sModified;
                sModified = sModified.replaceAll("\\n\\n", "\n");
            }
        }
        this.m_idlProcess.idlOutput(this.m_idlProcess, this.m_IDLOutputContext, sModified);
    }

    public void requestOpenFile(String filePath) {
        if (!m_bBuildIsInProgress) {
            IDLProcessManager.getGUIHandler().handleOpenFile(filePath);
        }
    }

    public void alertCompileFile(String filePath) {
        IDLProcessManager.getGUIHandler().alertCompileFile(filePath);
        this.m_idlProcess.setCompileTime(filePath, System.currentTimeMillis());
        this.m_idlProcess.setBreakpointsAsCompiled(filePath);
    }

    public void interpreterStopped(String filePath, String module, int lineno, int errCode) {
        if (this.m_interpreterListeners != null && this.m_interpreterListeners.size() > 0) {
            IInterpreterDebugListener listener = null;
            int i = 0;
            while (i < this.m_interpreterListeners.size()) {
                listener = this.m_interpreterListeners.get(i);
                listener.handleInterpreterStopped(filePath, module, lineno, errCode);
                ++i;
            }
        }
    }

    public void dispatchStarted() {
        if (this.m_interpreterListeners != null && this.m_interpreterListeners.size() > 0) {
            IInterpreterDebugListener listener = null;
            int i = 0;
            while (i < this.m_interpreterListeners.size()) {
                listener = this.m_interpreterListeners.get(i);
                listener.commandStarted();
                ++i;
            }
        }
    }

    public void dispatchFinished() {
        if (this.m_interpreterListeners != null && this.m_interpreterListeners.size() > 0) {
            IInterpreterDebugListener listener = null;
            int i = 0;
            while (i < this.m_interpreterListeners.size()) {
                listener = this.m_interpreterListeners.get(i);
                listener.commandFinished();
                ++i;
            }
        }
    }

    public void addInterpreterDebugListener(IInterpreterDebugListener l) {
        if (l != null && !this.m_interpreterListeners.contains(l)) {
            this.m_interpreterListeners.add(l);
        }
    }

    public void removeInterpreterDebugListener(IInterpreterDebugListener l) {
        if (l != null) {
            this.m_interpreterListeners.remove(l);
        }
    }

    public String toString() {
        return "ResponseManager";
    }

    public void breakpointMoved(DebugInfoDTO dto) {
        this.m_idlProcess.getDebugTarget().breakpointMovedByIDL(dto);
    }

    public void showBreakpoint(DebugInfoDTO dto) {
        this.m_idlProcess.getDebugTarget().showBreakpoint(dto);
    }

    public void helpTopic(String topic) {
        IDLProcessManager.getGUIHandler().handleHelpTopic(topic);
    }

    public void variablesChanged() {
        Job j = new Job("Updating Variables View"){

            protected IStatus run(IProgressMonitor monitor) {
                AbstractIDLCommand.updateDebugModel(ResponseManager.this.m_idlProcess);
                return Status.OK_STATUS;
            }
        };
        j.setSystem(true);
        j.setPriority(20);
        j.schedule(250L);
    }
}

