/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class IDLProjectProperties {
    protected HashMap<QualifiedName, Object> propDefaults = new HashMap();
    public static final QualifiedName KEY_MANAGE_PATH = new QualifiedName("com.rsi.idldt.core", "manage_path");
    public static final QualifiedName KEY_RUNBUILD_RESET = new QualifiedName("com.rsi.idldt.core", "runbuild_reset");
    public static final QualifiedName KEY_CREATE_SAVEFILE = new QualifiedName("com.rsi.idldt.core", "create_savefile");
    public static final QualifiedName KEY_CREATE_LICENSED_SAVEFILE = new QualifiedName("com.rsi.idldt.core", "create_licensed_savefile");
    public static final QualifiedName KEY_SAVEFILE_INCLUDE_REFERENCED_PROJECTS = new QualifiedName("com.rsi.idldt.core", "saveFile_include_referenced");
    public static final QualifiedName KEY_SAVEFILE_INCLUDE_IDL_LIBS = new QualifiedName("com.rsi.idldt.core", "saveFile_include_idl_libs");
    public static final QualifiedName KEY_SAVEFILE_OUTPUT_PATH = new QualifiedName("com.rsi.idldt.core", "saveFile_output_path");
    public static final QualifiedName KEY_BUILD_COMMAND = new QualifiedName("com.rsi.idldt.core", "build_command");
    public static final QualifiedName KEY_BUILD_TYPE = new QualifiedName("com.rsi.idldt.core", "build_type");
    public static final QualifiedName KEY_BUILD_IN_SEPARATE_SESSION = new QualifiedName("com.rsi.idldt.core", "build_in_separate_session");
    public static final QualifiedName KEY_BUILD_RESOLVE_DEPENDENCIES = new QualifiedName("com.rsi.idldt.core", "build_resolve_all_dependencies");
    public static final QualifiedName KEY_BUILD_PRE_COMPILE_COMMAND = new QualifiedName("com.rsi.idldt.core", "build_pre_compile_command");
    public static final QualifiedName KEY_BUILD_POST_COMPILE_COMMAND = new QualifiedName("com.rsi.idldt.core", "build_post_compile_command");
    public static final QualifiedName KEY_RESTORE_REFERENCED_PROJECTS = new QualifiedName("com.rsi.idldt.core", "build_referenced_projects");
    public static final QualifiedName KEY_BUILD_RESET_SESSION = new QualifiedName("com.rsi.idldt.core", "build_reset_session");
    public static final QualifiedName KEY_BUILD_COMPILE_PROJECT_FILES = new QualifiedName("com.rsi.idldt.core", "build_compile_project_files");
    public static final QualifiedName KEY_EXECUTE_PRE_COMPILE_COMMAND = new QualifiedName("com.rsi.idldt.core", "build_execute_pre_compile_cmd");
    public static final QualifiedName KEY_EXECUTE_POST_COMPILE_COMMAND = new QualifiedName("com.rsi.idldt.core", "build_execute_post_compile_cmd");
    public static final QualifiedName KEY_RUN_COMMAND = new QualifiedName("com.rsi.idldt.core", "run_command");
    public static final QualifiedName KEY_RUN_BEGINS_WITH_BUILD_PROPERTY = new QualifiedName("com.rsi.idldt.core", "run_begins_with_build_property");
    public static final QualifiedName KEY_RUN_RESET_SESSION = new QualifiedName("com.rsi.idldt.core", "run_reset_session");
    public static final String SAVEFILE_TYPE_GENERIC_SAVE = "sav";
    public static final String SAVEFILE_TYPE_EMBEDDED = "embedded";
    public static final String SAVEFILE_TYPE_SOURCE = "source";
    public static final String BUILD_COMMAND_DEFAULT = "default";
    public static final String BUILD_COMMAND_CUSTOM = "custom";
    private IProject m_project;

    public IDLProjectProperties(IProject project) {
        this.m_project = project;
        this.setupDefaults();
    }

    public void setupDefaults() {
        this.propDefaults.put(KEY_MANAGE_PATH, new Boolean(true));
        this.propDefaults.put(KEY_CREATE_SAVEFILE, new Boolean(true));
        this.propDefaults.put(KEY_CREATE_LICENSED_SAVEFILE, new Boolean(false));
        this.propDefaults.put(KEY_BUILD_COMMAND, "");
        this.propDefaults.put(KEY_BUILD_TYPE, BUILD_COMMAND_DEFAULT);
        this.propDefaults.put(KEY_BUILD_IN_SEPARATE_SESSION, new Boolean(false));
        this.propDefaults.put(KEY_RUNBUILD_RESET, new Boolean(false));
        this.propDefaults.put(KEY_RUN_BEGINS_WITH_BUILD_PROPERTY, new Boolean(false));
        this.propDefaults.put(KEY_SAVEFILE_INCLUDE_IDL_LIBS, new Boolean(true));
        this.propDefaults.put(KEY_SAVEFILE_INCLUDE_REFERENCED_PROJECTS, new Boolean(false));
        String projName = this.getCleanProjName();
        this.propDefaults.put(KEY_SAVEFILE_OUTPUT_PATH, "." + File.separatorChar + projName + ".sav");
        this.propDefaults.put(KEY_RUN_COMMAND, projName);
        this.propDefaults.put(KEY_BUILD_RESOLVE_DEPENDENCIES, new Boolean(true));
        this.propDefaults.put(KEY_BUILD_PRE_COMPILE_COMMAND, "");
        this.propDefaults.put(KEY_BUILD_POST_COMPILE_COMMAND, "");
        this.propDefaults.put(KEY_RUN_RESET_SESSION, new Boolean(false));
        this.propDefaults.put(KEY_BUILD_RESET_SESSION, new Boolean(false));
        this.propDefaults.put(KEY_RESTORE_REFERENCED_PROJECTS, new Boolean(true));
        this.propDefaults.put(KEY_BUILD_COMPILE_PROJECT_FILES, new Boolean(true));
        this.propDefaults.put(KEY_EXECUTE_PRE_COMPILE_COMMAND, new Boolean(false));
        this.propDefaults.put(KEY_EXECUTE_POST_COMPILE_COMMAND, new Boolean(false));
    }

    public static boolean isIDLIdentifierStart(char c) {
        return Character.isLetter(c) || c == '!' || c == '_';
    }

    public static boolean isIDLIdentifierPart(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '$' || c == '_';
    }

    protected String getCleanProjName() {
        String projName = this.m_project.getName().replaceAll(" ", "_").toLowerCase();
        if (!IDLProjectProperties.isIDLIdentifierStart(projName.charAt(0))) {
            projName = "_" + projName.substring(1);
        }
        char[] projchars = projName.toCharArray();
        int i = 1;
        while (i < projchars.length) {
            if (!IDLProjectProperties.isIDLIdentifierPart(projchars[i])) {
                projchars[i] = 95;
            }
            ++i;
        }
        return new String(projchars);
    }

    public void setInitialProperties() {
        this.setProjectPathManagement(this.isDefaultProjectPathManaged());
        this.setCreateSaveFile(this.isDefaultCreateSaveFile());
        this.setCreateLicensedSaveFile(this.isDefaultCreateLicensedSaveFile());
        this.setBuildCommand(this.getDefaultBuildCommand());
        this.setBuildType(this.getDefaultBuildType());
        this.setBuildInSeparateSession(this.isDefaultBuildInSeparateSession());
        this.setRunCommand(this.getDefaultRunCommand());
        this.setRunBeginsWithBuild(this.getDefaultRunBeginsWithBuild());
        this.setSaveFileIncludesIDLLib(this.getDefaultSaveFileIncludesIDLLib());
        this.setSaveFileIncludesReferrencedProject(this.getDefaultSaveFileIncludesReferrencedProject());
        this.setSaveFileOutputPath(this.getDefaultSaveFileOutputPath());
        this.setResolveDependencies(this.getDefaultResolveDependencies());
        this.setPreCompileCommand(this.getDefaultPreCompileCommand());
        this.setPostCompileCommand(this.getDefaultPostCompileCommand());
        this.setRunBeginsWithReset(this.getDefaultRunExecuteResetSession());
        this.setBuildBeginsWithReset(this.getDefaultBuildExecuteResetSession());
        this.setRestoreReferencedProjects(this.getDefaultRestoreReferencedProjects());
        this.setCompileProjectFiles(this.getDefaultCompileProjectFiles());
        this.setExecutePreCompileCommand(this.getDefaultExecutePreCompileCommand());
        this.setExecutePostCompileCommand(this.getDefaultExecutePostCompileCommand());
    }

    public void removeAllProperties() {
        try {
            this.m_project.setPersistentProperty(KEY_MANAGE_PATH, null);
            this.m_project.setPersistentProperty(KEY_CREATE_SAVEFILE, null);
            this.m_project.setPersistentProperty(KEY_CREATE_LICENSED_SAVEFILE, null);
            this.m_project.setPersistentProperty(KEY_RUN_COMMAND, null);
            this.m_project.setPersistentProperty(KEY_BUILD_COMMAND, null);
            this.m_project.setPersistentProperty(KEY_SAVEFILE_INCLUDE_REFERENCED_PROJECTS, null);
            this.m_project.setPersistentProperty(KEY_SAVEFILE_INCLUDE_IDL_LIBS, null);
            this.m_project.setPersistentProperty(KEY_SAVEFILE_OUTPUT_PATH, null);
            this.m_project.setPersistentProperty(KEY_BUILD_TYPE, null);
            this.m_project.setPersistentProperty(KEY_BUILD_IN_SEPARATE_SESSION, null);
            this.m_project.setPersistentProperty(KEY_RUNBUILD_RESET, null);
            this.m_project.setPersistentProperty(KEY_RUN_BEGINS_WITH_BUILD_PROPERTY, null);
            this.m_project.setPersistentProperty(KEY_BUILD_RESOLVE_DEPENDENCIES, null);
            this.m_project.setPersistentProperty(KEY_BUILD_PRE_COMPILE_COMMAND, null);
            this.m_project.setPersistentProperty(KEY_BUILD_POST_COMPILE_COMMAND, null);
            this.m_project.setPersistentProperty(KEY_RUN_RESET_SESSION, null);
            this.m_project.setPersistentProperty(KEY_BUILD_RESET_SESSION, null);
            this.m_project.setPersistentProperty(KEY_RESTORE_REFERENCED_PROJECTS, null);
            this.m_project.setPersistentProperty(KEY_BUILD_COMPILE_PROJECT_FILES, null);
            this.m_project.setPersistentProperty(KEY_EXECUTE_PRE_COMPILE_COMMAND, null);
            this.m_project.setPersistentProperty(KEY_EXECUTE_POST_COMPILE_COMMAND, null);
        }
        catch (CoreException coreException) {}
    }

    String replaceBeginningDotWithProjectLocation(String value) {
        String newValue = value;
        char correctSlash = File.separatorChar;
        char incorrectSlash = correctSlash == '/' ? (char)'\\' : '/';
        if ((newValue = newValue.replace(incorrectSlash, correctSlash)).startsWith("." + correctSlash)) {
            String project_path = this.m_project.getLocation().toOSString();
            newValue = String.valueOf(project_path) + correctSlash + newValue.substring(2);
        }
        return newValue;
    }

    public String getSaveFileOutputPath() {
        String saveFile = this.getStringValue(KEY_SAVEFILE_OUTPUT_PATH);
        return this.replaceBeginningDotWithProjectLocation(saveFile);
    }

    public String getSaveFileOutputPathWithoutDotSubstitution() {
        return this.getStringValue(KEY_SAVEFILE_OUTPUT_PATH);
    }

    public String getDefaultSaveFileOutputPath() {
        return (String)this.propDefaults.get(KEY_SAVEFILE_OUTPUT_PATH);
    }

    public void setSaveFileOutputPath(String s) {
        this.setStringValue(KEY_SAVEFILE_OUTPUT_PATH, s);
    }

    public String getBuildCommand() {
        return this.getStringValue(KEY_BUILD_COMMAND);
    }

    public String getDefaultBuildCommand() {
        return (String)this.propDefaults.get(KEY_BUILD_COMMAND);
    }

    public String getBuildType() {
        return this.getStringValue(KEY_BUILD_TYPE);
    }

    public String getDefaultBuildType() {
        return (String)this.propDefaults.get(KEY_BUILD_TYPE);
    }

    public void setBuildInSeparateSession(boolean value) {
        this.setBooleanValue(KEY_BUILD_IN_SEPARATE_SESSION, value);
    }

    public boolean isBuildInSeparateSession() {
        return this.getBooleanValue(KEY_BUILD_IN_SEPARATE_SESSION);
    }

    public boolean isDefaultBuildInSeparateSession() {
        Boolean value = (Boolean)this.propDefaults.get(KEY_BUILD_IN_SEPARATE_SESSION);
        return value;
    }

    public boolean getDefaultResolveDependencies() {
        return (Boolean)this.propDefaults.get(KEY_BUILD_RESOLVE_DEPENDENCIES);
    }

    public boolean getResolveDependencies() {
        return this.getBooleanValue(KEY_BUILD_RESOLVE_DEPENDENCIES);
    }

    public void setResolveDependencies(boolean value) {
        this.setBooleanValue(KEY_BUILD_RESOLVE_DEPENDENCIES, value);
    }

    public String getDefaultPreCompileCommand() {
        return (String)this.propDefaults.get(KEY_BUILD_PRE_COMPILE_COMMAND);
    }

    public String getPreCompileCommand() {
        return this.getStringValue(KEY_BUILD_PRE_COMPILE_COMMAND);
    }

    public void setPreCompileCommand(String value) {
        this.setStringValue(KEY_BUILD_PRE_COMPILE_COMMAND, value);
    }

    public String getDefaultPostCompileCommand() {
        return (String)this.propDefaults.get(KEY_BUILD_POST_COMPILE_COMMAND);
    }

    public String getPostCompileCommand() {
        return this.getStringValue(KEY_BUILD_POST_COMPILE_COMMAND);
    }

    public void setPostCompileCommand(String value) {
        this.setStringValue(KEY_BUILD_POST_COMPILE_COMMAND, value);
    }

    public void setBuildCommand(String s) {
        this.setStringValue(KEY_BUILD_COMMAND, s);
    }

    public void setBuildType(String s) {
        this.setStringValue(KEY_BUILD_TYPE, s);
    }

    @Deprecated
    public void setRunBeginsWithBuild(boolean v) {
        this.setBooleanValue(KEY_RUN_BEGINS_WITH_BUILD_PROPERTY, v);
    }

    @Deprecated
    public void setRunBuildBeginsWithReset(boolean v) {
        this.setBooleanValue(KEY_RUNBUILD_RESET, v);
    }

    @Deprecated
    public boolean isRunBuildBeginsWithReset() {
        return this.getBooleanValue(KEY_RUNBUILD_RESET);
    }

    @Deprecated
    public boolean isDefaultRunBuildBeginsWithReset() {
        Boolean value = (Boolean)this.propDefaults.get(KEY_RUNBUILD_RESET);
        return value;
    }

    public boolean isCustomBuild() {
        return this.getBuildType().equalsIgnoreCase(BUILD_COMMAND_CUSTOM);
    }

    public boolean isDefaultCustomBuild() {
        String value = (String)this.propDefaults.get(KEY_BUILD_TYPE);
        return value.equalsIgnoreCase(BUILD_COMMAND_CUSTOM);
    }

    public String getRunCommand() {
        return this.getStringValue(KEY_RUN_COMMAND);
    }

    public String getDefaultRunCommand() {
        return (String)this.propDefaults.get(KEY_RUN_COMMAND);
    }

    public void setRunCommand(String s) {
        this.setStringValue(KEY_RUN_COMMAND, s);
    }

    public boolean isProjectPathManaged() {
        return this.getBooleanValue(KEY_MANAGE_PATH);
    }

    public boolean isDefaultProjectPathManaged() {
        Boolean value = (Boolean)this.propDefaults.get(KEY_MANAGE_PATH);
        return value;
    }

    public boolean getRunBeginsWithBuild() {
        return this.getBooleanValue(KEY_RUN_BEGINS_WITH_BUILD_PROPERTY);
    }

    public boolean getDefaultRunBeginsWithBuild() {
        Boolean value = (Boolean)this.propDefaults.get(KEY_RUN_BEGINS_WITH_BUILD_PROPERTY);
        return value;
    }

    public boolean getDefaultRunExecuteResetSession() {
        Boolean value = (Boolean)this.propDefaults.get(KEY_RUN_RESET_SESSION);
        return value;
    }

    public void setRunBeginsWithReset(boolean value) {
        this.setBooleanValue(KEY_RUN_RESET_SESSION, value);
    }

    public boolean isRunBeginsWithReset() {
        return this.getisRunBuildResetProperty(KEY_RUN_RESET_SESSION);
    }

    public boolean isBuildBeginsWithReset() {
        return this.getisRunBuildResetProperty(KEY_BUILD_RESET_SESSION);
    }

    private boolean getisRunBuildResetProperty(QualifiedName key) {
        Boolean value = this.getRawBooleanValue(key);
        if (value == null) {
            return this.getBooleanValue(KEY_RUNBUILD_RESET);
        }
        return value;
    }

    public boolean getDefaultBuildExecuteResetSession() {
        Boolean value = (Boolean)this.propDefaults.get(KEY_BUILD_RESET_SESSION);
        return value;
    }

    public void setBuildBeginsWithReset(boolean value) {
        this.setBooleanValue(KEY_BUILD_RESET_SESSION, value);
    }

    public boolean getDefaultRestoreReferencedProjects() {
        Boolean value = (Boolean)this.propDefaults.get(KEY_RESTORE_REFERENCED_PROJECTS);
        return value;
    }

    public boolean getRestoreReferencedProjects() {
        return this.getBooleanValue(KEY_RESTORE_REFERENCED_PROJECTS);
    }

    public void setRestoreReferencedProjects(boolean value) {
        this.setBooleanValue(KEY_RESTORE_REFERENCED_PROJECTS, value);
    }

    public boolean getDefaultCompileProjectFiles() {
        Boolean value = (Boolean)this.propDefaults.get(KEY_BUILD_COMPILE_PROJECT_FILES);
        return value;
    }

    public boolean getCompileProjectFiles() {
        return this.getBooleanValue(KEY_BUILD_COMPILE_PROJECT_FILES);
    }

    public void setCompileProjectFiles(boolean value) {
        this.setBooleanValue(KEY_BUILD_COMPILE_PROJECT_FILES, value);
    }

    public boolean getDefaultExecutePreCompileCommand() {
        Boolean value = (Boolean)this.propDefaults.get(KEY_EXECUTE_PRE_COMPILE_COMMAND);
        return value;
    }

    public boolean getExecutePreCompileCommand() {
        return this.getBooleanValue(KEY_EXECUTE_PRE_COMPILE_COMMAND);
    }

    public void setExecutePreCompileCommand(boolean value) {
        this.setBooleanValue(KEY_EXECUTE_PRE_COMPILE_COMMAND, value);
    }

    public boolean getDefaultExecutePostCompileCommand() {
        Boolean value = (Boolean)this.propDefaults.get(KEY_EXECUTE_POST_COMPILE_COMMAND);
        return value;
    }

    public boolean getExecutePostCompileCommand() {
        return this.getBooleanValue(KEY_EXECUTE_POST_COMPILE_COMMAND);
    }

    public void setExecutePostCompileCommand(boolean value) {
        this.setBooleanValue(KEY_EXECUTE_POST_COMPILE_COMMAND, value);
    }

    public void setProjectPathManagement(boolean b) {
        this.setBooleanValue(KEY_MANAGE_PATH, b);
    }

    public boolean getSaveFileIncludesIDLLib() {
        return this.getBooleanValue(KEY_SAVEFILE_INCLUDE_IDL_LIBS);
    }

    public boolean getDefaultSaveFileIncludesIDLLib() {
        Boolean value = (Boolean)this.propDefaults.get(KEY_SAVEFILE_INCLUDE_IDL_LIBS);
        return value;
    }

    public void setSaveFileIncludesIDLLib(boolean b) {
        this.setBooleanValue(KEY_SAVEFILE_INCLUDE_IDL_LIBS, b);
    }

    public boolean getSaveFileIncludesReferrencedProject() {
        return this.getBooleanValue(KEY_SAVEFILE_INCLUDE_REFERENCED_PROJECTS);
    }

    public boolean getDefaultSaveFileIncludesReferrencedProject() {
        Boolean value = (Boolean)this.propDefaults.get(KEY_SAVEFILE_INCLUDE_REFERENCED_PROJECTS);
        return value;
    }

    public boolean isCreateSaveFile() {
        return this.getBooleanValue(KEY_CREATE_SAVEFILE);
    }

    public boolean isDefaultCreateSaveFile() {
        Boolean value = (Boolean)this.propDefaults.get(KEY_CREATE_SAVEFILE);
        return value;
    }

    public boolean isCreateLicensedSaveFile() {
        return this.getBooleanValue(KEY_CREATE_LICENSED_SAVEFILE);
    }

    public boolean isDefaultCreateLicensedSaveFile() {
        Boolean value = (Boolean)this.propDefaults.get(KEY_CREATE_LICENSED_SAVEFILE);
        return value;
    }

    public void setSaveFileIncludesReferrencedProject(boolean b) {
        this.setBooleanValue(KEY_SAVEFILE_INCLUDE_REFERENCED_PROJECTS, b);
    }

    public void setCreateSaveFile(boolean b) {
        this.setBooleanValue(KEY_CREATE_SAVEFILE, b);
    }

    public void setCreateLicensedSaveFile(boolean b) {
        this.setBooleanValue(KEY_CREATE_LICENSED_SAVEFILE, b);
    }

    private String getStringValue(QualifiedName key) {
        String value = null;
        try {
            value = this.m_project.getPersistentProperty(key);
        }
        catch (CoreException coreException) {}
        if (value == null) {
            value = (String)this.propDefaults.get(key);
        }
        return value;
    }

    private void setStringValue(QualifiedName key, String theValue) {
        String value = theValue;
        if (value == null) {
            value = "";
        }
        try {
            this.m_project.setPersistentProperty(key, value);
        }
        catch (CoreException coreException) {}
    }

    private boolean getBooleanValue(QualifiedName key) {
        Boolean value = this.getRawBooleanValue(key);
        if (value == null) {
            return (Boolean)this.propDefaults.get(key);
        }
        return value;
    }

    private Boolean getRawBooleanValue(QualifiedName key) {
        String value = null;
        try {
            value = this.m_project.getPersistentProperty(key);
        }
        catch (CoreException coreException) {}
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    private void setBooleanValue(QualifiedName key, boolean value) {
        try {
            this.m_project.setPersistentProperty(key, value ? "True" : "False");
        }
        catch (CoreException coreException) {}
    }

    public String toString() {
        return "IDLProjectPropertiesr [" + (this.isProjectPathManaged() ? "is" : "is not ") + " on !PATH, " + "file: " + this.getSaveFileOutputPath() + ", " + "Resolve Dependencies: " + this.getResolveDependencies() + ", " + "Pre Compile: " + this.getPreCompileCommand() + ", " + "Post Compile: " + this.getPostCompileCommand() + ", " + (this.getSaveFileIncludesReferrencedProject() ? "include" : "exclude") + " referred projects, " + (this.getSaveFileIncludesIDLLib() ? "include" : "exclude") + " IDL libraries, " + "buildCmd: " + this.getBuildCommand() + ", " + "runCmd: " + this.getRunCommand() + "]";
    }
}

