/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IDLProjectPluginProperties;
import com.rsi.idldt.core.IDLProjectProperties;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;

public class IDLProjectNature
implements IProjectNature {
    protected IProject m_project;
    private IDLProjectProperties m_projectProps;
    private IDLProjectPluginProperties projectFeatureProperties;
    public static final String IDL_NATURE_ID = "com.rsi.idldt.core.IDLNature";
    protected static String m_createErrorMsg = "";
    private static boolean m_addToPath;

    public void setProject(IProject project) {
        this.m_project = project;
    }

    public IProject getProject() {
        return this.m_project;
    }

    public IDLProjectProperties getIDLProjectProperties() {
        if (this.m_projectProps == null) {
            this.m_projectProps = new IDLProjectProperties(this.m_project);
        }
        return this.m_projectProps;
    }

    public IDLProjectPluginProperties getIDLProjectFeatureProperties() {
        if (this.projectFeatureProperties == null) {
            this.projectFeatureProperties = new IDLProjectPluginProperties(this.m_project);
        }
        return this.projectFeatureProperties;
    }

    protected static void addIDLBuilderToProject(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("com.rsi.idldt.core.IDLBuilder")) {
                return;
            }
            ++i;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName("com.rsi.idldt.core.IDLBuilder");
        newCommands[newCommands.length - 1] = command;
        desc.setBuildSpec(newCommands);
        project.setDescription(desc, null);
    }

    public void configure() throws CoreException {
        this.m_projectProps = new IDLProjectProperties(this.m_project);
        this.m_projectProps.setInitialProperties();
        this.projectFeatureProperties = new IDLProjectPluginProperties(this.m_project);
        this.projectFeatureProperties.setInitialProperties();
        this.m_projectProps.setProjectPathManagement(m_addToPath);
        IDLProjectNature.addIDLBuilderToProject(this.m_project);
    }

    public void deconfigure() throws CoreException {
        if (this.m_projectProps != null) {
            this.m_projectProps.removeAllProperties();
        }
        if (this.projectFeatureProperties != null) {
            this.projectFeatureProperties.removeAllProperties();
        }
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("com.rsi.idldt.core.IDLBuilder")) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                return;
            }
            ++i;
        }
    }

    private static void removeIDLProjectNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        if (natures.length == 0) {
            return;
        }
        if (natures.length == 1 && natures[0].equals(IDL_NATURE_ID)) {
            String[] newNatures = new String[]{};
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        } else {
            ArrayList<String> naturesList = new ArrayList<String>(Arrays.asList(natures));
            while (naturesList.contains(IDL_NATURE_ID)) {
                naturesList.remove(IDL_NATURE_ID);
            }
            if (naturesList.size() < natures.length) {
                Object[] temp = naturesList.toArray();
                String[] newNatures = new String[temp.length];
                int i = 0;
                while (i < temp.length) {
                    newNatures[i] = (String)temp[i];
                    ++i;
                }
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
            }
        }
    }

    public static IProject createIDLProject(String name, IPath location, boolean addToPath) {
        if (IDLProjectNature.doesProjectExist(name)) {
            return null;
        }
        IProject project = null;
        m_createErrorMsg = "";
        boolean bErrorOccurredDuringProjectCreate = false;
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IProjectDescription description = workspace.newProjectDescription(name);
            description.setLocation(location);
            project = root.getProject(name);
            project.create(description, null);
            project.open(null);
            IDLProjectNature.removeIDLProjectNature(project);
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = IDL_NATURE_ID;
            description.setNatureIds(newNatures);
            m_addToPath = addToPath;
            project.setDescription(description, null);
            IIDLProcessProxy idl = IDLProcessManager.getActiveProcess();
            if (idl != null) {
                idl.getProjectManager().touch(project);
            }
            IDLProjectNature.addIDLBuilderToProject(project);
        }
        catch (CoreException e) {
            e.printStackTrace();
            m_createErrorMsg = e.getStatus().getMessage();
            IStatus[] status_kids = e.getStatus().getChildren();
            if (status_kids.length > 0) {
                int last = status_kids.length - 1;
                m_createErrorMsg = status_kids[last].getMessage();
            }
            bErrorOccurredDuringProjectCreate = true;
        }
        if (bErrorOccurredDuringProjectCreate && project != null) {
            try {
                boolean bDeleteContent = false;
                boolean bForce = true;
                project.delete(bDeleteContent, bForce, null);
            }
            catch (CoreException coreException) {}
            project = null;
        }
        return project;
    }

    public static String getProjectCreationErrorMessage() {
        return m_createErrorMsg;
    }

    public static IDLProjectNature getIDLNature(IProject p) {
        try {
            if (p.hasNature(IDL_NATURE_ID)) {
                return (IDLProjectNature)p.getNature(IDL_NATURE_ID);
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static void setIDLNature(IProject project) {
        try {
            if (project.isOpen() && IDLProjectNature.getIDLNature(project) == null) {
                IProjectDescription description = project.getDescription();
                String[] natures = description.getNatureIds();
                String[] newNatures = new String[natures.length + 1];
                System.arraycopy(natures, 0, newNatures, 0, natures.length);
                newNatures[natures.length] = IDL_NATURE_ID;
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
            }
        }
        catch (CoreException coreException) {}
    }

    public static boolean doesProjectExist(String name) {
        IProject project = null;
        IWorkspace wk = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = wk.getRoot();
        project = root.getProject(name);
        return project.exists();
    }

    public static String getDefaultProjectName() {
        return Messages.DefaultProjectName;
    }

    public static String getNewProjectName() {
        return Messages.NewProjectName;
    }

    public static IProject createDefaultProjectIfNecessary() {
        IProject project = null;
        IWorkspace wk = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = wk.getRoot();
        IProject[] projects = root.getProjects();
        if (projects.length == 0) {
            project = IDLProjectNature.createIDLProject(IDLProjectNature.getDefaultProjectName(), null, true);
        }
        return project;
    }
}

