/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core;

import com.rsi.idldt.core.IDLProjectNature;
import com.rsi.idldt.core.ProjectFile;
import com.rsi.idldt.core.ProjectFileSortComparator;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDLProjectCompileProperties {
    public static final QualifiedName KEY_EXCLUDE_FROM_BUILD = new QualifiedName("", "EXCLUDE_FROM_BUILD");
    public static final QualifiedName KEY_COMPILE_ORDER = new QualifiedName("", "IDL_COMPILE_ORDER");

    public static int getCompileOrderIndex(IFile file) {
        return IDLProjectCompileProperties.getIntValue(file, KEY_COMPILE_ORDER);
    }

    public static boolean isExcludedFromBuild(IFile file) {
        return IDLProjectCompileProperties.getBooleanValue(file, KEY_EXCLUDE_FROM_BUILD);
    }

    public static void setCompileOrderIndex(IFile file, int index) {
        IDLProjectCompileProperties.setStringValue(file, KEY_COMPILE_ORDER, String.valueOf(index));
    }

    public static void setExcludedFromBuild(IFile file, boolean exclude) {
        IDLProjectCompileProperties.setStringValue(file, KEY_EXCLUDE_FROM_BUILD, String.valueOf(exclude));
    }

    public static Vector<IFile> getAllProjectFilesInCompileOrder(final IProject project) {
        final Vector rawList = new Vector();
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        String name = file.getName();
                        if (name.endsWith(".pro")) {
                            rawList.add(new ProjectFile((IFile)resource, IDLProjectCompileProperties.getCompileOrderIndex((IFile)resource)));
                        } else if (name.endsWith(".sav")) {
                            File outputFile = new File(IDLProjectCompileProperties.getProjectSaveFileName(project));
                            File buildFile = resource.getLocation().toFile();
                            if (!buildFile.equals(outputFile)) {
                                rawList.add(new ProjectFile((IFile)resource, IDLProjectCompileProperties.getCompileOrderIndex((IFile)resource)));
                            }
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {}
        Collections.sort(rawList, new ProjectFileSortComparator());
        Vector<IFile> fileList = new Vector<IFile>(rawList.size());
        int count = 0;
        while (count < rawList.size()) {
            fileList.add(((ProjectFile)rawList.get((int)count)).file);
            ++count;
        }
        return fileList;
    }

    public static Vector<IFile> getAllIncludedFilesInOrder(IProject project) {
        return IDLProjectCompileProperties.removeExcludedFiles(IDLProjectCompileProperties.getAllProjectFilesInCompileOrder(project));
    }

    public static Vector<IFile> removeExcludedFiles(Vector<IFile> fileList) {
        Vector<IFile> returnValue = new Vector<IFile>();
        Iterator<IFile> iterator = fileList.iterator();
        IFile temp = null;
        while (iterator.hasNext()) {
            temp = iterator.next();
            if (IDLProjectCompileProperties.isExcludedFromBuild(temp)) continue;
            returnValue.add(temp);
        }
        return returnValue;
    }

    private static int getIntValue(IFile file, QualifiedName key) {
        int value = 0;
        try {
            String stringValue = file.getPersistentProperty(key);
            value = Integer.parseInt(stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            value = 0;
        }
        catch (CoreException coreException) {
            value = 0;
        }
        return value;
    }

    private static boolean getBooleanValue(IFile file, QualifiedName key) {
        boolean value = false;
        try {
            String stringValue = file.getPersistentProperty(key);
            value = Boolean.valueOf(stringValue);
        }
        catch (CoreException coreException) {
            value = false;
        }
        return value;
    }

    private static void setStringValue(IFile file, QualifiedName key, String theValue) {
        String value = theValue;
        if (value == null) {
            value = "";
        }
        try {
            file.setPersistentProperty(key, value);
        }
        catch (CoreException coreException) {}
    }

    static String getProjectSaveFileName(IProject project) {
        String fileName = "";
        try {
            IDLProjectNature nature = (IDLProjectNature)project.getNature("com.rsi.idldt.core.IDLNature");
            fileName = nature.getIDLProjectProperties().getSaveFileOutputPath();
        }
        catch (CoreException coreException) {}
        return fileName;
    }
}

