/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IDLProjectBuildCommandsGenerator;
import com.rsi.idldt.core.Messages;
import com.rsi.idldt.core.internal.interp.commands.CommandSet;
import java.text.DecimalFormat;
import org.eclipse.core.runtime.IProgressMonitor;

public class IDLProjectBuilderWorker {
    private CommandSet buildCommandSet = new CommandSet(true);
    private final IProgressMonitor monitor;
    private String[] buildEcho;
    private String[] idlCommands;
    private int[] directives;
    private int currentBuildStep = 0;
    private boolean buildComplete = false;
    private long compileStartTime;
    private long compileEndTime;
    private long buildStartTime;
    private long buildEndTime;
    private IDLProjectBuildCommandsGenerator buildCmds;
    private DecimalFormat decimalFormat;

    public IDLProjectBuilderWorker(IProgressMonitor buildMonitor, IDLProjectBuildCommandsGenerator buildCommands) {
        this.monitor = buildMonitor;
        this.buildEcho = buildCommands.getEchoCommands();
        this.idlCommands = buildCommands.getIDLCommands();
        this.directives = buildCommands.getDirectives();
        this.buildCmds = buildCommands;
        this.decimalFormat = new DecimalFormat();
        this.decimalFormat.setMaximumFractionDigits(2);
    }

    public boolean executeBuild() {
        boolean success;
        block8: {
            success = true;
            this.monitor.beginTask("", this.buildEcho.length);
            if (this.buildCmds.isBuildInSeparateSession()) {
                this.buildCommandSet.addCommand(this.generateIDLPrintCommand("*** " + Messages.IDLProjectBuilder_ObjNewIDLBridge));
                this.buildCommandSet.addCommand(this.getOPSCreateCommand());
            }
            this.executeBuildCommand();
            IDLProcessManager.getActiveProcess().queueCommand(this.buildCommandSet);
            try {
                try {
                    while (!this.buildComplete) {
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    success = false;
                    this.monitor.done();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.monitor.done();
                throw throwable;
            }
            this.monitor.done();
        }
        if (this.monitor.isCanceled()) {
            success = false;
        }
        return success;
    }

    public boolean executeBuildCommand() {
        String nextEchoCommand = null;
        String nextBuildCommand = null;
        boolean buildCanceled = this.isBuildCanceled();
        if (this.currentBuildStep == this.buildEcho.length || buildCanceled) {
            this.buildComplete = true;
        }
        if (!buildCanceled && !this.buildComplete) {
            switch (this.directives[this.currentBuildStep]) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    nextEchoCommand = this.generateIDLPrintCommand(this.buildEcho[this.currentBuildStep]);
                    break;
                }
                case 4: {
                    this.compileStartTime = System.currentTimeMillis();
                    nextEchoCommand = this.generateIDLPrintCommand(this.buildEcho[this.currentBuildStep]);
                    break;
                }
                case 5: {
                    this.compileEndTime = System.currentTimeMillis();
                    nextEchoCommand = this.generateIDLPrintCommand(String.valueOf(this.buildEcho[this.currentBuildStep]) + this.decimalFormat.format((double)(this.compileEndTime - this.compileStartTime) / 1000.0) + "s");
                    break;
                }
                case 6: {
                    this.buildStartTime = System.currentTimeMillis();
                    nextEchoCommand = this.generateIDLPrintCommand(this.buildEcho[this.currentBuildStep]);
                    break;
                }
                case 7: {
                    this.buildEndTime = System.currentTimeMillis();
                    nextEchoCommand = this.generateIDLPrintCommand(String.valueOf(this.buildEcho[this.currentBuildStep]) + this.decimalFormat.format((double)(this.buildEndTime - this.buildStartTime) / 1000.0) + "s");
                    break;
                }
                case 8: {
                    break;
                }
            }
            if (nextEchoCommand != null) {
                this.buildCommandSet.addCommand(nextEchoCommand);
            }
            nextBuildCommand = this.buildCmds.isBuildInSeparateSession() ? this.wrapCmdInOPSCall(this.idlCommands[this.currentBuildStep]) : this.idlCommands[this.currentBuildStep];
            this.buildCommandSet.addCommand(nextBuildCommand, (Object)this, "executeBuildCommand");
            ++this.currentBuildStep;
            this.monitor.worked(1);
        } else if ((buildCanceled || this.buildComplete) && this.buildCmds.isBuildInSeparateSession()) {
            this.buildCommandSet.addCommand(this.getOPSDestroyCommand());
        }
        return true;
    }

    private boolean isBuildCanceled() {
        return this.monitor != null && this.monitor.isCanceled();
    }

    private String generateIDLPrintCommand(String message) {
        if (message != null) {
            return "PRINT, '" + message.replaceAll("'", "''") + "'";
        }
        return null;
    }

    private String getOPSCreateCommand() {
        return "__oIDLDT_PROJECT_BUILDER = OBJ_NEW('IDL_IDLBRIDGE', /DEBUG)";
    }

    private String wrapCmdInOPSCall(String command) {
        if (command != null) {
            return "__oIDLDT_PROJECT_BUILDER->Execute, '" + command.replaceAll("'", "''") + "'";
        }
        return command;
    }

    private String getOPSDestroyCommand() {
        return "OBJ_DESTROY, __oIDLDT_PROJECT_BUILDER";
    }
}

