/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core;

import com.rsi.idldt.core.IDLProjectBuildCommandsGenerator;
import com.rsi.idldt.core.IDLProjectBuilderWorker;
import com.rsi.idldt.core.IDLProjectNature;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.ResponseManager;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.model.IVariable;

public class IDLProjectBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "com.rsi.idldt.core.IDLBuilder";
    protected static final String SAVE_DIR_VAR_NAME = "_IDLDT$_BUILD$_CURRENT_DIR";
    public static final String EXCLUDE_FROM_BUILD_PROPERTY = "EXCLUDE_FROM_BUILD";
    public static final String COMPILE_ORDER_PROPERTY = "IDL_COMPILE_ORDER";
    protected static boolean m_forgetLastBuiltState = false;
    protected boolean m_projProp_RunInOPS = false;
    protected boolean m_projProp_BeginWithReset = false;
    protected static boolean m_buildIsInProgress = false;
    protected long m_t0;
    protected int m_totalNumFilesToCompile = 0;
    protected int m_numFilesCompiled = 0;

    public static void setForgetLastBuiltState(boolean value) {
        m_forgetLastBuiltState = value;
    }

    public static boolean isBuildInProgress() {
        return m_buildIsInProgress;
    }

    protected boolean isBuildAutomaticallyTurnedOn() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        boolean isAutoBuilding = workspace.isAutoBuilding();
        return isAutoBuilding;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (this.isBuildAutomaticallyTurnedOn()) {
            return null;
        }
        this.forgetLastBuiltState();
        this.m_numFilesCompiled = 0;
        ResponseManager.setBuildIsInProgress(true);
        m_buildIsInProgress = true;
        this.fullBuild(monitor);
        ResponseManager.setBuildIsInProgress(false);
        m_buildIsInProgress = false;
        return null;
    }

    protected boolean getBuildInOPS(IProject project) {
        boolean result = false;
        try {
            IDLProjectNature nature = (IDLProjectNature)project.getNature("com.rsi.idldt.core.IDLNature");
            result = nature.getIDLProjectProperties().isBuildInSeparateSession();
        }
        catch (CoreException coreException) {}
        return result;
    }

    protected void checkCancel(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected int getNumberOfProFiles(IFolder project) {
        int icount = 0;
        try {
            IResource[] resources = project.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFile && resources[i].getName().toLowerCase().endsWith(".pro")) {
                    ++icount;
                } else if (resources[i] instanceof IFolder) {
                    icount += this.getNumberOfProFiles((IFolder)resources[i]);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return icount;
    }

    protected int getNumberOfProFiles(IProject project) {
        int icount = 0;
        try {
            IResource[] resources = project.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFile && resources[i].getName().toLowerCase().endsWith(".pro")) {
                    ++icount;
                } else if (resources[i] instanceof IFolder) {
                    icount += this.getNumberOfProFiles((IFolder)resources[i]);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return icount;
    }

    protected boolean fullBuild(IProgressMonitor monitor) {
        IDLProjectBuildCommandsGenerator buildCommands = new IDLProjectBuildCommandsGenerator(this.getProject());
        buildCommands.generateCommandsFullBuild();
        IDLProjectBuilderWorker worker = new IDLProjectBuilderWorker(monitor, buildCommands);
        return worker.executeBuild();
    }

    public int getIDLError(IIDLProcessProxy idl) {
        int errCode = -999;
        try {
            IVariable temp = idl.getDebugTarget().getSystemVariable("!ERROR_STATE.CODE");
            errCode = Integer.parseInt(temp.getValue().getValueString().trim());
        }
        catch (Exception exception) {}
        return errCode;
    }
}

