/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core;

import com.rsi.idldt.core.CompileRunBucket;
import com.rsi.idldt.core.IDLProjectCompileProperties;
import com.rsi.idldt.core.IDLProjectNature;
import com.rsi.idldt.core.IDLProjectProperties;
import com.rsi.idldt.core.Messages;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class IDLProjectBuildCommandsGenerator {
    public static int HIDDEN_COMMAND = 0;
    public static int COMMAND = 1;
    public static int BUILD_ECHO = 2;
    public static int COMPILE_COMMAND = 3;
    public static int COMPILE_START_TIME = 4;
    public static int COMPILE_END_TIME = 5;
    public static int BUILD_START_TIME = 6;
    public static int BUILD_END_TIME = 7;
    public static int COMMENT = 8;
    private IProject project;
    private IDLProjectProperties props;
    protected static final String SAVE_DIR_VAR_NAME = "_IDLDT$_BUILD$_CURRENT_DIR";
    protected static final String SAVEFILE_OBJ_VAR_NAME = "_IDLDT$_BUILD$_TEMP_SAVEFILE";
    private Vector<String> consoleEcho = new Vector();
    private Vector<String> idlCommands = new Vector();
    private Vector<Boolean> isSilentCommand = new Vector();
    private Vector<Integer> directives = new Vector();
    private boolean addComments;
    private int numFilesToCompile = 0;
    public static final String PREFIX = "*** ";
    private static final String RETALL = "RETALL";

    public IDLProjectBuildCommandsGenerator(IProject project1) {
        this(project1, false);
    }

    public IDLProjectBuildCommandsGenerator(IProject project1, boolean addComments1) {
        this.project = project1;
        this.props = this.getProperties(project1);
        this.addComments = addComments1;
    }

    public void generateCommandsFullBuild() {
        this.addBeginBuildCommand();
        if (this.props.isBuildBeginsWithReset() && !this.props.isBuildInSeparateSession()) {
            this.addResetCommand();
        }
        this.addCommand(null, RETALL, HIDDEN_COMMAND, true);
        this.changeDirToProjectLoc();
        if (!this.isCustomBuild()) {
            if (this.props.getRestoreReferencedProjects()) {
                this.restoreReferencedProjSaveFiles();
            }
            if (this.props.getExecutePreCompileCommand()) {
                this.addPreCompileCommand();
            }
            if (this.props.getCompileProjectFiles()) {
                this.addCompileAndRestoreCommands();
            }
            if (this.props.getResolveDependencies()) {
                this.addResolveCommand();
            }
            if (this.props.getExecutePostCompileCommand()) {
                this.addPostCompileCommand();
            }
        } else {
            this.addCustomBuildCommand();
        }
        if (this.props.isCreateSaveFile()) {
            this.addCreateSaveFileCommand();
        }
        this.changeDirToOrigLoc();
        this.addEndBuildCommand();
    }

    public void setAddComments(boolean addComments1) {
        this.addComments = addComments1;
    }

    public boolean isAddComments() {
        return this.addComments;
    }

    private void addBeginBuildCommand() {
        String beginBuildMessage = "\n*** " + Messages.IDLProjectBuilder_BuildingIDLProject + " '" + this.project.getName() + "'";
        this.addCommand(beginBuildMessage, null, BUILD_START_TIME, false);
    }

    private void addEndBuildCommand() {
        this.addCommand(PREFIX + Messages.IDLProjectBuilder_BuildComplete + " " + Messages.IDLProjectBuilder_ExecutionTime + " = ", null, BUILD_END_TIME, false);
    }

    private void addResetCommand() {
        this.addComment("; RESET IDL Session");
        this.addCommand(PREFIX + Messages.IDLProjectBuilder_RunningDotReset, ".RESET_SESSION", COMMAND, true);
        this.addComment("");
    }

    private void changeDirToProjectLoc() {
        String projectDir = this.project.getLocation().toOSString();
        projectDir = projectDir.replaceAll("'", "''");
        String command = "CD, '" + projectDir + "', CURRENT=" + SAVE_DIR_VAR_NAME;
        this.addCommand(null, command, HIDDEN_COMMAND, true);
    }

    private void changeDirToOrigLoc() {
        String command = "CD, _IDLDT$_BUILD$_CURRENT_DIR";
        this.addCommand(null, command, HIDDEN_COMMAND, true);
        command = "DELVAR,_IDLDT$_BUILD$_CURRENT_DIR";
        this.addCommand(null, command, HIDDEN_COMMAND, true);
    }

    private void restoreReferencedProjSaveFiles() {
        try {
            IProject[] ref_prjs = this.project.getReferencedProjects();
            if (ref_prjs.length > 0) {
                this.addComment("; Restore save files from referenced projects");
                if (ref_prjs.length > 0) {
                    int i = 0;
                    while (i < ref_prjs.length) {
                        String save_file = this.getProjectSaveFilename(ref_prjs[i]);
                        if (save_file != null) {
                            String restoreCommand = "RESTORE, '" + save_file.replaceAll("'", "''") + "'";
                            this.addCommand(restoreCommand, restoreCommand, COMMAND, true);
                        }
                        ++i;
                    }
                }
                this.addComment("");
            }
        }
        catch (CoreException coreException) {}
    }

    private void addPreCompileCommand() {
        String preCompileCommand = this.props.getPreCompileCommand();
        if (!preCompileCommand.equals("")) {
            this.addComment("; Execute the Pre-compile command");
        }
        this.addCommand(PREFIX + Messages.IDLProjectBuilder_RunningBuildCommand + ' ' + preCompileCommand, preCompileCommand, COMMAND, true);
        this.addComment("");
    }

    private void addResolveCommand() {
        String resolveCommand = "RESOLVE_ALL, /CONTINUE_ON_ERROR";
        this.addComment("; Resolve all routines");
        this.addCommand(PREFIX + Messages.IDLProjectBuilder_RunningBuildCommand + ' ' + resolveCommand, resolveCommand, COMMAND, true);
        this.addComment("");
    }

    private void addPostCompileCommand() {
        String postCompileCommand = this.props.getPostCompileCommand();
        if (!postCompileCommand.equals("")) {
            this.addComment("; Execute the post-compile command");
        }
        this.addCommand(PREFIX + Messages.IDLProjectBuilder_RunningBuildCommand + ' ' + postCompileCommand, postCompileCommand, COMMAND, true);
        this.addComment("");
    }

    private void addCustomBuildCommand() {
        String customBuildCommand = this.props.getBuildCommand();
        if (!customBuildCommand.equals("")) {
            this.addComment("; Execute the custom build command");
        }
        this.addCommand(PREFIX + Messages.IDLProjectBuilder_RunningBuildCommand + ' ' + customBuildCommand, customBuildCommand, COMMAND, true);
        this.addComment("");
    }

    private void addCompileAndRestoreCommands() {
        Vector<IFile> files = IDLProjectCompileProperties.getAllIncludedFilesInOrder(this.project);
        this.numFilesToCompile = files.size();
        if (files.size() > 0) {
            String compileCommand;
            CompileRunBucket bucket = new CompileRunBucket();
            bucket.setProject(this.project);
            this.addComment("; Compile project files");
            this.addCommand(PREFIX + Messages.IDLProjectBuilder_CompilingFiles, null, COMPILE_START_TIME, false);
            for (IFile file : files) {
                if (file.getName().toLowerCase().endsWith(".pro")) {
                    bucket.append(file.getLocation().toOSString());
                    if (!bucket.isBucketFull()) continue;
                    compileCommand = bucket.getContentsOfBucket();
                    this.addCommand(PREFIX + compileCommand, compileCommand, COMPILE_COMMAND, true);
                    continue;
                }
                if (!file.getName().toLowerCase().endsWith(".sav")) continue;
                compileCommand = bucket.getContentsOfBucket();
                if (!compileCommand.equals("")) {
                    this.addCommand(PREFIX + compileCommand, compileCommand, COMPILE_COMMAND, true);
                }
                this.addRestoreSaveFileCommand(file.getLocation().toOSString());
                --this.numFilesToCompile;
            }
            compileCommand = bucket.getContentsOfBucket();
            if (!compileCommand.equals("")) {
                this.addCommand(PREFIX + compileCommand, compileCommand, COMPILE_COMMAND, true);
            }
            String compileComplete = PREFIX + Messages.IDLProjectBuilder_CompilingComplete + " " + Messages.IDLProjectBuilder_ExecutionTime + " = ";
            this.addCommand(compileComplete, null, COMPILE_END_TIME, false);
            IFile file = files.lastElement();
            if (file.getName().endsWith(".pro")) {
                this.addComment("");
            }
        }
    }

    private void addRestoreSaveFileCommand(String filePath) {
        String echo = "RESTORE, " + filePath;
        String objCreateCmd = "_IDLDT$_BUILD$_TEMP_SAVEFILE=OBJ_NEW('IDL_Savefile', '" + filePath + "')";
        String objCondExpCmd = "IF (TOTAL(_IDLDT$_BUILD$_TEMP_SAVEFILE->Names(/PROCEDURE) EQ '') EQ 0 || TOTAL(_IDLDT$_BUILD$_TEMP_SAVEFILE->Names(/FUNCTION) EQ '') EQ 0) THEN ";
        String rstrCmd = "RESTORE, '" + filePath + "'";
        String rstrMsgCmd = "PRINT, '*** " + echo + "'";
        String objDtryCmd = "OBJ_DESTROY, _IDLDT$_BUILD$_TEMP_SAVEFILE";
        String objDelVarCmd = "DELVAR, _IDLDT$_BUILD$_TEMP_SAVEFILE";
        this.addComment("");
        this.addComment("; Restore file " + filePath);
        this.addCommand(null, objCreateCmd, COMMAND, true);
        this.addCommand(null, String.valueOf(objCondExpCmd) + rstrMsgCmd, HIDDEN_COMMAND, true);
        this.addCommand(null, String.valueOf(objCondExpCmd) + rstrCmd, COMMAND, true);
        this.addCommand(null, objDtryCmd, COMMAND, true);
        this.addCommand(null, objDelVarCmd, COMMAND, true);
        this.addComment("");
    }

    private void addCreateSaveFileCommand() {
        String saveFilename = this.getProjectSaveFilename(this.project);
        saveFilename = saveFilename.replaceAll("'", "''");
        String cmd = "SAVE, /ROUTINES, FILENAME='" + saveFilename + "', /VERBOSE";
        if (this.props.isCreateLicensedSaveFile()) {
            cmd = String.valueOf(cmd) + ", /EMBEDDED";
        }
        this.addComment("; Create the project save file");
        this.addCommand(PREFIX + Messages.IDLProjectBuilder_RunningSaveCommand, cmd, COMMAND, true);
        this.addComment("");
        StringBuffer sb = new StringBuffer();
        sb.append(PREFIX);
        sb.append(this.props.isCreateLicensedSaveFile() ? Messages.IDLProjectBuilder_LicensedSaveFile : Messages.IDLProjectBuilder_SaveFile);
        sb.append("  At: ");
        sb.append(this.getProjectSaveFilename(this.project));
        this.addCommand(sb.toString(), null, BUILD_ECHO, false);
    }

    private String getProjectSaveFilename(IProject project1) {
        return this.getProperties(project1).getSaveFileOutputPath();
    }

    public void addCommand(String consoleEcho1, String idlCommand, Integer directive, boolean isSilent) {
        this.consoleEcho.add(consoleEcho1);
        this.idlCommands.add(idlCommand);
        this.directives.add(directive);
        this.isSilentCommand.add(isSilent);
    }

    public void addComment(String comment) {
        if (this.isAddComments()) {
            this.addCommand(null, comment, COMMENT, false);
        }
    }

    public String[] getEchoCommands() {
        String[] value = new String[this.consoleEcho.size()];
        int index = 0;
        while (index < this.consoleEcho.size()) {
            value[index] = this.consoleEcho.get(index);
            ++index;
        }
        return value;
    }

    public String[] getIDLCommands() {
        String[] value = new String[this.idlCommands.size()];
        int index = 0;
        while (index < this.idlCommands.size()) {
            value[index] = this.idlCommands.get(index);
            ++index;
        }
        return value;
    }

    public int[] getDirectives() {
        int[] value = new int[this.directives.size()];
        int index = 0;
        while (index < this.directives.size()) {
            value[index] = this.directives.get(index);
            ++index;
        }
        return value;
    }

    public boolean[] getIsCommandSilent() {
        boolean[] value = new boolean[this.isSilentCommand.size()];
        int index = 0;
        while (index < this.isSilentCommand.size()) {
            value[index] = this.isSilentCommand.get(index);
            ++index;
        }
        return value;
    }

    public int getNumberOfFilesToCompile() {
        return this.numFilesToCompile;
    }

    public String getViewableScript() {
        String script = "";
        int[] direc = this.getDirectives();
        String[] cmds = this.getIDLCommands();
        int index = 0;
        while (index < cmds.length) {
            switch (direc[index]) {
                case 1: 
                case 3: 
                case 8: {
                    script = String.valueOf(script) + cmds[index] + "\n";
                    break;
                }
            }
            ++index;
        }
        return script;
    }

    public boolean isBuildInSeparateSession() {
        return this.props.isBuildInSeparateSession();
    }

    private IDLProjectProperties getProperties(IProject project1) {
        IDLProjectProperties props1;
        IDLProjectNature nature = null;
        try {
            nature = (IDLProjectNature)project1.getNature("com.rsi.idldt.core.IDLNature");
            props1 = nature.getIDLProjectProperties();
        }
        catch (CoreException coreException) {
            props1 = null;
        }
        catch (Exception exception) {
            props1 = null;
        }
        return props1;
    }

    private boolean isCustomBuild() {
        return this.props.isCustomBuild();
    }
}

