/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core;

import com.rsi.idldt.core.ICommandLineHandler;
import com.rsi.idldt.core.IDLDTCorePlugin;
import com.rsi.idldt.core.IGUIHandler;
import com.rsi.idldt.core.IHandlerChangedListener;
import com.rsi.idldt.core.IIDLProcessListener;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.IOutputLogHandler;
import com.rsi.idldt.core.Messages;
import com.rsi.idldt.core.internal.DMLInitializer;
import com.rsi.idldt.core.internal.DefaultCommandLineHandler;
import com.rsi.idldt.core.internal.DefaultGUIHandler;
import com.rsi.idldt.core.internal.DefaultOutputLogHandler;
import com.rsi.idldt.core.internal.IDLProcessProxy;
import com.rsi.idldt.core.interp.ICommandListener;
import com.rsi.idldt.core.utils.Rectangle;
import com.rsi.jdml.DMLAccess;
import com.rsi.jdml.IDLPreferencesDTO;
import com.rsi.jdml.LibraryLoadException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.Vector;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ui.PlatformUI;

public class IDLProcessManager {
    protected static IIDLProcessProxy g_currentActiveProcess;
    private static AbstractList<IIDLProcessProxy> g_processes;
    private static ICommandLineHandler g_commandLineHandler;
    private static IGUIHandler g_guiHandler;
    private static IOutputLogHandler g_outputLogHandler;
    private static String g_idlDir;
    private static AbstractList<IIDLProcessListener> g_processListeners;

    static {
        g_processes = new Vector<IIDLProcessProxy>(1);
        g_processListeners = new Vector<IIDLProcessListener>(8);
        IDLProcessManager.setCommandLineHandler(new DefaultCommandLineHandler());
        IDLProcessManager.setGUIHandler(new DefaultGUIHandler());
        IDLProcessManager.setLogWindowHandler(new DefaultOutputLogHandler());
    }

    private static void openFileArgument(final String file) {
        if (file.toLowerCase().endsWith(".pro") || file.toLowerCase().endsWith(".sav") || file.toLowerCase().endsWith(".isv")) {
            IDLProcessManager.getGUIHandler().handleOpenFile(file);
        } else {
            IExtensionRegistry reg = RegistryFactory.getRegistry();
            if (reg != null) {
                reg.addRegistryChangeListener(new IRegistryChangeListener(){

                    public void registryChanged(IRegistryChangeEvent event) {
                        IExtensionDelta[] extensionDeltas = event.getExtensionDeltas();
                        int i = 0;
                        while (i < extensionDeltas.length) {
                            String name;
                            if (extensionDeltas[i].getKind() == 1 && "com.rsi.idldt.toolpalette.IDLiOpenLauncher".equals(name = extensionDeltas[i].getExtension().getSimpleIdentifier())) {
                                IDLProcessManager.getGUIHandler().handleOpenFile(file);
                                IExtensionRegistry reg1 = RegistryFactory.getRegistry();
                                if (reg1 != null) {
                                    reg1.removeRegistryChangeListener((IRegistryChangeListener)this);
                                }
                            }
                            ++i;
                        }
                    }
                });
            }
        }
    }

    public static void createIDLProcess() {
        String finalArgument = IDLProcessManager.initializeDML();
        IDLProcessManager.createAndStartProcess();
        if (finalArgument != null) {
            if (finalArgument.charAt(0) == '-') {
                String command = "message, 'Unrecognized option. Option: " + finalArgument + "', /INFO, /NONAME";
                IDLProcessManager.queueSilentExecuteString(command);
            } else {
                IDLProcessManager.openFileArgument(finalArgument);
            }
        }
    }

    private static String initializeDML() {
        DMLInitializer init = new DMLInitializer();
        IDLProcessManager.saveIDLDirLocation(init);
        int retVal = 0;
        String message = null;
        Throwable x = null;
        String[] argsApp = IDLDTCorePlugin.getApplicationArgs();
        String[] argsIDL = new String[argsApp.length];
        int ndx = 0;
        String batchCmd = null;
        String fileToOpen = null;
        int i = 0;
        while (i < argsApp.length) {
            if (argsApp[i].equals("-32") || argsApp[i].equals("-64")) {
                init.setArch(argsApp[i]);
            } else if (!argsApp[i].equals("-minimized")) {
                if (argsApp[i].equals("-demo") || argsApp[i].equals("-em") || argsApp[i].length() > 4 && argsApp[i].substring(0, 4).equals("-em=") || argsApp[i].equals("-genver") || argsApp[i].equals("-novm") || argsApp[i].length() > 5 && argsApp[i].substring(0, 5).equals("-pref") || argsApp[i].equals("-queue") || argsApp[i].equals("-quiet") || argsApp[i].equals("-rt") || argsApp[i].length() > 4 && argsApp[i].substring(0, 4).equals("-rt=") || argsApp[i].equals("-student") || argsApp[i].equals("-ulicense") || argsApp[i].equals("-vm") || argsApp[i].length() > 4 && argsApp[i].substring(0, 4).equals("-vm=") || argsApp[i].equals("-nodemowarn")) {
                    argsIDL[ndx++] = argsApp[i];
                } else if (i < argsApp.length - 1 && argsApp[i].equals("-args")) {
                    argsIDL[ndx++] = argsApp[i];
                    while (i < argsApp.length - 1) {
                        argsIDL[ndx++] = argsApp[++i];
                    }
                } else if (i < argsApp.length - 1 && (argsApp[i].equals("-arg") || argsApp[i].equals("-e") || argsApp[i].length() > 5 && argsApp[i].substring(0, 5).equals("-IDL_") || argsApp[i].length() > 5 && argsApp[i].substring(0, 5).equals("-idl_"))) {
                    argsIDL[ndx++] = argsApp[i];
                    argsIDL[ndx++] = argsApp[i + 1];
                    ++i;
                } else if (i < argsApp.length - 1 && argsApp[i].equals("-batch")) {
                    if (i < argsApp.length - 1) {
                        batchCmd = argsApp[i + 1];
                        ++i;
                    }
                } else if (i == argsApp.length - 1) {
                    if (argsApp[i].charAt(0) == '@') {
                        if (argsApp[i].length() > 1) {
                            argsApp[i] = argsApp[i].substring(1);
                        }
                        argsIDL[ndx++] = argsApp[i];
                    } else {
                        fileToOpen = argsApp[i].toString();
                    }
                }
            }
            ++i;
        }
        if (batchCmd != null && batchCmd.length() > 0) {
            argsIDL[ndx++] = batchCmd;
        }
        init.setArgs(argsIDL);
        try {
            retVal = DMLAccess.initializeDML(init);
        }
        catch (LibraryLoadException e) {
            message = "JDML failed to load";
            x = e;
        }
        catch (Throwable e2) {
            message = "JDML failed to load or initialize";
            x = e2;
        }
        if (message != null || retVal < 0) {
            MultiStatus status = null;
            status = new MultiStatus("com.rsi.idldt.core", 4, "", null);
            status.add((IStatus)new Status(4, "com.rsi.idldt.core", 4, "  ", null));
            status.add((IStatus)new Status(4, "com.rsi.idldt.core", 4, Messages.IDLProcessManager_ErrorStatus3, null));
            status.add((IStatus)new Status(4, "com.rsi.idldt.core", 4, "   IDL : " + init.getIDLLocation(), null));
            status.add((IStatus)new Status(4, "com.rsi.idldt.core", 4, "   BML : " + init.getBMLLocation(), null));
            status.add((IStatus)new Status(4, "com.rsi.idldt.core", 4, "   DML : " + init.getDMLLocation(), null));
            status.add((IStatus)new Status(4, "com.rsi.idldt.core", 4, "   JDML: " + init.getJDMLLocation(), null));
            IDLProcessManager.handleFatalError((Status)status, Messages.IDLProcessManager_ErrorStatus1, x);
        }
        return fileToOpen;
    }

    public static void addProcess(IIDLProcessProxy idl) {
        g_processes.add(idl);
    }

    public static void setActiveProcess(IIDLProcessProxy idl) {
        if (idl != null && idl != g_currentActiveProcess) {
            if (g_currentActiveProcess != null) {
                g_currentActiveProcess.deactivate();
            }
            g_currentActiveProcess = idl;
            idl.activate();
            IDLProcessManager.notifyOfActivatedProcess(idl);
        }
    }

    public static IIDLProcessProxy getActiveProcess() {
        return g_currentActiveProcess;
    }

    public static IIDLProcessProxy getProcessByID(long id) {
        IIDLProcessProxy idl = null;
        int i = 0;
        while (i < g_processes.size()) {
            idl = g_processes.get(i);
            if (idl.getDebugID() == id) break;
            idl = null;
            ++i;
        }
        return idl;
    }

    public static IIDLProcessProxy waitForActiveProcess() {
        return IDLProcessManager.waitForActiveProcess(10000L);
    }

    public static IIDLProcessProxy waitForActiveProcess(long timeout) {
        long t = 0L;
        while (g_currentActiveProcess == null && (timeout <= 0L || t < timeout)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            t += 100L;
        }
        return g_currentActiveProcess;
    }

    public static void addProcessListener(IIDLProcessListener l) {
        if (l != null && !g_processListeners.contains(l)) {
            g_processListeners.add(l);
        }
    }

    public static void removeProcessListener(IIDLProcessListener l) {
        if (l != null) {
            g_processListeners.remove(l);
        }
    }

    private static void notifyOfNewProcess(IIDLProcessProxy idl) {
        Object[] listeners = g_processListeners.toArray();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] != null) {
                ((IIDLProcessListener)listeners[i]).handleNewProcess(idl);
            }
            ++i;
        }
    }

    private static void notifyOfDeletedProcess(IIDLProcessProxy idl) {
        Object[] listeners = g_processListeners.toArray();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] != null) {
                ((IIDLProcessListener)listeners[i]).handleDeletedProcess(idl);
            }
            ++i;
        }
    }

    private static void notifyOfActivatedProcess(IIDLProcessProxy idl) {
        Object[] listeners = g_processListeners.toArray();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] != null) {
                ((IIDLProcessListener)listeners[i]).handleActivatedProcess(idl);
            }
            ++i;
        }
    }

    private static void saveIDLDirLocation(DMLInitializer dmlInit) {
        String pathSep;
        String binPath;
        int idx;
        String loc = dmlInit.getIDLLocation().getLocation();
        g_idlDir = loc.substring(0, (idx = loc.lastIndexOf(binPath = String.valueOf(pathSep = System.getProperty("file.separator")) + "bin" + pathSep)) + 1);
        if (g_idlDir.length() == 0) {
            g_idlDir = System.getProperty("IDL_DIR");
        }
        if (!g_idlDir.endsWith(pathSep)) {
            g_idlDir = String.valueOf(g_idlDir) + pathSep;
        }
    }

    public static String getIdlDir() {
        return g_idlDir;
    }

    public static IIDLProcessProxy createAndStartProcess() {
        IDLProcessProxy idl = new IDLProcessProxy();
        idl.createAndStartProcess();
        if (idl.getDebugID() > 0L) {
            IDLProcessManager.notifyOfNewProcess(idl);
            IDLProcessManager.setActiveProcess(idl);
            idl.getDebugTarget().postStartup();
        }
        return idl;
    }

    public static void reset(IIDLProcessProxy idl) {
        idl.resetProcess();
        idl.getDebugTarget().performReset();
    }

    public static void destroyProcess(IIDLProcessProxy oldIDL, IIDLProcessProxy newIDL) {
        IDLProcessManager.setActiveProcess(newIDL);
        g_processes.remove(oldIDL);
        oldIDL.destroyProcess();
        IDLProcessManager.notifyOfDeletedProcess(oldIDL);
    }

    public static void exiting() {
        for (IIDLProcessProxy idl : g_processes) {
            idl.exiting();
        }
    }

    public static ICommandLineHandler getCommandLineHandler() {
        return g_commandLineHandler;
    }

    public static void setCommandLineHandler(ICommandLineHandler handler) {
        ICommandLineHandler oldHandler = g_commandLineHandler;
        g_commandLineHandler = handler;
        if (oldHandler != null) {
            oldHandler.transfer(handler);
        }
        if (g_processes != null && g_processes.size() > 0) {
            IHandlerChangedListener idl = null;
            int i = 0;
            while (i < g_processes.size()) {
                idl = (IHandlerChangedListener)((Object)g_processes.get(i));
                idl.commandLineHandlerChanged(oldHandler, g_commandLineHandler);
                ++i;
            }
        }
    }

    public static IGUIHandler getGUIHandler() {
        return g_guiHandler;
    }

    public static void setGUIHandler(IGUIHandler handler) {
        IGUIHandler oldHandler = g_guiHandler = handler;
        if (g_processes != null && g_processes.size() > 0) {
            IHandlerChangedListener idl = null;
            int i = 0;
            while (i < g_processes.size()) {
                idl = (IHandlerChangedListener)((Object)g_processes.get(i));
                idl.guiHandlerChanged(oldHandler, g_guiHandler);
                ++i;
            }
        }
    }

    public static IOutputLogHandler getLogWindowHandler() {
        return g_outputLogHandler;
    }

    public static void setLogWindowHandler(IOutputLogHandler handler) {
        IOutputLogHandler oldHandler = g_outputLogHandler;
        g_outputLogHandler = handler;
        if (oldHandler != null) {
            oldHandler.transfer(handler);
        }
        if (g_processes != null && g_processes.size() > 0) {
            IHandlerChangedListener idl = null;
            int i = 0;
            while (i < g_processes.size()) {
                idl = (IHandlerChangedListener)((Object)g_processes.get(i));
                idl.logHandlerChanged(oldHandler, g_outputLogHandler);
                ++i;
            }
        }
    }

    public static void setTTYSize(Rectangle tty) {
        if (g_processes != null && g_processes.size() > 0) {
            IIDLProcessProxy idl = null;
            int i = 0;
            while (i < g_processes.size()) {
                idl = g_processes.get(i);
                idl.getCommandManager().setTTYSize(tty);
                ++i;
            }
        }
    }

    public static boolean isDebugging() {
        try {
            return IDLProcessManager.getActiveProcess().getDebugTarget().getThread().isDebugging();
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public static synchronized void queueExecuteString(String c) {
        IDLProcessManager.getActiveProcess().queueExecuteString(c);
    }

    public static synchronized void queueSilentExecuteString(String c) {
        IDLProcessManager.getActiveProcess().queueSilentExecuteString(c);
    }

    public static synchronized void queueSetIDLPreferences(IDLPreferencesDTO prefs) {
        IDLProcessManager.getActiveProcess().queueSetIDLPreferences(prefs);
    }

    public static synchronized void queueGetIDLPreferences(IDLPreferencesDTO prefs, ICommandListener listener) {
        IDLProcessManager.getActiveProcess().queueGetIDLPreferences(prefs, listener);
    }

    public static synchronized void queueGetDefaultIDLPreferences(IDLPreferencesDTO prefs, ICommandListener listener) {
        IDLProcessManager.getActiveProcess().queueGetDefaultIDLPreferences(prefs, listener);
    }

    public static void handleFatalError(Status children, String message, Throwable x) {
        final MultiStatus status = new MultiStatus("com.rsi.idldt.core", 4, message, null);
        if (children != null) {
            status.addAll((IStatus)children);
            status.add((IStatus)new Status(4, "com.rsi.idldt.core", 4, " ", null));
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            x.printStackTrace(ps);
            ps.flush();
            baos.flush();
            String[] lines = baos.toString().split("[\n\r]");
            int i = 0;
            while (i < lines.length) {
                String line = lines[i];
                if (line != null && line.length() > 0) {
                    status.add((IStatus)new Status(4, "com.rsi.idldt.core", 4, line.replaceAll("\t", "   "), null));
                }
                ++i;
            }
        }
        catch (IOException iOException) {}
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError(null, null, null, (IStatus)status);
                if (!status.isOK() && IDLDTCorePlugin.isIDLWorkbenchProduct()) {
                    IDLProcessManager.exiting();
                    System.exit(0);
                }
            }
        });
    }
}

