/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.Messages;
import com.rsi.idldt.core.utils.Tracer;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class IDLDTCorePlugin
extends Plugin {
    private static IDLDTCorePlugin plugin;
    public static final String ID_PLUGIN = "com.rsi.idldt.core";
    public static final String ID_PRODUCT = "com.rsi.idldt.workbench";
    public static final String ID_IDL_DEBUG_MODEL = "idl.debugModel";
    private BundleListener bundleListener;
    static boolean exited;

    static {
        exited = false;
    }

    public IDLDTCorePlugin() {
        plugin = this;
    }

    public void start(final BundleContext context) throws Exception {
        super.start(context);
        try {
            Tracer.trace(Tracer.TRACE_DML, "Bundle location=" + IDLDTCorePlugin.getDefault().getBundle().getLocation());
            Tracer.trace(Tracer.TRACE_DML, "Install location=" + Platform.getInstallLocation().getURL());
            Tracer.trace(Tracer.TRACE_DML, "Install path=" + Platform.getInstallLocation().getURL().getPath());
            Tracer.trace(Tracer.TRACE_DML, "Dev mode=" + Platform.inDevelopmentMode());
            Tracer.trace(Tracer.TRACE_DML, "NL=" + Platform.getNL());
            Tracer.trace(Tracer.TRACE_DML, "OS=" + Platform.getOS());
            Tracer.trace(Tracer.TRACE_DML, "OSArch=" + Platform.getOSArch());
            String[] args = Platform.getCommandLineArgs();
            String s = "";
            int i = 0;
            while (i < args.length) {
                s = String.valueOf(s) + args[i] + " ";
                ++i;
            }
            Tracer.trace(Tracer.TRACE_DML, "Cmd Line Args= " + s);
        }
        catch (Exception exception) {}
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)new IDLWorkbenchListener());
        this.bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle() == IDLDTCorePlugin.this.getBundle() && event.getType() == 2) {
                    if (IDLDTCorePlugin.this.getBundle().getState() == 32) {
                        PostCoreBundleStartJob j = new PostCoreBundleStartJob(Messages.IDLDTCorePlugin_PostStartJob);
                        j.setPriority(20);
                        j.setSystem(true);
                        j.schedule();
                    }
                    context.removeBundleListener((BundleListener)this);
                }
            }
        };
        context.addBundleListener(this.bundleListener);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.bundleListener != null) {
            context.removeBundleListener(this.bundleListener);
        }
        plugin = null;
    }

    public static void performIDEExit() {
        if (!exited) {
            exited = true;
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    IDLDTCorePlugin.getWorkbench().close();
                }
            });
        }
    }

    public static boolean isIDLWorkbenchProduct() {
        String product = System.getProperty("eclipse.product");
        return product != null && product.equals(ID_PRODUCT);
    }

    public static IDLDTCorePlugin getDefault() {
        return plugin;
    }

    public static IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public static String getPluginIdentifier() {
        return ID_PLUGIN;
    }

    public static String[] getApplicationArgs() {
        String[] appArgs = Platform.getApplicationArgs();
        Vector<String> v = new Vector<String>(appArgs.length);
        int i = 0;
        while (i < appArgs.length) {
            if (appArgs[i].compareToIgnoreCase("-showlocation") != 0) {
                v.add(appArgs[i]);
            }
            ++i;
        }
        return v.toArray(new String[v.size()]);
    }

    class IDLWorkbenchListener
    implements IWorkbenchListener {
        IDLWorkbenchListener() {
        }

        public boolean preShutdown(IWorkbench workbench, boolean forced) {
            return true;
        }

        public void postShutdown(IWorkbench workbench) {
            IDLProcessManager.exiting();
        }
    }

    private class PostCoreBundleStartJob
    extends Job {
        public PostCoreBundleStartJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            IDLProcessManager.createIDLProcess();
            return Status.OK_STATUS;
        }
    }
}

