/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.core;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import org.eclipse.core.resources.IProject;

class CompileRunBucket {
    protected static final int MAX_BUF_LENGTH = 4095;
    protected static final int MAX_FILES_TO_COMPILE = 1;
    protected static final String COMPILE_DIRECTIVE = ".COMPILE ";
    protected IIDLProcessProxy m_idlProcess = null;
    protected StringBuffer m_buffer = new StringBuffer();
    protected int m_numberOfFilesInBucket = 0;
    protected int m_compileCount = 0;
    protected IProject m_project;
    protected Boolean bucketFull = false;

    public CompileRunBucket() {
        this.m_buffer.append(COMPILE_DIRECTIVE);
    }

    public void setProject(IProject project) {
        this.m_project = project;
    }

    public void reset() {
        this.m_compileCount = 0;
        this.m_numberOfFilesInBucket = 0;
        this.bucketFull = false;
    }

    public boolean append(String fileToCompile) {
        if (this.bucketFull.booleanValue()) {
            return false;
        }
        StringBuffer sb = new StringBuffer();
        char quote = fileToCompile.indexOf(39) >= 0 ? (char)'\"' : '\'';
        sb.append(quote);
        sb.append(fileToCompile.trim());
        sb.append(quote);
        ++this.m_numberOfFilesInBucket;
        if (this.m_numberOfFilesInBucket + 1 > 1) {
            this.bucketFull = true;
        }
        if (this.m_buffer.length() + sb.length() + 2 > 4095) {
            this.bucketFull = true;
        }
        this.m_buffer.append(sb.toString());
        this.m_buffer.append(", ");
        return true;
    }

    public boolean isBucketFull() {
        return this.bucketFull;
    }

    public String getContentsOfBucket() {
        ++this.m_compileCount;
        if (this.m_idlProcess == null) {
            this.m_idlProcess = IDLProcessManager.getActiveProcess();
        }
        if (this.m_numberOfFilesInBucket > 0) {
            int len = this.m_buffer.length() - 2;
            String compileCommand = this.m_buffer.substring(0, len);
            this.m_buffer = new StringBuffer();
            this.m_buffer.append(COMPILE_DIRECTIVE);
            this.m_numberOfFilesInBucket = 0;
            this.bucketFull = false;
            return compileCommand;
        }
        return "";
    }
}

