/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.AbstractViewer;
import org.eclipse.compare.internal.ICompareAsText;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class BinaryCompareViewer
extends AbstractViewer {
    private static final String BUNDLE_NAME = "org.eclipse.compare.internal.BinaryCompareViewerResources";
    private static final int EOF = -1;
    private ICompareInput fInput;
    private ResourceBundle fBundle;
    private boolean fLeftIsLocal;
    private Composite fComposite;
    private Label fMessage;
    private Button fTextButton;
    static /* synthetic */ Class class$0;

    public BinaryCompareViewer(Composite parent, final CompareConfiguration cc) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.compare.binary_compare_view_context");
        this.fBundle = ResourceBundle.getBundle(BUNDLE_NAME);
        this.fComposite = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        this.fComposite.setLayout((Layout)rowLayout);
        this.fMessage = new Label(this.fComposite, 64);
        this.fMessage.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)Utilities.getString(this.fBundle, "title"));
        this.fLeftIsLocal = Utilities.getBoolean(cc, "LEFT_IS_LOCAL", false);
        if (this.canShowAsText(cc)) {
            this.fTextButton = new Button(this.fComposite, 8);
            this.fTextButton.setText(Utilities.getString(this.fBundle, "compareAsText"));
            this.fTextButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this, cc){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ CompareConfiguration val$cc;
                        {
                            this.this$1 = var1_1;
                            this.val$cc = compareConfiguration;
                        }

                        public void run() {
                            1.access$0(this.this$1).handleShowAsText(this.val$cc);
                        }
                    });
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                static /* synthetic */ BinaryCompareViewer access$0(1 var0) {
                    return var0.BinaryCompareViewer.this;
                }
            });
            this.fTextButton.setEnabled(false);
        }
    }

    private boolean canShowAsText(CompareConfiguration cc) {
        if (cc == null) {
            return false;
        }
        ICompareContainer iCompareContainer = cc.getContainer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.compare.internal.ICompareAsText");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return Utilities.getAdapter(iCompareContainer, clazz) != null;
    }

    protected void handleShowAsText(CompareConfiguration cc) {
        ICompareContainer iCompareContainer = cc.getContainer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.compare.internal.ICompareAsText");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICompareAsText comparer = (ICompareAsText)Utilities.getAdapter(iCompareContainer, clazz);
        comparer.compareAsText(this.getInput());
    }

    public Control getControl() {
        return this.fComposite;
    }

    public void setInput(Object input) {
        if (this.fComposite != null && input instanceof ICompareInput) {
            String message;
            block20: {
                this.fInput = (ICompareInput)input;
                InputStream left = null;
                InputStream right = null;
                message = null;
                try {
                    left = this.getStream(this.fInput.getLeft());
                    right = this.getStream(this.fInput.getRight());
                    if (left != null && right != null) {
                        int pos = 0;
                        while (true) {
                            int r;
                            int l;
                            if ((l = left.read()) != (r = right.read())) {
                                String format = Utilities.getString(this.fBundle, "diffMessageFormat");
                                message = MessageFormat.format((String)format, (Object[])new String[]{Integer.toString(pos)});
                            } else if (l != -1) {
                                ++pos;
                                continue;
                            }
                            break;
                        }
                    } else if (left == null && right == null) {
                        message = Utilities.getString(this.fBundle, "deleteConflictMessage");
                    } else if (left == null) {
                        message = this.fLeftIsLocal ? Utilities.getString(this.fBundle, "deletedMessage") : Utilities.getString(this.fBundle, "addedMessage");
                    } else if (right == null) {
                        message = this.fLeftIsLocal ? Utilities.getString(this.fBundle, "addedMessage") : Utilities.getString(this.fBundle, "deletedMessage");
                    }
                }
                catch (CoreException coreException) {
                    message = Utilities.getString(this.fBundle, "errorMessage");
                    Utilities.close(left);
                    Utilities.close(right);
                    break block20;
                }
                catch (IOException iOException) {
                    try {
                        message = Utilities.getString(this.fBundle, "errorMessage");
                    }
                    catch (Throwable throwable) {
                        Utilities.close(left);
                        Utilities.close(right);
                        throw throwable;
                    }
                    Utilities.close(left);
                    Utilities.close(right);
                    break block20;
                }
                Utilities.close(left);
                Utilities.close(right);
            }
            if (message != null) {
                this.fMessage.setText(message);
            }
            if (this.fTextButton != null) {
                this.fTextButton.setEnabled(true);
            }
            this.fComposite.layout();
        }
    }

    public Object getInput() {
        return this.fInput;
    }

    private InputStream getStream(ITypedElement input) throws CoreException {
        if (input instanceof IStreamContentAccessor) {
            return ((IStreamContentAccessor)((Object)input)).getContents();
        }
        return null;
    }
}

