/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.contentmergeviewer.IFlushable;
import org.eclipse.compare.internal.BinaryCompareViewer;
import org.eclipse.compare.internal.ChangePropertyAction;
import org.eclipse.compare.internal.CompareEditorInputNavigator;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.ICompareAsText;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.compare.internal.OutlineViewerCreator;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.services.IServiceLocator;

public abstract class CompareEditorInput
implements IEditorInput,
IPropertyChangeNotifier,
IRunnableWithProgress,
ICompareContainer {
    private static final boolean DEBUG = false;
    public static final String DIRTY_STATE = "DIRTY_STATE";
    public static final String PROP_TITLE = ICompareUIConstants.PROP_TITLE;
    public static final String PROP_TITLE_IMAGE = ICompareUIConstants.PROP_TITLE_IMAGE;
    public static final String PROP_SELECTED_EDITION = ICompareUIConstants.PROP_SELECTED_EDITION;
    private static final String COMPARE_EDITOR_IMAGE_NAME = "eview16/compare_view.gif";
    private static Image fgTitleImage;
    private Splitter fComposite;
    private CompareConfiguration fCompareConfiguration;
    private CompareViewerPane fStructureInputPane;
    private CompareViewerSwitchingPane fStructurePane1;
    private CompareViewerSwitchingPane fStructurePane2;
    private CompareViewerSwitchingPane fContentInputPane;
    private CompareViewerPane fFocusPane;
    private String fMessage;
    private Object fInput;
    private String fTitle;
    private ListenerList fListenerList = new ListenerList();
    private CompareNavigator fNavigator;
    private boolean fDirty = false;
    private ArrayList fDirtyViewers = new ArrayList();
    private IPropertyChangeListener fDirtyStateListener;
    boolean fStructureCompareOnSingleClick = true;
    private ICompareContainer fContainer;
    private boolean fContainerProvided;
    private String fHelpContextId;
    private InternalOutlineViewerCreator fOutlineView;
    private ICompareAsText fCompareAsText;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public CompareEditorInput(CompareConfiguration configuration) {
        this.fCompareConfiguration = configuration;
        Assert.isNotNull((Object)configuration);
        this.fDirtyStateListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getProperty();
                if (CompareEditorInput.DIRTY_STATE.equals(propertyName)) {
                    boolean changed = false;
                    Object newValue = e.getNewValue();
                    if (newValue instanceof Boolean) {
                        changed = (Boolean)newValue;
                    }
                    CompareEditorInput.this.setDirty(e.getSource(), changed);
                }
            }
        };
        IPreferenceStore ps = configuration.getPreferenceStore();
        if (ps != null) {
            this.fStructureCompareOnSingleClick = ps.getBoolean("org.eclipse.compare.OpenStructureCompare");
        }
        this.fContainer = configuration.getContainer();
        configuration.setContainer(this);
    }

    void internalCompareAsText(Object input) {
        HashSet<Object> set = (HashSet<Object>)this.getCompareConfiguration().getProperty("org.eclipse.compare.TextInputs");
        if (set == null) {
            set = new HashSet<Object>();
            this.getCompareConfiguration().setProperty("org.eclipse.compare.TextInputs", set);
        }
        set.add(input);
        if (this.fContentInputPane.getInput().equals(input)) {
            this.fContentInputPane.setInput(null);
            this.fContentInputPane.setInput(input);
        }
    }

    private boolean structureCompareOnSingleClick() {
        return this.fStructureCompareOnSingleClick;
    }

    private boolean isShowStructureInOutlineView() {
        Object object = this.getCompareConfiguration().getProperty("USE_OUTLINE_VIEW");
        return object instanceof Boolean && (Boolean)object != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(Class adapter) {
        Viewer v;
        Class<?> clazz;
        Object file;
        block47: {
            block46: {
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.compare.ICompareNavigator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz2.equals(adapter)) break block46;
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("org.eclipse.compare.CompareNavigator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz3.equals(adapter)) break block47;
            }
            return this.getNavigator();
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz4) {
            Class<?> clazz5 = class$4;
            if (clazz5 == null) {
                try {
                    clazz5 = class$4 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((file = (IFile)Utilities.getAdapter(this, clazz5)) != null) {
                return new IShowInSource((IFile)file){
                    private final /* synthetic */ IFile val$file;
                    {
                        this.val$file = iFile;
                    }

                    public ShowInContext getShowInContext() {
                        return new ShowInContext((Object)new FileEditorInput(this.val$file), (ISelection)StructuredSelection.EMPTY);
                    }
                };
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.compare.internal.OutlineViewerCreator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            file = this;
            synchronized (file) {
                if (this.fOutlineView == null) {
                    this.fOutlineView = new InternalOutlineViewerCreator();
                }
                return this.fOutlineView;
            }
        }
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.compare.internal.ICompareAsText");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz6) {
            if (this.fCompareAsText == null) {
                this.fCompareAsText = new CompareAsText();
            }
            return this.fCompareAsText;
        }
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.eclipse.jface.text.IFindReplaceTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz7 && this.fContentInputPane != null && (v = this.fContentInputPane.getViewer()) != null) {
            Class<?> clazz8 = class$6;
            if (clazz8 == null) {
                try {
                    clazz8 = class$6 = Class.forName("org.eclipse.jface.text.IFindReplaceTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return Utilities.getAdapter(v, clazz8);
        }
        return null;
    }

    public synchronized ICompareNavigator getNavigator() {
        if (this.fNavigator == null) {
            this.fNavigator = new CompareEditorInputNavigator(new Object[]{this.fStructureInputPane, this.fStructurePane1, this.fStructurePane2, this.fContentInputPane});
        }
        return this.fNavigator;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getToolTipText() {
        return this.getTitle();
    }

    public String getName() {
        return this.getTitle();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public boolean exists() {
        return false;
    }

    protected void setMessage(String message) {
        this.fMessage = message;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public String getTitle() {
        if (this.fTitle == null) {
            return Utilities.getString("CompareEditorInput.defaultTitle");
        }
        return this.fTitle;
    }

    public void setTitle(String title) {
        String oldTitle = this.fTitle;
        this.fTitle = title;
        Utilities.firePropertyChange(this.fListenerList, this, PROP_TITLE, oldTitle, title);
    }

    public Image getTitleImage() {
        if (fgTitleImage == null) {
            fgTitleImage = CompareUIPlugin.getImageDescriptor(COMPARE_EDITOR_IMAGE_NAME).createImage();
            CompareUI.disposeOnShutdown(fgTitleImage);
        }
        return fgTitleImage;
    }

    public CompareConfiguration getCompareConfiguration() {
        return this.fCompareConfiguration;
    }

    public void contributeToToolBar(ToolBarManager toolBarManager) {
        ResourceBundle bundle = CompareUI.getResourceBundle();
        ChangePropertyAction ignoreWhitespace = ChangePropertyAction.createIgnoreWhiteSpaceAction(bundle, this.getCompareConfiguration());
        toolBarManager.getControl().addDisposeListener((DisposeListener)ignoreWhitespace);
        ChangePropertyAction showPseudoConflicts = ChangePropertyAction.createShowPseudoConflictsAction(bundle, this.getCompareConfiguration());
        toolBarManager.getControl().addDisposeListener((DisposeListener)showPseudoConflicts);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)ignoreWhitespace);
        toolBarManager.add((IAction)showPseudoConflicts);
    }

    public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        this.fInput = this.prepareInput(monitor);
    }

    protected abstract Object prepareInput(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;

    public Object getCompareResult() {
        return this.fInput;
    }

    public Control createContents(Composite parent) {
        this.fComposite = new Splitter(parent, 512);
        this.fComposite.setData(this);
        Control outline = this.createOutlineContents((Composite)this.fComposite, 256);
        this.fContentInputPane = new CompareViewerSwitchingPane((Composite)this.fComposite, 0x800800){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                if (input instanceof ICompareInput) {
                    return CompareEditorInput.this.findContentViewer(oldViewer, (ICompareInput)input, (Composite)this);
                }
                return null;
            }
        };
        if (this.fFocusPane == null) {
            this.fFocusPane = this.fContentInputPane;
        }
        if (outline != null) {
            this.fComposite.setVisible(outline, false);
        }
        this.fComposite.setVisible((Control)this.fContentInputPane, true);
        if (this.fStructureInputPane != null) {
            this.fComposite.setWeights(new int[]{30, 70});
        }
        this.fComposite.layout();
        this.feedInput();
        this.fComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CompareEditorInput.this.handleDispose();
            }
        });
        if (this.fHelpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fComposite, this.fHelpContextId);
        }
        this.contentsCreated();
        return this.fComposite;
    }

    protected void handleDispose() {
        this.fContainerProvided = false;
        this.fContainer = null;
        this.fComposite = null;
        this.fStructureInputPane = null;
        this.fStructurePane1 = null;
        this.fStructurePane2 = null;
        this.fContentInputPane = null;
        this.fFocusPane = null;
        this.fNavigator = null;
        this.fCompareConfiguration.dispose();
    }

    protected void contentsCreated() {
    }

    public Control createOutlineContents(Composite parent, int direction) {
        Splitter h = new Splitter(parent, direction);
        this.fStructureInputPane = this.createStructureInputPane((Composite)h);
        if (this.hasChildren(this.getCompareResult())) {
            this.fFocusPane = this.fStructureInputPane;
        }
        this.fStructurePane1 = new CompareViewerSwitchingPane((Composite)h, 0x800800, true){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                if (input instanceof ICompareInput) {
                    return CompareEditorInput.this.findStructureViewer(oldViewer, (ICompareInput)input, (Composite)this);
                }
                return null;
            }
        };
        h.setVisible((Control)this.fStructurePane1, false);
        this.fStructurePane2 = new CompareViewerSwitchingPane((Composite)h, 0x800800, true){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                if (input instanceof ICompareInput) {
                    return CompareEditorInput.this.findStructureViewer(oldViewer, (ICompareInput)input, (Composite)this);
                }
                return null;
            }
        };
        h.setVisible((Control)this.fStructurePane2, false);
        this.fStructureInputPane.addOpenListener(new IOpenListener(){

            public void open(OpenEvent oe) {
                CompareEditorInput.this.feed1(oe.getSelection());
            }
        });
        this.fStructureInputPane.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ISelection s = e.getSelection();
                if (s == null || s.isEmpty()) {
                    CompareEditorInput.this.feed1(s);
                }
                if (CompareEditorInput.this.isEditionSelectionDialog()) {
                    CompareEditorInput.this.firePropertyChange(new PropertyChangeEvent((Object)this, PROP_SELECTED_EDITION, null, CompareEditorInput.this.getSelectedEdition()));
                }
            }
        });
        this.fStructureInputPane.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CompareEditorInput.this.feedDefault1(event.getSelection());
            }
        });
        this.fStructurePane1.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                CompareEditorInput.this.feed2(e.getSelection());
            }
        });
        this.fStructurePane2.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                CompareEditorInput.this.feed3(e.getSelection());
            }
        });
        return h;
    }

    protected CompareViewerPane createStructureInputPane(Composite parent) {
        return new CompareViewerSwitchingPane(parent, 0x800800, true){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                if (CompareEditorInput.this.hasChildren(input)) {
                    return CompareEditorInput.this.createDiffViewer((Composite)this);
                }
                if (input instanceof ICompareInput) {
                    return CompareEditorInput.this.findStructureViewer(oldViewer, (ICompareInput)input, (Composite)this);
                }
                return null;
            }
        };
    }

    boolean hasChildren(Object input) {
        if (input instanceof IDiffContainer) {
            IDiffContainer dn = (IDiffContainer)input;
            return dn.hasChildren();
        }
        return false;
    }

    private void feedInput() {
        if (this.fStructureInputPane != null && (this.fInput instanceof ICompareInput || this.isCustomStructureInputPane())) {
            if (this.hasChildren(this.fInput) || this.isCustomStructureInputPane()) {
                this.fStructureInputPane.setInput(this.fInput);
            } else if (!this.structureCompareOnSingleClick() || this.isShowStructureInOutlineView()) {
                this.internalSetContentPaneInput(this.fInput);
                if (this.hasUnusableContentViewer() || this.structureCompareOnSingleClick() && this.isShowStructureInOutlineView() && !this.hasOutlineViewer(this.fInput)) {
                    this.fStructureInputPane.setInput(this.fInput);
                }
            } else {
                this.fStructureInputPane.setInput(this.fInput);
            }
            ISelection sel = this.fStructureInputPane.getSelection();
            if (sel == null || sel.isEmpty()) {
                this.feed1(sel);
            }
        }
    }

    private boolean hasOutlineViewer(Object input) {
        OutlineViewerCreator creator;
        if (!this.isShowStructureInOutlineView()) {
            return false;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.compare.internal.OutlineViewerCreator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((creator = (OutlineViewerCreator)this.getAdapter(clazz)) != null) {
            return creator.hasViewerFor(input);
        }
        return false;
    }

    private boolean hasUnusableContentViewer() {
        return this.fContentInputPane.isEmpty() || this.fContentInputPane.getViewer() instanceof BinaryCompareViewer;
    }

    private boolean isCustomStructureInputPane() {
        return !(this.fStructureInputPane instanceof CompareViewerSwitchingPane);
    }

    private void feed1(final ISelection selection) {
        BusyIndicator.showWhile((Display)this.fComposite.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (selection == null || selection.isEmpty()) {
                    Object input = CompareEditorInput.this.fStructureInputPane.getInput();
                    if (input != null) {
                        CompareEditorInput.this.internalSetContentPaneInput(input);
                    }
                    CompareEditorInput.this.fStructurePane2.setInput(null);
                    CompareEditorInput.this.fStructurePane1.setInput(null);
                } else {
                    Object input = CompareEditorInput.getElement(selection);
                    CompareEditorInput.this.internalSetContentPaneInput(input);
                    if (CompareEditorInput.this.structureCompareOnSingleClick() || CompareEditorInput.this.hasUnusableContentViewer()) {
                        CompareEditorInput.this.fStructurePane1.setInput(input);
                    }
                    CompareEditorInput.this.fStructurePane2.setInput(null);
                    if (CompareEditorInput.this.fStructurePane1.getInput() != input) {
                        CompareEditorInput.this.fStructurePane1.setInput(null);
                    }
                }
            }
        });
    }

    private void feedDefault1(final ISelection selection) {
        BusyIndicator.showWhile((Display)this.fComposite.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (!selection.isEmpty()) {
                    CompareEditorInput.this.fStructurePane1.setInput(CompareEditorInput.getElement(selection));
                }
            }
        });
    }

    private void feed2(final ISelection selection) {
        BusyIndicator.showWhile((Display)this.fComposite.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (selection.isEmpty()) {
                    Object input = CompareEditorInput.this.fStructurePane1.getInput();
                    CompareEditorInput.this.internalSetContentPaneInput(input);
                    CompareEditorInput.this.fStructurePane2.setInput(null);
                } else {
                    Object input = CompareEditorInput.getElement(selection);
                    CompareEditorInput.this.internalSetContentPaneInput(input);
                    CompareEditorInput.this.fStructurePane2.setInput(input);
                }
            }
        });
    }

    private void feed3(final ISelection selection) {
        BusyIndicator.showWhile((Display)this.fComposite.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (selection.isEmpty()) {
                    CompareEditorInput.this.internalSetContentPaneInput(CompareEditorInput.this.fStructurePane2.getInput());
                } else {
                    CompareEditorInput.this.internalSetContentPaneInput(CompareEditorInput.getElement(selection));
                }
            }
        });
    }

    private void internalSetContentPaneInput(Object input) {
        Object oldInput = this.fContentInputPane.getInput();
        this.fContentInputPane.setInput(input);
        if (this.fOutlineView != null) {
            this.fOutlineView.fireInputChange(oldInput, input);
        }
    }

    private static Object getElement(ISelection selection) {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            return ss.getFirstElement();
        }
        return null;
    }

    public void setFocus() {
        if (this.fFocusPane != null) {
            this.fFocusPane.setFocus();
        } else if (this.fComposite != null) {
            this.fComposite.setFocus();
        }
    }

    public Viewer createDiffViewer(Composite parent) {
        return new DiffTreeViewer(parent, this.fCompareConfiguration);
    }

    public Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        return CompareUI.findStructureViewer(oldViewer, input, parent, this.fCompareConfiguration);
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        boolean isNewViewer;
        Viewer newViewer = CompareUI.findContentViewer(oldViewer, input, parent, this.fCompareConfiguration);
        boolean bl = isNewViewer = newViewer != oldViewer;
        if (isNewViewer && newViewer instanceof IPropertyChangeNotifier) {
            final IPropertyChangeNotifier dsp = (IPropertyChangeNotifier)newViewer;
            dsp.addPropertyChangeListener(this.fDirtyStateListener);
            Control c = newViewer.getControl();
            c.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    dsp.removePropertyChangeListener(CompareEditorInput.this.fDirtyStateListener);
                }
            });
        }
        return newViewer;
    }

    public boolean isSaveNeeded() {
        return this.fDirty || this.fDirtyViewers.size() > 0;
    }

    public boolean isDirty() {
        return this.isSaveNeeded();
    }

    public void setDirty(boolean dirty) {
        boolean oldDirty = this.fDirty || this.fDirtyViewers.size() > 0;
        this.fDirty = dirty;
        if (!this.fDirty) {
            this.fDirtyViewers.clear();
        }
        if (oldDirty != dirty) {
            Utilities.firePropertyChange(this.fListenerList, this, DIRTY_STATE, new Boolean(oldDirty), new Boolean(dirty));
        }
    }

    private void setDirty(Object source, boolean dirty) {
        boolean newDirty;
        boolean oldDirty;
        Assert.isNotNull((Object)source);
        boolean bl = oldDirty = this.fDirty || this.fDirtyViewers.size() > 0;
        if (dirty) {
            this.fDirtyViewers.add(source);
        } else {
            this.fDirtyViewers.remove(source);
        }
        boolean bl2 = newDirty = this.fDirty || this.fDirtyViewers.size() > 0;
        if (oldDirty != newDirty) {
            Utilities.firePropertyChange(this.fListenerList, this, DIRTY_STATE, new Boolean(oldDirty), new Boolean(newDirty));
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.fListenerList.add((Object)listener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fListenerList != null) {
            this.fListenerList.remove((Object)listener);
            if (this.fListenerList.isEmpty()) {
                this.fListenerList = null;
            }
        }
    }

    public void save(IProgressMonitor pm) {
    }

    public void saveChanges(IProgressMonitor monitor) throws CoreException {
        this.flushViewers(monitor);
        this.save(monitor);
    }

    protected void flushViewers(IProgressMonitor monitor) {
        CompareEditorInput.flushViewer(this.fStructureInputPane, monitor);
        CompareEditorInput.flushViewer(this.fStructurePane1, monitor);
        CompareEditorInput.flushViewer(this.fStructurePane2, monitor);
        CompareEditorInput.flushViewer(this.fContentInputPane, monitor);
    }

    private static void flushViewer(CompareViewerPane pane, IProgressMonitor pm) {
        if (pane != null) {
            IFlushable flushable;
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("org.eclipse.compare.contentmergeviewer.IFlushable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((flushable = (IFlushable)Utilities.getAdapter((Object)pane, clazz)) != null) {
                flushable.flush(pm);
            }
        }
    }

    public void addCompareInputChangeListener(ICompareInput input, ICompareInputChangeListener listener) {
        if (this.fContainer == null) {
            input.addCompareInputChangeListener(listener);
        } else {
            this.fContainer.addCompareInputChangeListener(input, listener);
        }
    }

    public void removeCompareInputChangeListener(ICompareInput input, ICompareInputChangeListener listener) {
        if (this.fContainer == null) {
            input.removeCompareInputChangeListener(listener);
        } else {
            this.fContainer.removeCompareInputChangeListener(input, listener);
        }
    }

    public void registerContextMenu(MenuManager menu, ISelectionProvider selectionProvider) {
        if (this.fContainer != null) {
            this.fContainer.registerContextMenu(menu, selectionProvider);
        }
    }

    public void setStatusMessage(String message) {
        if (!this.fContainerProvided) {
            IStatusLineManager slm;
            IActionBars actionBars = this.getActionBars();
            if (actionBars != null && (slm = actionBars.getStatusLineManager()) != null) {
                slm.setMessage(message);
            }
        } else if (this.fContainer != null) {
            this.fContainer.setStatusMessage(message);
        }
    }

    public IActionBars getActionBars() {
        if (this.fContainer != null) {
            IActionBars actionBars = this.fContainer.getActionBars();
            if (actionBars == null && !this.fContainerProvided) {
                return Utilities.findActionBars((Control)this.fComposite);
            }
            return actionBars;
        }
        return null;
    }

    public IServiceLocator getServiceLocator() {
        IServiceLocator serviceLocator = this.fContainer.getServiceLocator();
        if (serviceLocator == null && !this.fContainerProvided) {
            return Utilities.findSite((Control)this.fComposite);
        }
        return serviceLocator;
    }

    public IWorkbenchPart getWorkbenchPart() {
        if (this.fContainer != null) {
            return this.fContainer.getWorkbenchPart();
        }
        return null;
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (this.fContainer != null) {
            this.fContainer.run(fork, cancelable, runnable);
        }
    }

    public void runAsynchronously(IRunnableWithProgress runnable) {
        if (this.fContainer != null) {
            this.fContainer.runAsynchronously(runnable);
        }
    }

    public void setContainer(ICompareContainer container) {
        Assert.isNotNull((Object)container);
        this.fContainer = container;
        this.fContainerProvided = true;
    }

    public final ICompareContainer getContainer() {
        return this.fContainer;
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        Utilities.firePropertyChange(this.fListenerList, event);
    }

    public boolean canRunAsJob() {
        return false;
    }

    public boolean belongsTo(Object family) {
        return family == this;
    }

    public boolean isEditionSelectionDialog() {
        return false;
    }

    public String getOKButtonLabel() {
        if (this.isEditable()) {
            return CompareMessages.CompareDialog_commit_button;
        }
        if (this.isEditionSelectionDialog()) {
            return CompareMessages.CompareEditorInput_0;
        }
        return IDialogConstants.OK_LABEL;
    }

    public String getCancelButtonLabel() {
        return IDialogConstants.CANCEL_LABEL;
    }

    private boolean isEditable() {
        return this.getCompareConfiguration().isLeftEditable() || this.getCompareConfiguration().isRightEditable();
    }

    public boolean okPressed() {
        return !this.isEditable() || this.saveChanges();
    }

    public void cancelPressed() {
    }

    private boolean saveChanges() {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CompareEditorInput.this.saveChanges(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            return true;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InvocationTargetException x) {
            ErrorDialog.openError((Shell)this.fComposite.getShell(), (String)CompareMessages.CompareDialog_error_title, null, (IStatus)new Status(4, "org.eclipse.compare", 0, NLS.bind((String)CompareMessages.CompareDialog_error_message, (Object)x.getTargetException().getMessage()), x.getTargetException()));
        }
        return false;
    }

    public Object getSelectedEdition() {
        IStructuredSelection ss;
        ISelection selection;
        if (this.fStructureInputPane != null && (selection = this.fStructureInputPane.getSelection()) instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            return ss.getFirstElement();
        }
        return null;
    }

    public void setHelpContextId(String helpContextId) {
        this.fHelpContextId = helpContextId;
    }

    private class CompareAsText
    implements ICompareAsText {
        private CompareAsText() {
        }

        public void compareAsText(Object input) {
            CompareEditorInput.this.internalCompareAsText(input);
        }
    }

    private class InternalOutlineViewerCreator
    extends OutlineViewerCreator {
        private InternalOutlineViewerCreator() {
        }

        private OutlineViewerCreator getWrappedCreator() {
            Viewer v;
            if (CompareEditorInput.this.fContentInputPane != null && (v = CompareEditorInput.this.fContentInputPane.getViewer()) != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.compare.internal.OutlineViewerCreator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return (OutlineViewerCreator)Utilities.getAdapter(v, clazz);
            }
            return null;
        }

        public Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent, CompareConfiguration configuration) {
            OutlineViewerCreator creator = this.getWrappedCreator();
            if (creator != null) {
                return creator.findStructureViewer(oldViewer, input, parent, configuration);
            }
            return null;
        }

        public boolean hasViewerFor(Object input) {
            OutlineViewerCreator creator = this.getWrappedCreator();
            return creator != null;
        }

        public Object getInput() {
            OutlineViewerCreator creator = this.getWrappedCreator();
            if (creator != null) {
                return creator.getInput();
            }
            return null;
        }
    }
}

