/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

public class GreyBandsImage
extends BufferedImage {
    private int m_height;
    private int m_width;

    public GreyBandsImage() {
        super(100, 100, 2);
        this.generateImage();
        this.m_height = 100;
        this.m_width = 100;
    }

    private void generateImage() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        WritableRaster writableRaster = this.getRaster();
        ColorModel colorModel = this.getColorModel();
        int n3 = 5;
        int n4 = n / n3;
        int n5 = 255 / n4;
        for (int i = 0; i < n4; ++i) {
            Color color = new Color(i * n5, i * n5, i * n5);
            int n6 = color.getRGB();
            Object object = colorModel.getDataElements(n6, null);
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    writableRaster.setDataElements(j, i * 5 + k, object);
                }
            }
        }
    }

    public int[] getRawData() {
        WritableRaster writableRaster = this.getRaster();
        Rectangle rectangle = writableRaster.getBounds();
        int[] nArray = new int[this.m_height * this.m_width * 4];
        nArray = writableRaster.getPixels(0, 0, 100, 100, nArray);
        return nArray;
    }

    public int getH() {
        return this.m_height;
    }

    public int getW() {
        return this.m_width;
    }
}

