/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.cache;

import java.io.File;
import java.net.URL;

public class DiskCacheEntry {
    private char _type;
    private URL _location;
    private String _versionId;
    private long _timestamp;
    private File _file;
    private File _directory;
    private File _mappedBitmap;
    private File _muffinTag;

    public DiskCacheEntry() {
        this('\u0000', null, null, null, 0L);
    }

    public DiskCacheEntry(char c, URL uRL, String string, File file, long l) {
        this(c, uRL, string, file, l, null, null, null);
    }

    public DiskCacheEntry(char c, URL uRL, String string, File file, long l, File file2, File file3) {
        this(c, uRL, string, file, l, file2, file3, null);
    }

    public DiskCacheEntry(char c, URL uRL, String string, File file, long l, File file2, File file3, File file4) {
        this._type = c;
        this._location = uRL;
        this._versionId = string;
        this._timestamp = l;
        this._file = file;
        this._directory = file2;
        this._mappedBitmap = file3;
        this._muffinTag = file4;
    }

    public char getType() {
        return this._type;
    }

    public void setType(char c) {
        this._type = c;
    }

    public URL getLocation() {
        return this._location;
    }

    public void setLocataion(URL uRL) {
        this._location = uRL;
    }

    public long getTimeStamp() {
        return this._timestamp;
    }

    public void setTimeStamp(long l) {
        this._timestamp = l;
    }

    public File getMuffinTagFile() {
        return this._muffinTag;
    }

    public void setMuffinTagFile(File file) {
        this._muffinTag = file;
    }

    public String getVersionId() {
        return this._versionId;
    }

    public void setVersionId(String string) {
        this._versionId = string;
    }

    public File getFile() {
        return this._file;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public File getDirectory() {
        return this._directory;
    }

    public void setDirectory(File file) {
        this._directory = file;
    }

    public File getMappedBitmap() {
        return this._mappedBitmap;
    }

    public void setMappedBitmap(File file) {
        this._mappedBitmap = file;
    }

    public long getLastAccess() {
        return this._file == null ? 0L : this._file.lastModified();
    }

    public void setLastAccess(long l) {
        if (this._file != null) {
            this._file.setLastModified(l);
        }
    }

    public boolean isEmpty() {
        return this._location == null;
    }

    public long getSize() {
        if (this._directory != null && this._directory.isDirectory()) {
            long l = 0L;
            File[] fileArray = this._directory.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                l += fileArray[i].length();
            }
            return l;
        }
        return this._file.length();
    }

    public boolean newerThan(DiskCacheEntry diskCacheEntry) {
        if (diskCacheEntry == null || this.getVersionId() != null) {
            return true;
        }
        return this.getTimeStamp() > diskCacheEntry.getTimeStamp();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "DisckCacheEntry[<empty>]";
        }
        return "DisckCacheEntry[" + this._type + ";" + this._location + ";" + this._versionId + ";" + this._timestamp + ";" + this._file + ";" + this._directory + "]";
    }
}

