/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers;

import java.net.URL;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerItem;

public abstract class MarkerField {
    private IConfigurationElement configurationElement;
    private ResourceManager imageManager;

    public Image annotateImage(MarkerItem item, Image image) {
        IMarker marker;
        ImageDescriptor[] descriptors = new ImageDescriptor[5];
        if (item.getMarker() != null && (marker = item.getMarker()) != null) {
            String contextId = IDE.getMarkerHelpRegistry().getHelp(marker);
            if (contextId != null) {
                if (image == null) {
                    image = JFaceResources.getImage((String)"dialog_help_image");
                } else {
                    descriptors[1] = IDEWorkbenchPlugin.getIDEImageDescriptor("markers/help_small.gif");
                }
            }
            if (IDE.getMarkerHelpRegistry().hasResolutions(marker)) {
                if (image == null) {
                    image = this.getImageManager().createImage(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ELCL_QUICK_FIX_ENABLED"));
                } else {
                    descriptors[3] = IDEWorkbenchPlugin.getIDEImageDescriptor("markers/contassist_ovr.gif");
                }
            }
            if (descriptors[1] != null || descriptors[3] != null) {
                image = this.getImageManager().createImage((ImageDescriptor)new DecorationOverlayIcon(image, descriptors));
            }
        }
        return image;
    }

    public int compare(MarkerItem item1, MarkerItem item2) {
        return this.getValue(item1).compareTo(this.getValue(item2));
    }

    public Image getColumnHeaderImage() {
        String path = this.configurationElement.getAttribute("icon");
        if (path == null) {
            return null;
        }
        URL url = BundleUtility.find((String)this.configurationElement.getContributor().getName(), (String)path);
        if (url == null) {
            return null;
        }
        return this.getImageManager().createImageWithDefault(ImageDescriptor.createFromURL((URL)url));
    }

    public String getColumnHeaderText() {
        return this.configurationElement.getAttribute("name");
    }

    public String getColumnTooltipText() {
        return this.getColumnHeaderText();
    }

    public final IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public int getDefaultColumnWidth(Control control) {
        return 15 * MarkerSupportInternalUtilities.getFontWidth(control);
    }

    public EditingSupport getEditingSupport(ColumnViewer viewer) {
        return null;
    }

    protected ResourceManager getImageManager() {
        if (this.imageManager == null) {
            return IDEWorkbenchPlugin.getDefault().getResourceManager();
        }
        return this.imageManager;
    }

    public abstract String getValue(MarkerItem var1);

    public final void setConfigurationElement(IConfigurationElement element) {
        this.configurationElement = element;
    }

    public final void setImageManager(ResourceManager manager) {
        this.imageManager = manager;
    }

    public void update(ViewerCell cell) {
        cell.setText(this.getValue((MarkerItem)cell.getElement()));
    }
}

