/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.CreateLinkedResourceGroup;
import org.eclipse.ui.internal.ide.misc.ResourceAndContainerGroup;

public class WizardNewFileCreationPage
extends WizardPage
implements Listener {
    private static final int SIZING_CONTAINER_GROUP_HEIGHT = 250;
    private IStructuredSelection currentSelection;
    private IFile newFile;
    private URI linkTargetPath;
    private ResourceAndContainerGroup resourceGroup;
    private Button advancedButton;
    private CreateLinkedResourceGroup linkedResourceGroup;
    private Composite linkedResourceParent;
    private Composite linkedResourceComposite;
    private String initialFileName;
    private String initialFileExtension;
    private IPath initialContainerFullPath;
    private boolean initialAllowExistingResources = false;
    private int linkedResourceGroupHeight = -1;
    private boolean firstLinkCheck = true;
    static /* synthetic */ Class class$0;

    public WizardNewFileCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.setPageComplete(false);
        this.currentSelection = selection;
    }

    protected void createAdvancedControls(Composite parent) {
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        if (!preferences.getBoolean("description.disableLinking")) {
            this.linkedResourceParent = new Composite(parent, 0);
            this.linkedResourceParent.setFont(parent.getFont());
            this.linkedResourceParent.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.linkedResourceParent.setLayout((Layout)layout);
            this.advancedButton = new Button(this.linkedResourceParent, 8);
            this.advancedButton.setFont(this.linkedResourceParent.getFont());
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
            GridData data = this.setButtonLayoutData(this.advancedButton);
            data.horizontalAlignment = 1;
            this.advancedButton.setLayoutData((Object)data);
            this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WizardNewFileCreationPage.this.handleAdvancedButtonSelect();
                }
            });
        }
        this.linkedResourceGroup = new CreateLinkedResourceGroup(1, new Listener(){

            public void handleEvent(Event e) {
                WizardNewFileCreationPage.this.setPageComplete(WizardNewFileCreationPage.this.validatePage());
                WizardNewFileCreationPage.this.firstLinkCheck = false;
            }
        }, new CreateLinkedResourceGroup.IStringValue(){

            public void setValue(String string) {
                WizardNewFileCreationPage.this.resourceGroup.setResource(string);
            }

            public String getValue() {
                return WizardNewFileCreationPage.this.resourceGroup.getResource();
            }
        });
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(parent.getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)topLevel, "org.eclipse.ui.ide.new_file_wizard_page_context");
        this.resourceGroup = new ResourceAndContainerGroup(topLevel, this, this.getNewFileLabel(), IDEWorkbenchMessages.WizardNewFileCreationPage_file, false, 250);
        this.resourceGroup.setAllowExistingResources(this.initialAllowExistingResources);
        this.initialPopulateContainerNameField();
        this.createAdvancedControls(topLevel);
        if (this.initialFileName != null) {
            this.resourceGroup.setResource(this.initialFileName);
        }
        if (this.initialFileExtension != null) {
            this.resourceGroup.setResourceExtension(this.initialFileExtension);
        }
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topLevel);
    }

    protected void createFile(IFile fileHandle, InputStream contents, IProgressMonitor monitor) throws CoreException {
        if (contents == null) {
            contents = new ByteArrayInputStream(new byte[0]);
        }
        try {
            if (this.linkTargetPath != null) {
                fileHandle.createLink(this.linkTargetPath, 16, monitor);
            } else {
                IPath path = fileHandle.getFullPath();
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                int numSegments = path.segmentCount();
                if (numSegments > 2 && !root.getFolder(path.removeLastSegments(1)).exists()) {
                    int i = numSegments - 2;
                    while (i > 0) {
                        IFolder folder = root.getFolder(path.removeLastSegments(i));
                        if (!folder.exists()) {
                            folder.create(false, true, monitor);
                        }
                        --i;
                    }
                }
                fileHandle.create(contents, false, monitor);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IFile createFileHandle(IPath filePath) {
        return IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getFile(filePath);
    }

    protected void createLinkTarget() {
        this.linkTargetPath = this.linkedResourceGroup.getLinkTargetURI();
    }

    public IFile createNewFile() {
        if (this.newFile != null) {
            return this.newFile;
        }
        IPath containerPath = this.resourceGroup.getContainerFullPath();
        IPath newFilePath = containerPath.append(this.resourceGroup.getResource());
        final IFile newFileHandle = this.createFileHandle(newFilePath);
        final InputStream initialContents = this.getInitialContents();
        this.createLinkTarget();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                CreateFileOperation op = new CreateFileOperation(newFileHandle, WizardNewFileCreationPage.this.linkTargetPath, initialContents, IDEWorkbenchMessages.WizardNewFileCreationPage_title);
                try {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, WorkspaceUndoUtil.getUIInfoAdapter(WizardNewFileCreationPage.this.getShell()));
                }
                catch (ExecutionException e) {
                    WizardNewFileCreationPage.this.getContainer().getShell().getDisplay().syncExec(new Runnable(this, e){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ ExecutionException val$e;
                        {
                            this.this$1 = var1_1;
                            this.val$e = executionException;
                        }

                        public void run() {
                            if (this.val$e.getCause() instanceof CoreException) {
                                ErrorDialog.openError((Shell)WizardNewFileCreationPage.access$3(4.access$0(this.this$1)).getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_errorTitle, null, (IStatus)((CoreException)this.val$e.getCause()).getStatus());
                            } else {
                                IDEWorkbenchPlugin.log(this.getClass(), "createNewFile()", this.val$e.getCause());
                                MessageDialog.openError((Shell)WizardNewFileCreationPage.access$3(4.access$0(this.this$1)).getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorMessage, (Object)this.val$e.getCause().getMessage()));
                            }
                        }
                    });
                }
            }

            static /* synthetic */ WizardNewFileCreationPage access$0(4 var0) {
                return var0.WizardNewFileCreationPage.this;
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), "createNewFile()", e.getTargetException());
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorMessage, (Object)e.getTargetException().getMessage()));
            return null;
        }
        this.newFile = newFileHandle;
        return this.newFile;
    }

    protected ISchedulingRule createRule(IResource resource) {
        IContainer parent = resource.getParent();
        while (parent != null) {
            if (parent.exists()) {
                return resource.getWorkspace().getRuleFactory().createRule(resource);
            }
            resource = parent;
            parent = parent.getParent();
        }
        return resource.getWorkspace().getRoot();
    }

    public IPath getContainerFullPath() {
        return this.resourceGroup.getContainerFullPath();
    }

    public String getFileName() {
        if (this.resourceGroup == null) {
            return this.initialFileName;
        }
        return this.resourceGroup.getResource();
    }

    public String getFileExtension() {
        if (this.resourceGroup == null) {
            return this.initialFileExtension;
        }
        return this.resourceGroup.getResourceExtension();
    }

    protected InputStream getInitialContents() {
        return null;
    }

    protected String getNewFileLabel() {
        return IDEWorkbenchMessages.WizardNewFileCreationPage_fileLabel;
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = (Composite)this.getControl();
        if (this.linkedResourceComposite != null) {
            this.linkedResourceComposite.dispose();
            this.linkedResourceComposite = null;
            composite.layout();
            shell.setSize(shellSize.x, shellSize.y - this.linkedResourceGroupHeight);
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
        } else {
            this.linkedResourceComposite = this.linkedResourceGroup.createContents(this.linkedResourceParent);
            if (this.linkedResourceGroupHeight == -1) {
                Point groupSize = this.linkedResourceComposite.computeSize(-1, -1, true);
                this.linkedResourceGroupHeight = groupSize.y;
            }
            shell.setSize(shellSize.x, shellSize.y + this.linkedResourceGroupHeight);
            composite.layout();
            this.advancedButton.setText(IDEWorkbenchMessages.hideAdvanced);
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    protected void initialPopulateContainerNameField() {
        if (this.initialContainerFullPath != null) {
            this.resourceGroup.setContainerFullPath(this.initialContainerFullPath);
        } else {
            Iterator it = this.currentSelection.iterator();
            if (it.hasNext()) {
                Object object = it.next();
                IResource selectedResource = null;
                if (object instanceof IResource) {
                    selectedResource = (IResource)object;
                } else if (object instanceof IAdaptable) {
                    IAdaptable iAdaptable = (IAdaptable)object;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    selectedResource = (IResource)iAdaptable.getAdapter((Class)clazz);
                }
                if (selectedResource != null) {
                    if (selectedResource.getType() == 1) {
                        selectedResource = selectedResource.getParent();
                    }
                    if (selectedResource.isAccessible()) {
                        this.resourceGroup.setContainerFullPath(selectedResource.getFullPath());
                    }
                }
            }
        }
    }

    public void setAllowExistingResources(boolean value) {
        if (this.resourceGroup == null) {
            this.initialAllowExistingResources = value;
        } else {
            this.resourceGroup.setAllowExistingResources(value);
        }
    }

    public void setContainerFullPath(IPath path) {
        if (this.resourceGroup == null) {
            this.initialContainerFullPath = path;
        } else {
            this.resourceGroup.setContainerFullPath(path);
        }
    }

    public void setFileName(String value) {
        if (this.resourceGroup == null) {
            this.initialFileName = value;
        } else {
            this.resourceGroup.setResource(value);
        }
    }

    public void setFileExtension(String value) {
        if (this.resourceGroup == null) {
            this.initialFileExtension = value;
        } else {
            this.resourceGroup.setResourceExtension(value);
        }
    }

    protected IStatus validateLinkedResource() {
        IPath containerPath = this.resourceGroup.getContainerFullPath();
        IPath newFilePath = containerPath.append(this.resourceGroup.getResource());
        IFile newFileHandle = this.createFileHandle(newFilePath);
        IStatus status = this.linkedResourceGroup.validateLinkLocation((IResource)newFileHandle);
        if (status.getSeverity() == 4) {
            if (this.firstLinkCheck) {
                this.setMessage(status.getMessage());
            } else {
                this.setErrorMessage(status.getMessage());
            }
        } else if (status.getSeverity() == 2) {
            this.setMessage(status.getMessage(), 2);
            this.setErrorMessage(null);
        }
        return status;
    }

    protected boolean validatePage() {
        boolean valid = true;
        if (!this.resourceGroup.areAllValuesValid()) {
            if (this.resourceGroup.getProblemType() == 1 || this.resourceGroup.getProblemType() == 5) {
                this.setMessage(this.resourceGroup.getProblemMessage());
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.resourceGroup.getProblemMessage());
            }
            valid = false;
        }
        String resourceName = this.resourceGroup.getResource();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validateName(resourceName, 1);
        if (!result.isOK()) {
            this.setErrorMessage(result.getMessage());
            return false;
        }
        IStatus linkedResourceStatus = null;
        if (valid && (linkedResourceStatus = this.validateLinkedResource()).getSeverity() == 4) {
            valid = false;
        }
        if (valid && (linkedResourceStatus == null || linkedResourceStatus.isOK())) {
            this.setMessage(null);
            this.setErrorMessage(null);
            if (this.resourceGroup.getAllowExistingResources()) {
                String problemMessage = NLS.bind((String)IDEWorkbenchMessages.ResourceGroup_nameExists, (Object)this.getFileName());
                IPath resourcePath = this.getContainerFullPath().append(this.getFileName());
                if (workspace.getRoot().getFolder(resourcePath).exists()) {
                    this.setErrorMessage(problemMessage);
                    valid = false;
                }
                if (workspace.getRoot().getFile(resourcePath).exists()) {
                    this.setMessage(problemMessage, 2);
                }
            }
        }
        return valid;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.resourceGroup.setFocus();
        }
    }
}

