/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.remote;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.remote.PreferenceFileHandler;

public class RemoteHelp {
    private static final String PROTOCOL_HTTP = "http";
    private static ListenerList listeners;
    private static Throwable error;

    public static void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        if (listeners == null) {
            listeners = new ListenerList();
        }
        listeners.add((Object)listener);
    }

    public static void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        if (listeners != null) {
            listeners.remove((Object)listener);
        }
    }

    public static void notifyPreferenceChange() {
        if (listeners != null) {
            Object[] array = listeners.getListeners();
            int i = 0;
            while (i < array.length) {
                IEclipsePreferences.IPreferenceChangeListener listener = (IEclipsePreferences.IPreferenceChangeListener)array[i];
                listener.preferenceChange(null);
                ++i;
            }
        }
    }

    public static URL getURL(int ic, String pathSuffix) throws MalformedURLException {
        int port;
        PreferenceFileHandler handler = new PreferenceFileHandler();
        String host = handler.getHostEntries()[ic];
        String path = String.valueOf(handler.getPathEntries()[ic]) + pathSuffix;
        try {
            port = Integer.parseInt(handler.getPortEntries()[ic]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedURLException();
        }
        return new URL(PROTOCOL_HTTP, host, port, path);
    }

    public static boolean isAllowed() {
        return BaseHelpSystem.getMode() != 1;
    }

    public static boolean isEnabled() {
        if (RemoteHelp.isAllowed()) {
            Preferences prefs = HelpBasePlugin.getDefault().getPluginPreferences();
            return prefs.getBoolean("remoteHelpOn");
        }
        return false;
    }

    public static void clearError() {
        error = null;
    }

    public static Throwable getError() {
        return error;
    }

    public static void setError(Throwable t) {
        error = t;
    }
}

