/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.variablesview;

import com.rsi.idldt.debug.internal.model.IDLVariable;
import com.rsi.idldt.debug.internal.model.IRenameVariable;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.variablesview.IDLVariablesView;
import java.util.Iterator;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionProviderAction;

public class RenameVariableAction
extends SelectionProviderAction {
    protected IDLVariable fVariable;
    private IDLVariablesView fView;
    private boolean fEditing = false;

    public RenameVariableAction(IDLVariablesView view) {
        super((ISelectionProvider)view.getViewer(), Messages.IDLVariableView_RenameVariableMenuText);
        this.setDescription(Messages.IDLVariableView_RenameVariableToolTip);
        this.setImageDescriptor(null);
        this.setHoverImageDescriptor(null);
        this.setDisabledImageDescriptor(null);
        this.fView = view;
    }

    protected void doActionPerformed(IDLVariable variable) {
        if (this.fEditing) {
            return;
        }
        this.fEditing = true;
        this.fVariable = variable;
        this.performEdit();
        this.fEditing = false;
    }

    private boolean performEdit() {
        TreeModelViewer v = (TreeModelViewer)this.fView.getViewer();
        this.fVariable.setRenaming(true);
        v.editElement((Object)this.fVariable, 0);
        this.fVariable.setRenaming(false);
        return true;
    }

    protected void update(IStructuredSelection sel) {
        Object object;
        Iterator iter = sel.iterator();
        if (iter.hasNext() && (object = iter.next()) instanceof IRenameVariable) {
            IRenameVariable varMod = (IRenameVariable)object;
            if (!varMod.supportsRename()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(!iter.hasNext());
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        Iterator iterator = this.getStructuredSelection().iterator();
        this.doActionPerformed((IDLVariable)iterator.next());
    }

    public void selectionChanged(IStructuredSelection sel) {
        this.update(sel);
    }
}

