/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.variablesview;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.debug.internal.model.IDLDebugTarget;
import com.rsi.idldt.debug.internal.model.IDLStackFrame;
import com.rsi.idldt.debug.internal.model.IDLThread;
import com.rsi.idldt.variablesview.DeleteVariableAction;
import com.rsi.idldt.variablesview.IDLVariableSelectionDragAdapter;
import com.rsi.idldt.variablesview.RenameVariableAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.variables.AvailableLogicalStructuresAction;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.internal.ui.views.variables.details.AvailableDetailPanesAction;
import org.eclipse.debug.internal.ui.views.variables.details.IDetailPaneContainer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.SelectionProviderAction;

public class IDLVariablesView
extends VariablesView {
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.scheduleJob();
        Control c = this.getViewer().getControl();
        DragSource ds = (DragSource)c.getData("DragSource");
        if (ds != null) {
            ds.setDragSourceEffect(new DragSourceEffect(c){

                public void dragStart(DragSourceEvent event) {
                    event.image = null;
                }
            });
        }
        this.getAction("Remove_ActionId").setEnabled(false);
        this.getAction(ActionFactory.RENAME.getId()).setEnabled(false);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        viewMenu.add(this.getAction("Remove_ActionId"));
        viewMenu.add(this.getAction(ActionFactory.RENAME.getId()));
        viewMenu.add(this.getAction("ChangeVariableValue"));
    }

    protected void setViewerInput(Object context) {
        Object current;
        if (this.getViewer() == null) {
            return;
        }
        Object newContext = context;
        if (newContext == null || !(newContext instanceof IDLStackFrame)) {
            newContext = this.getIDLStackFrame();
        }
        if ((current = this.getViewer().getInput()) == null && newContext == null) {
            return;
        }
        if (current != null && current.equals(newContext)) {
            return;
        }
        this.showViewer();
        this.getViewer().setInput(newContext);
    }

    IDLStackFrame getIDLStackFrame() {
        IDLStackFrame frame;
        IDLThread thread;
        IDLDebugTarget target;
        IIDLProcessProxy proxy = IDLProcessManager.getActiveProcess();
        if (proxy != null && (target = proxy.getDebugTarget()) != null && (thread = target.getThread()) != null && (frame = thread.getMainIDLStackFrame()) != null) {
            return frame;
        }
        return null;
    }

    void scheduleJob() {
        IDLVariablesViewStartupJob job = new IDLVariablesViewStartupJob();
        job.setSystem(true);
        job.setPriority(20);
        job.schedule();
    }

    protected void initDragAndDrop(TreeModelViewer viewer) {
        viewer.addDragSupport(1, new Transfer[]{TextTransfer.getInstance()}, (DragSourceListener)new IDLVariableSelectionDragAdapter((Viewer)viewer));
    }

    protected void createActions() {
        super.createActions();
        SelectionProviderAction action = new DeleteVariableAction(this);
        this.setAction("Remove_ActionId", (IAction)action);
        action = new RenameVariableAction(this);
        this.setAction(ActionFactory.RENAME.getId(), (IAction)action);
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyVariableGroup"));
        menu.add((IContributionItem)new Separator("variableGroup"));
        menu.add(this.getAction("Remove_ActionId"));
        menu.add(this.getAction(ActionFactory.RENAME.getId()));
        menu.add(this.getAction("ChangeVariableValue"));
        menu.add(this.getAction(VARIABLES_FIND_ELEMENT_ACTION));
        menu.add((IContributionItem)new Separator());
        AvailableLogicalStructuresAction action = new AvailableLogicalStructuresAction((VariablesView)this);
        if (action.isEnabled()) {
            menu.add((IAction)action);
        }
        action = new AvailableDetailPanesAction((IDetailPaneContainer)this);
        if (this.isDetailPaneVisible() && action.isEnabled()) {
            menu.add((IAction)action);
        }
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("emptyNavigationGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void configureToolBar(IToolBarManager tbm) {
        super.configureToolBar(tbm);
        tbm.add(this.getAction("Remove_ActionId"));
    }

    private class IDLVariablesViewStartupJob
    extends Job {
        public IDLVariablesViewStartupJob() {
            super("Waiting for IDL main stack frame to become available");
        }

        protected IStatus run(IProgressMonitor monitor) {
            while (IDLVariablesView.this.getIDLStackFrame() == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    IDLVariablesView.this.scheduleJob();
                    return Status.OK_STATUS;
                }
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IDLVariablesView.this.setViewerInput(null);
                }
            });
            return Status.OK_STATUS;
        }
    }
}

