/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.variablesview;

import com.rsi.idldt.debug.internal.model.IDLVariable;
import com.rsi.idldt.ui.TreeUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class IDLVariableSelectionDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private Viewer fViewer;
    private ISelection m_selection;

    public IDLVariableSelectionDragAdapter(Viewer viewer) {
        Assert.isNotNull((Object)viewer);
        this.fViewer = viewer;
    }

    public Transfer getTransfer() {
        return TextTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.fViewer.getSelection();
        if (selection instanceof TreeSelection) {
            TreeSelection ts = (TreeSelection)selection;
            block0: for (Object obj : ts) {
                if (!(obj instanceof IDLVariable)) continue;
                IDLVariable v = (IDLVariable)obj;
                if (v.isSpecialPlaceholder()) {
                    selection = new TreeSelection();
                    continue;
                }
                IDLVariable parent = v;
                IDLVariable worker = v.getParent();
                while (worker != null) {
                    parent = worker;
                    if (parent.isObjref()) {
                        selection = new TreeSelection();
                        continue block0;
                    }
                    worker = worker.getParent();
                }
            }
        }
        this.m_selection = selection;
        event.doit = !selection.isEmpty();
    }

    public void dragSetData(DragSourceEvent event) {
        TreeSelection ts = (TreeSelection)this.m_selection;
        event.data = TreeUtils.convertSelectionToCSVListOfVariableNames(ts);
    }

    public void dragFinished(DragSourceEvent event) {
        this.m_selection = null;
    }
}

