/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.variablesview;

import com.rsi.idldt.debug.internal.model.IDLVariable;
import com.rsi.idldt.debug.internal.model.IDeleteVariable;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.variablesview.IDLVariablesView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteVariableAction
extends SelectionProviderAction {
    protected List<IDLVariable> fVariables = new ArrayList<IDLVariable>();
    private IDLVariablesView fView;

    public DeleteVariableAction(IDLVariablesView view) {
        super((ISelectionProvider)view.getViewer(), Messages.IDLVariableView_DeleteVariableMenuText);
        ImageDescriptor deleteImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.rsi.idldt.ui", (String)"icons/delete.gif");
        ImageDescriptor deleteImageDisabled = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.rsi.idldt.ui", (String)"icons/delete_disabled.gif");
        this.setDescription(Messages.IDLVariableView_DeleteVariableToolTip);
        this.setImageDescriptor(deleteImage);
        this.setHoverImageDescriptor(deleteImage);
        this.setDisabledImageDescriptor(deleteImageDisabled);
        this.fView = view;
    }

    protected void doActionPerformed(Iterator<?> variables) {
        this.fVariables.clear();
        Shell shell = this.fView.getViewSite().getShell();
        while (variables.hasNext()) {
            IDLVariable v = (IDLVariable)variables.next();
            if (!v.canBeRenamedOrDeleted()) continue;
            this.fVariables.add(v);
        }
        this.doDelete(shell);
    }

    private void doDelete(Shell shell) {
        boolean doit = MessageDialog.openConfirm((Shell)shell, (String)Messages.IDLVariableView_DeleteVariableConfirmTitle, (String)Messages.bind(Messages.IDLVariableView_DeleteVariableConfirmMessage, DeleteVariableAction.list(this.fVariables)));
        if (doit) {
            for (IDLVariable v : this.fVariables) {
                v.deleteVariable();
            }
        }
    }

    public static String list(List<IDLVariable> vars) {
        if (vars.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (IDLVariable v : vars) {
            sb.append(String.valueOf(v.getName()) + ", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        return sb.toString();
    }

    protected void update(IStructuredSelection sel) {
        Iterator iter = sel.iterator();
        if (iter.hasNext()) {
            IDeleteVariable varMod;
            Object object = iter.next();
            if (object instanceof IDeleteVariable && !(varMod = (IDeleteVariable)object).supportsDelete()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        Iterator iterator = this.getStructuredSelection().iterator();
        this.doActionPerformed(iterator);
    }

    public void selectionChanged(IStructuredSelection sel) {
        this.update(sel);
    }
}

