/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.ui;

import com.rsi.idldt.core.IDLDTCorePlugin;
import com.rsi.idldt.core.IDLNotifyListener;
import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IDLProjectNature;
import com.rsi.idldt.core.IGUIHandler;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.core.IOutputLogHandler;
import com.rsi.idldt.core.ResponseManager;
import com.rsi.idldt.core.dom.IIDLDOMManager;
import com.rsi.idldt.internal.ui.GUIHandler;
import com.rsi.idldt.outputlog.IDLOutputLog;
import com.rsi.idldt.proeditor.ProEditor;
import com.rsi.idldt.ui.IDLContextManager;
import com.rsi.idldt.ui.IDLEditorUtilities;
import com.rsi.idldt.ui.IDLProductizer;
import com.rsi.jdml.IDLVariable;
import com.rsi.jdml.PlatformSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.EditLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.elements.adapters.Messages;
import org.eclipse.debug.internal.ui.sourcelookup.EditSourceLookupPathAction;
import org.eclipse.debug.internal.ui.sourcelookup.LookupSourceAction;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.jface.internal.provisional.action.IToolBarManager2;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.ActionSetContributionItem;
import org.eclipse.ui.internal.ActionSetMenuManager;
import org.eclipse.ui.internal.IObjectContributor;
import org.eclipse.ui.internal.PluginActionContributionItem;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.RegistryPageContributor;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class UIPlugin
extends AbstractUIPlugin {
    final int BEGIN_LISTEN_PORT = 51000;
    static IWorkbenchPart m_activePart;
    public static final String PROP_ECLIPSE_VM = "eclipse.vm";
    public static final String ID_PLUGIN = "com.rsi.idldt.ui";
    public static final String ID_IDL_PERSPECTIVE = "com.rsi.idldt.ui.IDLPerspective";
    public static final String ID_VISUALIZE_PERSPECTIVE = "com.rsi.idldt.toolpalette.ui.VisualizePerspective";
    public static final String ID_COMMANDHISTORY_VIEW = "com.rsi.idldt.ui.views.CommandHistoryView";
    public static String ID_COMMANDLINE_VIEW;
    public static String ID_COMMANDLINEEDITOR_VIEW;
    public static String ID_PRO_EDITOR;
    public static final String ID_PROFILER_VIEW = "com.rsi.idldt.ui.views.ProfilerView";
    public static final String TOGGLE_COMMENT_ACTION = "com.rsi.idldt.ui.commands.Coding.ToggleComment";
    public static final String ID_NEW_UNTITLED_PRO_WIZARD = "com.rsi.idldt.core.ui.newUntitledProWizard";
    public static final String ID_NEW_PROJECT_WIZARD = "com.rsi.idldt.core.ui.newProjectWizard";
    public static final String ID_BASE_CONTEXT = "com.rsi.idldt.ui.baseContext";
    public static final String ID_RUN_CONTEXT = "com.rsi.idldt.ui.runContext";
    public static final String ID_COMMAND_LINE_CONTEXT = "com.rsi.idldt.ui.cmdLineContext";
    public static final String ID_COMMAND_LINE_SUSPEND_CONTEXT = "com.rsi.idldt.ui.cmdLineSuspend";
    public static final String ID_PRO_EDITOR_CONTEXT = "com.rsi.idldt.ui.proEditorContext";
    public static final String ID_IDL_PART_PREFIX = "com.rsi.idldt";
    private static UIPlugin plugin;
    public static final boolean IS_DEBUGGING;
    static Vector<IEditorInput> m_AddedToDOM;
    private static IDLContextManager contextManager;
    private BundleListener bundleListener;
    public static final String ID_SHIFT_LEFT_ACTION = "com.rsi.idldt.ui.actions.Coding.ShiftLeft";
    public static final String ID_SHIFT_RIGHT_ACTION = "com.rsi.idldt.ui.actions.Coding.ShiftRight";
    protected IMenuManager m_hookedToLaunchViewContextMenu = null;
    private static final String SUPPRESS_FATAL_ERROR_DIALOG = "suppressFatalErrorDialog";

    static {
        ID_COMMANDLINE_VIEW = "com.rsi.idldt.ui.views.CommandLineView";
        ID_COMMANDLINEEDITOR_VIEW = "com.rsi.idldt.ui.CommandLineEditor";
        ID_PRO_EDITOR = "com.rsi.idldt.proeditor.ProEditor";
        IS_DEBUGGING = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.rsi.idldt.ui/debug"));
    }

    public UIPlugin() {
        plugin = this;
        String[] appArgs = Platform.getApplicationArgs();
        int i = 0;
        while (i < appArgs.length) {
            if (appArgs[i].equals("-minimized")) {
                this.getWorkbench().getActiveWorkbenchWindow().getShell().setMinimized(true);
            }
            ++i;
        }
    }

    public void start(final BundleContext context) throws Exception {
        super.start(context);
        DebugUIPlugin.getDefault();
        this.hackEclipseVMSetting();
        this.turnOffEclipseGUI();
        IDLProjectNature.createDefaultProjectIfNecessary();
        contextManager = new IDLContextManager();
        this.startFileOpenListenThread();
        this.bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle() == UIPlugin.this.getBundle() && event.getType() == 2) {
                    if (UIPlugin.this.getBundle().getState() == 32) {
                        PostUIBundleStartJob j = new PostUIBundleStartJob(com.rsi.idldt.internal.ui.Messages.UIPlugin_PostStartJob);
                        j.setPriority(20);
                        j.setSystem(true);
                        j.schedule();
                    }
                    context.removeBundleListener((BundleListener)this);
                }
            }
        };
        context.addBundleListener(this.bundleListener);
    }

    public static IWorkbenchPart getActiveWorkbenchPart() {
        return m_activePart;
    }

    private void hackEclipseVMSetting() {
        String vmProp;
        if (IDLDTCorePlugin.isIDLWorkbenchProduct() && ((vmProp = System.getProperty(PROP_ECLIPSE_VM)) == null || vmProp.equals(""))) {
            String javaBin = PlatformSupport.getJavaBinLocation();
            System.setProperty(PROP_ECLIPSE_VM, javaBin);
        }
    }

    private void turnOffEclipseGUI() {
        IContributionItem launchActionSet;
        IToolBarManager tbFileMgr;
        if (!IDLDTCorePlugin.isIDLWorkbenchProduct()) {
            return;
        }
        IWorkbenchWindow wWin = UIPlugin.getActiveWorkbenchWindow();
        if (!(wWin instanceof ApplicationWindow)) {
            return;
        }
        ApplicationWindow ww = (ApplicationWindow)wWin;
        MenuManager mm = ww.getMenuBarManager();
        if (mm == null) {
            return;
        }
        this.hookToFileMenuAboutToShow(mm);
        this.hookToNavigateMenuAboutToShow(mm);
        this.removeActionSets(new String[]{"org.eclipse.debug.ui.launchActionSet", "org.eclipse.ui.externaltools.ExternalToolsSet", "org.eclipse.debug.ui.profileActionSet"});
        this.hookPartListenersToPartService();
        this.removeBuildAllFromToolbarAndKeepItOff();
        IMenuManager projMenu = mm.findMenuUsingPath("project");
        projMenu.remove("buildClean");
        projMenu.remove("buildAutomatically");
        IContributionItem[] items = projMenu.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof ActionContributionItem) {
                ActionContributionItem ci = (ActionContributionItem)items[i];
                if (ci.getAction().getActionDefinitionId().equals("org.eclipse.ui.project.buildProject")) {
                    int keycode = 262210;
                    ci.getAction().setAccelerator(keycode);
                    this.addBuildProjectToTheMainToolbar(ci.getAction());
                }
            } else if (items[i] instanceof MenuManager) {
                projMenu.remove(items[i]);
            }
            ++i;
        }
        IMenuManager winMenu = mm.findMenuUsingPath("window");
        winMenu.remove("openNewWindow");
        CoolBarManager coolBar = ww.getCoolBarManager();
        ToolBarManager toolbarEdit = new ToolBarManager(coolBar.getStyle());
        toolbarEdit.add((IAction)ActionFactory.UNDO.create(wWin));
        toolbarEdit.add((IAction)ActionFactory.REDO.create(wWin));
        toolbarEdit.add((IAction)ActionFactory.CUT.create(wWin));
        toolbarEdit.add((IAction)ActionFactory.COPY.create(wWin));
        toolbarEdit.add((IAction)ActionFactory.PASTE.create(wWin));
        coolBar.remove("com.rsi.idldt.ui.edit");
        coolBar.prependToGroup("additions", (IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbarEdit, "com.rsi.idldt.ui.edit"));
        IContributionItem tbFile = coolBar.find("org.eclipse.ui.workbench.file");
        if (tbFile instanceof ToolBarContributionItem && (tbFileMgr = ((ToolBarContributionItem)tbFile).getToolBarManager()) != null) {
            tbFileMgr.remove("newWizardDropDown");
        }
        if ((launchActionSet = coolBar.find("org.eclipse.debug.ui.launchActionSet")) instanceof ToolBarContributionItem) {
            ToolBarContributionItem tbci = (ToolBarContributionItem)launchActionSet;
            IToolBarManager2 tbm2 = (IToolBarManager2)tbci.getToolBarManager();
            tbm2.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    IToolBarManager2 tbm21 = (IToolBarManager2)event.getSource();
                    tbm21.remove("org.eclipse.debug.internal.ui.actions.DebugDropDownAction");
                    tbm21.remove("org.eclipse.debug.internal.ui.actions.RunDropDownAction");
                    tbm21.remove("org.eclipse.ui.externaltools.ExternalToolMenuDelegateToolbar");
                }
            });
        }
        IDLProductizer.deleteMenuItems(new String[]{"org.eclipse.debug.ui.actions.ToggleMethodBreakpoint", "org.eclipse.debug.ui.actions.ToggleLineBreakpoint", "org.eclipse.debug.ui.actions.ToggleWatchpoint", "org.eclipse.debug.ui.actions.SkipAllBreakpoints", "org.eclipse.debug.ui.actions.OpenDebugConfigurations", "org.eclipse.debug.internal.ui.actions.DebugWithConfigurationAction", "org.eclipse.debug.internal.ui.actions.DebugHistoryMenuAction", "org.eclipse.debug.ui.actions.OpenRunConfigurations", "org.eclipse.debug.internal.ui.actions.RunWithConfigurationAction", "org.eclipse.debug.internal.ui.actions.RunHistoryMenuAction", "org.eclipse.debug.ui.actions.DebugLast", "org.eclipse.debug.ui.actions.RunLast", "org.eclipse.debug.ui.actions.ToggleStepFilters", "org.eclipse.ui.externaltools.ExternalToolMenuDelegateMenu"});
        IDLProductizer.deleteMenuItem("org.eclipse.search.OpenFileSearchPage");
        IDLProductizer.deleteViewToolbarItems("org.eclipse.debug.ui.DebugView", new String[]{"org.eclipse.debug.ui.debugview.toolbar.removeAllTerminated", "org.eclipse.debug.ui.debugview.toolbar.disconnect", "org.eclipse.debug.ui.debugview.toolbar.dropToFrame", "org.eclipse.debug.ui.actions.ToggleStepFilters"});
        IDLProductizer.deleteViewContextMenuItems("org.eclipse.debug.ui.VariableView", new String[]{"org.eclipse.debug.ui.ConfigureColumnsAction", "org.eclipse.jdt.debug.ui.actions.WatchAction"});
        IDLProductizer.deleteViewToolbarItems("org.eclipse.debug.ui.VariableView", new String[]{"org.eclipse.debug.ui.ToggleObjectBrowsersAction", "org.eclipse.debug.ui.ShowTypesAction"});
        IDLProductizer.deleteViewToolbarItems("org.eclipse.debug.ui.BreakpointView", new String[]{"org.eclipse.debug.ui.ShowSupportedBreakpointsAction"});
        IDLProductizer.doPreStartupWork();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.bundleListener != null) {
            context.removeBundleListener(this.bundleListener);
        }
        plugin = null;
    }

    public static UIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID_PLUGIN, (String)path);
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow window = null;
        try {
            window = plugin.getWorkbench().getActiveWorkbenchWindow();
        }
        catch (Exception exception) {}
        return window;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchPage page = null;
        try {
            page = UIPlugin.getActiveWorkbenchWindow().getActivePage();
        }
        catch (Exception exception) {}
        return page;
    }

    public static Shell getShell() {
        Shell shell = null;
        try {
            shell = UIPlugin.getActiveWorkbenchWindow().getShell();
        }
        catch (Exception exception) {}
        return shell;
    }

    public static IStatusLineManager getStatusLineManager() {
        IStatusLineManager statusLineManager = null;
        IWorkbenchPage activePage = UIPlugin.getActivePage();
        if (activePage != null) {
            IWorkbenchPart activePart = activePage.getActivePart();
            if (activePart instanceof IViewPart) {
                statusLineManager = ((IViewPart)activePart).getViewSite().getActionBars().getStatusLineManager();
            } else if (activePart instanceof IEditorPart) {
                statusLineManager = ((IEditorPart)activePart).getEditorSite().getActionBars().getStatusLineManager();
            }
        }
        return statusLineManager;
    }

    public static IDLContextManager getContextManager() {
        return contextManager;
    }

    void addInitialEditorsToDOM() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow workbenchWindow = UIPlugin.getActiveWorkbenchWindow();
                new EditorDOMAdder(workbenchWindow).start();
            }
        });
    }

    protected void removeUnwantedProjectPropertyPages() {
        IWorkspace wk = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = wk.getRoot();
        IProject[] projects = root.getProjects();
        if (projects == null || projects.length == 0) {
            return;
        }
        IProject proj = projects[0];
        PropertyPageContributorManager m = PropertyPageContributorManager.getManager();
        Collection c = m.getApplicableContributors((Object)proj);
        for (RegistryPageContributor name : c) {
            String pageId = name.getPageId();
            if (!pageId.equals("org.eclipse.debug.ui.properties.defaultLaunchConfigurations") && !pageId.equals("org.eclipse.ltk.ui.refactoring.property.page") && !pageId.equals("org.eclipse.ui.externaltools.propertypages.BuilderPropertyPage")) continue;
            m.unregisterContributor((IObjectContributor)name, "java.lang.Object");
        }
    }

    protected void hookToFileMenuAboutToShow(MenuManager mm) {
        IMenuManager fileMenu = mm.findMenuUsingPath("file");
        fileMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                String[] openLocalFileId = new String[]{"org.eclipse.ui.openLocalFile"};
                IDLProductizer.seekAndDestroy((IContributionItem)manager, openLocalFileId);
            }
        });
    }

    protected void hookToNavigateMenuAboutToShow(MenuManager mm) {
        IMenuManager navigateMenu = mm.findMenuUsingPath("navigate");
        navigateMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem[] children = manager.getItems();
                int i = 0;
                while (i < children.length) {
                    IMenuManager menu;
                    if (children[i] instanceof IMenuManager && (menu = (IMenuManager)children[i]).getId().equalsIgnoreCase("showIn")) {
                        manager.remove(children[i]);
                        break;
                    }
                    ++i;
                }
            }
        });
    }

    protected void addKeyboardAcceleratorForProjectBuild(Menu menu) {
        MenuItem[] items = menu.getItems();
        int i = items.length - 1;
        while (i >= 0) {
            String itemId = items[i].getText();
            if (itemId.equalsIgnoreCase("&Build Project")) {
                int keyCode = LegacyActionTools.convertAccelerator((String)"Ctrl+B");
                items[i].setAccelerator(keyCode);
                String accelText = LegacyActionTools.convertAccelerator((int)keyCode);
                items[i].setText(String.valueOf(itemId) + "\t" + accelText);
                break;
            }
            --i;
        }
    }

    protected void removeActionSets(String[] actionSetIds) {
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor[] actionSets = reg.getActionSets();
        int i = 0;
        while (i < actionSets.length) {
            int j = 0;
            while (j < actionSetIds.length) {
                if (actionSets[i].getId().equals(actionSetIds[j])) {
                    actionSets[i].setInitiallyVisible(false);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void hookToLaunchViewContextMenuAboutToShow() {
        IWorkbenchPage page = UIPlugin.getActivePage();
        if (page == null) {
            return;
        }
        IViewPart view = page.findView("org.eclipse.debug.ui.DebugView");
        LaunchView lview = (LaunchView)view;
        if (lview == null) {
            return;
        }
        List mm_list = lview.getContextMenuManagers();
        IMenuManager lvContextMenu = (IMenuManager)mm_list.get(0);
        if (this.m_hookedToLaunchViewContextMenu == lvContextMenu) {
            return;
        }
        this.m_hookedToLaunchViewContextMenu = lvContextMenu;
        lvContextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IWorkbenchWindow workbenchWindow = UIPlugin.getActiveWorkbenchWindow();
                ApplicationWindow applicationWindow = (ApplicationWindow)workbenchWindow;
                MenuManager menuManager = applicationWindow.getMenuBarManager();
                IContributionItem ci = menuManager.findUsingPath("org.eclipse.ui.run");
                if (ci != null) {
                    ActionSetContributionItem asci = (ActionSetContributionItem)ci;
                    ActionSetMenuManager asmm = (ActionSetMenuManager)asci.getInnerItem();
                    IContributionItem[] sb = asmm.getItems();
                    int i = 0;
                    while (i < sb.length) {
                        if (sb[i].getId().equals("com.rsi.idldt.ui.actions.run.skip")) {
                            ActionSetContributionItem ascii = (ActionSetContributionItem)sb[i];
                            PluginActionContributionItem paci = (PluginActionContributionItem)ascii.getInnerItem();
                            IAction action = paci.getAction();
                            manager.appendToGroup("stepReturnGroup", action);
                            break;
                        }
                        ++i;
                    }
                    IDLProductizer.seekAndDestroy((IContributionItem)manager, new String[]{"org.eclipse.debug.ui.debugview.toolbar.dropToFrame", "org.eclipse.debug.ui.actions.ToggleStepFilters", "org.eclipse.debug.ui.debugview.toolbar.disconnect", "org.eclipse.debug.ui.debugview.popupMenu.removeAllTerminated", "org.eclipse.debug.ui.debugview.popupMenu.relaunch", "org.eclipse.debug.ui.debugview.popupMenu.terminateAndRemove", "org.eclipse.debug.ui.debugview.popupMenu.terminateAll", "org.eclipse.debug.ui.debugview.popupMenu.terminateAndRelaunch"});
                    IContributionItem ici = IDLProductizer.find((IContributionItem)manager, LookupSourceAction.class);
                    manager.remove(ici);
                    ici = IDLProductizer.find((IContributionItem)manager, EditLaunchConfigurationAction.class);
                    manager.remove(ici);
                    ici = IDLProductizer.find((IContributionItem)manager, EditSourceLookupPathAction.class);
                    manager.remove(ici);
                }
            }
        });
    }

    protected void hookPartListenersToPartService() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IPartService partService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService();
                if (partService != null) {
                    partService.addPartListener(new IPartListener(){

                        public void partActivated(IWorkbenchPart part) {
                            m_activePart = part;
                            if (part instanceof LaunchView) {
                                UIPlugin.this.hookToLaunchViewContextMenuAboutToShow();
                            } else if (part instanceof CommonNavigator) {
                                UIPlugin.this.hookToProjectPropertiesAboutToShow();
                            }
                        }

                        public void partBroughtToTop(IWorkbenchPart part) {
                        }

                        public void partClosed(IWorkbenchPart part) {
                        }

                        public void partDeactivated(IWorkbenchPart part) {
                        }

                        public void partOpened(IWorkbenchPart part) {
                        }
                    });
                }
            }
        });
    }

    protected void hookToProjectPropertiesAboutToShow() {
        IWorkbenchPage page = UIPlugin.getActivePage();
        if (page == null) {
            return;
        }
        IViewPart view = page.findView("org.eclipse.ui.navigator.ProjectExplorer");
        CommonNavigator cn = (CommonNavigator)view;
        final Menu menu = cn.getCommonViewer().getTree().getMenu();
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                UIPlugin.this.removeUnwantedProjectPropertyPages();
                UIPlugin.this.addKeyboardAcceleratorForProjectBuild(menu);
            }

            public void menuHidden(MenuEvent e) {
            }
        });
    }

    private void addBuildProjectToTheMainToolbar(IAction buildProjectAction) {
        ImageDescriptor buildProjectDescriptor = UIPlugin.getImageDescriptor("icons/build_project.gif");
        buildProjectAction.setImageDescriptor(buildProjectDescriptor);
        IWorkbenchWindow wWin = UIPlugin.getActiveWorkbenchWindow();
        if (!(wWin instanceof ApplicationWindow)) {
            return;
        }
        ApplicationWindow ww = (ApplicationWindow)wWin;
        CoolBarManager coolBarManager = ww.getCoolBarManager();
        IContributionItem cbItem = coolBarManager.find("org.eclipse.ui.workbench.file");
        IToolBarContributionItem toolBarItem = (IToolBarContributionItem)cbItem;
        IToolBarManager2 toolBarManager = (IToolBarManager2)toolBarItem.getToolBarManager();
        toolBarManager.appendToGroup("build.group", buildProjectAction);
        toolBarManager.update(false);
        toolBarItem.update("size");
    }

    private void removeBuildAllFromToolbarAndKeepItOff() {
        String buildId;
        IWorkbenchWindow wWin = UIPlugin.getActiveWorkbenchWindow();
        if (!(wWin instanceof ApplicationWindow)) {
            return;
        }
        ApplicationWindow ww = (ApplicationWindow)wWin;
        CoolBarManager coolBarManager = ww.getCoolBarManager();
        IContributionItem cbItem = coolBarManager.find("org.eclipse.ui.workbench.file");
        IToolBarContributionItem toolBarItem = (IToolBarContributionItem)cbItem;
        IToolBarManager2 toolBarManager = (IToolBarManager2)toolBarItem.getToolBarManager();
        if (toolBarManager.find(buildId = IDEActionFactory.BUILD.getId()) != null) {
            toolBarManager.remove(buildId);
            toolBarManager.update(true);
        }
        toolBarManager.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                IToolBarManager2 tbm2 = (IToolBarManager2)event.getSource();
                if (tbm2.find(buildId) != null) {
                    tbm2.remove(buildId);
                    tbm2.update(true);
                }
            }
        });
    }

    protected int getUID() {
        int userId = 0;
        try {
            int ch;
            String[] cmd = new String[]{"id", "-u"};
            Process process = Runtime.getRuntime().exec(cmd);
            InputStream in = process.getInputStream();
            StringBuffer sb = new StringBuffer(512);
            while ((ch = in.read()) != -1) {
                sb.append((char)ch);
            }
            String sUID = sb.toString().trim();
            userId = Integer.parseInt(sUID);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return userId;
    }

    protected void startFileOpenListenThread() {
        if (!PlatformSupport.isWindows() && !PlatformSupport.isMac()) {
            return;
        }
        try {
            int userId;
            if (PlatformSupport.isWindows()) {
                userId = 0;
            } else {
                userId = this.getUID();
                userId %= 1000;
            }
            int listen_port = 51000 + userId;
            ServerSocket ss = new ServerSocket(listen_port);
            FileOpenConnectionHandler ch = new FileOpenConnectionHandler(ss);
            Thread listenThread = new Thread(ch);
            listenThread.start();
        }
        catch (Exception exception) {}
    }

    public static boolean editorAddedOnStartup(IEditorInput ei) {
        if (m_AddedToDOM != null && m_AddedToDOM.contains(ei)) {
            m_AddedToDOM.remove(ei);
            return true;
        }
        return false;
    }

    public static boolean isSuppressFatalDialogSet() {
        return System.getProperty(SUPPRESS_FATAL_ERROR_DIALOG) != null;
    }

    private class EditorDOMAdder
    extends Thread {
        private IWorkbenchWindow m_workbenchWindow;

        public EditorDOMAdder(IWorkbenchWindow window) {
            this.m_workbenchWindow = window;
        }

        public void run() {
            IWorkbenchPage page = this.m_workbenchWindow.getActivePage();
            IIDLProcessProxy process = IDLProcessManager.getActiveProcess();
            while (page == null || process == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                page = this.m_workbenchWindow.getActivePage();
                process = IDLProcessManager.getActiveProcess();
            }
            this.addEditorsToDOM(page, process);
        }

        private void addEditorsToDOM(IWorkbenchPage page, IIDLProcessProxy idl) {
            IIDLDOMManager domManager = idl.getProjectManager().getDOMManager();
            IEditorReference[] editorRefs = page.getEditorReferences();
            int i = 0;
            while (i < editorRefs.length) {
                try {
                    IEditorInput ei = editorRefs[i].getEditorInput();
                    if (IDLEditorUtilities.doesFileExist(ei)) {
                        ProEditor editor;
                        IEditorPart e = editorRefs[i].getEditor(false);
                        ProEditor proEditor = editor = e instanceof ProEditor ? (ProEditor)e : null;
                        if (editor == null || !editor.wasAddedToDOM()) {
                            Object f = IDLEditorUtilities.getEditorsFile(ei);
                            domManager.addEditor(f);
                            if (editor == null) {
                                if (m_AddedToDOM == null) {
                                    m_AddedToDOM = new Vector();
                                }
                                m_AddedToDOM.add(ei);
                            }
                        }
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    private class FileOpenConnectionHandler
    implements Runnable {
        ServerSocket m_ss;

        public FileOpenConnectionHandler(ServerSocket ss) {
            this.m_ss = ss;
        }

        public void run() {
            while (!Thread.interrupted()) {
                try {
                    String inputLine;
                    Socket clientSocket = this.m_ss.accept();
                    BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                    while ((inputLine = in.readLine()) != null) {
                        final String filename = inputLine.replaceAll("\"", "");
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                IDLEditorUtilities.openNativeFileInEditor(filename);
                            }
                        });
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private class PostUIBundleStartJob
    extends Job {
        public PostUIBundleStartJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            IDLProcessManager.setLogWindowHandler((IOutputLogHandler)new IDLOutputLog());
            IDLProcessManager.setGUIHandler((IGUIHandler)new GUIHandler());
            IDLProductizer.doPostStartupWork();
            UIPlugin.this.addInitialEditorsToDOM();
            IDLNotifyListener listener = new IDLNotifyListener("IDLWorkbenchFocus"){

                public void handleIDLNotification(final IDLVariable parm1, IDLVariable parm2) {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    workbench.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            String viewID;
                            Shell shell = UIPlugin.getShell();
                            if (shell != null) {
                                if ("win32".equalsIgnoreCase(Platform.getOS())) {
                                    shell.setMinimized(true);
                                    shell.setMinimized(false);
                                }
                                shell.forceActive();
                            }
                            if ((viewID = parm1.getString()) == null || viewID.length() == 0) {
                                return;
                            }
                            IWorkbenchPage page = UIPlugin.getActivePage();
                            if (page == null) {
                                return;
                            }
                            try {
                                page.showView(viewID);
                            }
                            catch (PartInitException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            };
            ResponseManager.addIDLNotifyListener((IDLNotifyListener)listener);
            IDLNotifyListener openFileListener = new IDLNotifyListener("IDLOpenFile"){

                public void handleIDLNotification(final IDLVariable param1, final IDLVariable param2) {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    workbench.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            String fileName = param1.getString();
                            Path path = new Path(fileName);
                            String param2String = param2.getString();
                            boolean defaultEditor = "default".equals(param2String);
                            IEditorPart iep = null;
                            iep = defaultEditor ? IDLEditorUtilities.openNativeFileInEditor(path.toPortableString(), "org.eclipse.ui.DefaultTextEditor") : IDLEditorUtilities.openNativeFileInEditor(path.toPortableString());
                            if (iep == null) {
                                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable((IPath)path){
                                    private final /* synthetic */ IPath val$path;
                                    {
                                        this.val$path = iPath;
                                    }

                                    public void run() {
                                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)com.rsi.idldt.internal.ui.Messages.UIPlugin_ErrorOpeningFile, (String)(String.valueOf(com.rsi.idldt.internal.ui.Messages.UIPlugin_ErrorOpeningFile) + ": " + this.val$path.toOSString()));
                                    }
                                });
                            }
                        }
                    });
                }
            };
            ResponseManager.addIDLNotifyListener((IDLNotifyListener)openFileListener);
            Messages.VariableColumnPresentation_3 = com.rsi.idldt.internal.ui.Messages.UIPlugin_Type;
            return Status.OK_STATUS;
        }
    }
}

