/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.ui;

import com.rsi.idldt.debug.internal.model.IDLVariable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;

public class TreeUtils {
    public static String convertSelectionToCSVListOfVariableNames(TreeSelection selection) {
        boolean bFilenames = false;
        StringBuffer sb = new StringBuffer();
        TreePath[] paths = selection.getPaths();
        int pi = 0;
        while (pi < paths.length) {
            int count = paths[pi].getSegmentCount();
            boolean bstartFileName = true;
            int i = 0;
            while (i < count) {
                Object segment = paths[pi].getSegment(i);
                if (segment instanceof IDLVariable) {
                    IDLVariable v = (IDLVariable)segment;
                    String vname = v.getName();
                    if (i != 0 || !v.isSpecialPlaceholder()) {
                        if (vname.startsWith("<PtrHeapVar")) {
                            if (i == count - 1) {
                                sb.insert(0, "*");
                            } else {
                                sb.insert(0, "(*");
                            }
                            sb.delete(sb.length() - 1, sb.length());
                            if (i != count - 1) {
                                sb.append(")");
                            }
                        } else {
                            sb.append(vname);
                        }
                        sb.append(".");
                    }
                } else if (!(segment instanceof IProject) && segment instanceof IFile) {
                    bFilenames = true;
                    if (bstartFileName) {
                        sb.append("'");
                    }
                    IFile f = (IFile)segment;
                    String path = f.getLocationURI().getPath();
                    if (Platform.getOS().equals("win32")) {
                        path = path.substring(1);
                    }
                    sb.append(path);
                    sb.append("/");
                }
                ++i;
            }
            int endIndex = sb.length();
            String tmp = sb.toString().substring(0, endIndex - 1);
            sb.delete(0, endIndex);
            sb.append(tmp);
            if (bFilenames) {
                sb.append("', ");
            } else {
                sb.append(", ");
            }
            ++pi;
        }
        int endIndex = sb.length();
        String tmp = sb.toString().substring(0, endIndex - 2);
        if (bFilenames) {
            tmp = TreeUtils.fixFileSeparators(tmp);
        }
        return tmp;
    }

    public static String fixFileSeparators(String in) {
        String out = Platform.getOS().equals("win32") ? in.replaceAll("/", "\\\\") : in.replaceAll("\\\\", "/");
        return out;
    }

    public static String convertTransferDataToString(Object data) {
        if (data instanceof TreeSelection) {
            TreeSelection selection = (TreeSelection)data;
            return TreeUtils.convertSelectionToCSVListOfVariableNames(selection);
        }
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof String[]) {
            String[] vars = (String[])data;
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < vars.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append('\'');
                buf.append(vars[i]);
                buf.append('\'');
                ++i;
            }
            return buf.toString();
        }
        return null;
    }
}

