/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.ui;

import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class IDLViewUtilities {
    public static IViewPart showView(String viewId, int mode) {
        assert (viewId != null) : "null viewId";
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            return null;
        }
        IViewPart part = null;
        if (mode != 0) {
            try {
                part = activePage.showView(viewId, null, mode);
            }
            catch (PartInitException partInitException) {}
        } else {
            part = activePage.findView(viewId);
        }
        return part;
    }

    public static void highlightView(String viewId, boolean doCreate) {
        IWorkbenchSiteProgressService progressService;
        assert (viewId != null) : "null viewId";
        IViewPart part = IDLViewUtilities.showView(viewId, doCreate ? 3 : 0);
        if (part != null && (progressService = (IWorkbenchSiteProgressService)part.getSite().getAdapter(IWorkbenchSiteProgressService.class)) != null) {
            progressService.warnOfContentChange();
        }
    }
}

