/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.ui;

import com.rsi.idldt.core.IDLDTCorePlugin;
import com.rsi.idldt.ui.UIPlugin;
import com.rsi.idldt.variablesview.IDLVariablesView;
import java.util.List;
import java.util.Vector;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDLProductizer {
    static IDLProductizer m_productizer = new IDLProductizer();
    private static Vector<DeletionInfo> m_mainMenuDeletions;
    static Vector<DeletionInfo> m_toolbarDeletions;
    static Vector<DeletionInfo> m_contextMenuDeletions;

    private IDLProductizer() {
        m_mainMenuDeletions = new Vector(16, 8);
        m_toolbarDeletions = new Vector(16, 8);
        m_contextMenuDeletions = new Vector(16, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteViewToolbarItem(String viewId, String buttonId) {
        Vector<DeletionInfo> vector = m_toolbarDeletions;
        synchronized (vector) {
            IDLProductizer iDLProductizer = m_productizer;
            iDLProductizer.getClass();
            m_toolbarDeletions.add(iDLProductizer.new DeletionInfo(viewId, buttonId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteViewToolbarItems(String viewId, String[] buttonIds) {
        Vector<DeletionInfo> vector = m_toolbarDeletions;
        synchronized (vector) {
            IDLProductizer iDLProductizer = m_productizer;
            iDLProductizer.getClass();
            m_toolbarDeletions.add(iDLProductizer.new DeletionInfo(viewId, buttonIds));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteMenuItem(String itemId) {
        Vector<DeletionInfo> vector = m_mainMenuDeletions;
        synchronized (vector) {
            IDLProductizer iDLProductizer = m_productizer;
            iDLProductizer.getClass();
            m_mainMenuDeletions.add(iDLProductizer.new DeletionInfo(itemId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteMenuItems(String[] itemIds) {
        Vector<DeletionInfo> vector = m_mainMenuDeletions;
        synchronized (vector) {
            IDLProductizer iDLProductizer = m_productizer;
            iDLProductizer.getClass();
            m_mainMenuDeletions.add(iDLProductizer.new DeletionInfo(itemIds));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteViewContextMenuItem(String viewId, String itemId) {
        Vector<DeletionInfo> vector = m_contextMenuDeletions;
        synchronized (vector) {
            IDLProductizer iDLProductizer = m_productizer;
            iDLProductizer.getClass();
            m_contextMenuDeletions.add(iDLProductizer.new DeletionInfo(viewId, itemId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteViewContextMenuItems(String viewId, String[] itemIds) {
        Vector<DeletionInfo> vector = m_contextMenuDeletions;
        synchronized (vector) {
            IDLProductizer iDLProductizer = m_productizer;
            iDLProductizer.getClass();
            m_contextMenuDeletions.add(iDLProductizer.new DeletionInfo(viewId, itemIds));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteViewContextMenuItems(String viewId, Class<?> classId) {
        Vector<DeletionInfo> vector = m_contextMenuDeletions;
        synchronized (vector) {
            IDLProductizer iDLProductizer = m_productizer;
            iDLProductizer.getClass();
            m_contextMenuDeletions.add(iDLProductizer.new DeletionInfo(viewId, classId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteViewContextMenuItems(String viewId, Class<?>[] classIds) {
        Vector<DeletionInfo> vector = m_contextMenuDeletions;
        synchronized (vector) {
            IDLProductizer iDLProductizer = m_productizer;
            iDLProductizer.getClass();
            m_contextMenuDeletions.add(iDLProductizer.new DeletionInfo(viewId, classIds));
        }
    }

    public static void doPreStartupWork() {
        if (!IDLDTCorePlugin.isIDLWorkbenchProduct()) {
            return;
        }
        IWorkbenchWindow workbenchWindow = UIPlugin.getActiveWorkbenchWindow();
        workbenchWindow.addPageListener((IPageListener)m_productizer.new WorkbenchListener());
    }

    public static void doPostStartupWork() {
        if (!IDLDTCorePlugin.isIDLWorkbenchProduct()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                m_productizer.doRemoveMainMenuItems();
                m_productizer.doRemoveContextMenuItems();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRemoveMainMenuItems() {
        Vector<DeletionInfo> vector = m_mainMenuDeletions;
        synchronized (vector) {
            IWorkbenchWindow workbenchWindow = UIPlugin.getActiveWorkbenchWindow();
            ApplicationWindow applicationWindow = (ApplicationWindow)workbenchWindow;
            MenuManager menuManager = applicationWindow.getMenuBarManager();
            int i = 0;
            while (i < m_mainMenuDeletions.size()) {
                DeletionInfo info = m_mainMenuDeletions.get(i);
                IDLProductizer.seekAndDestroy((IContributionItem)menuManager, info.m_itemIds);
                ++i;
            }
            m_mainMenuDeletions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRemoveContextMenuItems() {
        Vector<DeletionInfo> vector = m_contextMenuDeletions;
        synchronized (vector) {
            IWorkbenchPage page = UIPlugin.getActivePage();
            Vector<String> processedViews = new Vector<String>(4);
            int i = 0;
            while (i < m_contextMenuDeletions.size()) {
                DeletionInfo info = m_contextMenuDeletions.get(i);
                if (!processedViews.contains(info.m_viewId)) {
                    IViewPart view = page.findView(info.m_viewId);
                    if (view instanceof IDLVariablesView) {
                        IDLVariablesView vv = (IDLVariablesView)view;
                        IActionBars actionBars = vv.getViewSite().getActionBars();
                        IMenuManager viewMenu = actionBars.getMenuManager();
                        IContributionItem[] ci = viewMenu.getItems();
                        int j = 0;
                        while (j < ci.length) {
                            if (ci[j] instanceof MenuManager) {
                                IMenuManager mm = (IMenuManager)ci[j];
                                IDLProductizer iDLProductizer = m_productizer;
                                iDLProductizer.getClass();
                                mm.addMenuListener((IMenuListener)iDLProductizer.new IDLProductizerMenuListener("org.eclipse.debug.ui.VariableView"));
                            }
                            ++j;
                        }
                        IDLProductizer iDLProductizer = m_productizer;
                        iDLProductizer.getClass();
                        viewMenu.addMenuListener((IMenuListener)iDLProductizer.new IDLProductizerMenuListener("org.eclipse.debug.ui.VariableView"));
                        List vvContextMenuManagers = vv.getContextMenuManagers();
                        IMenuManager vvContextMenu = (IMenuManager)vvContextMenuManagers.get(0);
                        IDLProductizer iDLProductizer2 = m_productizer;
                        iDLProductizer2.getClass();
                        vvContextMenu.addMenuListener((IMenuListener)iDLProductizer2.new IDLProductizerMenuListener(info.m_viewId));
                    } else if (view instanceof AbstractDebugView) {
                        AbstractDebugView adv = (AbstractDebugView)view;
                        List menuManagers = adv.getContextMenuManagers();
                        IMenuManager menuManager = (IMenuManager)menuManagers.get(0);
                        IDLProductizer iDLProductizer = m_productizer;
                        iDLProductizer.getClass();
                        menuManager.addMenuListener((IMenuListener)iDLProductizer.new IDLProductizerMenuListener(info.m_viewId));
                    }
                    processedViews.add(info.m_viewId);
                }
                ++i;
            }
        }
    }

    public static IContributionItem find(IContributionItem ci, Object id) {
        if (ci instanceof IContributionManager) {
            IContributionManager cm = (IContributionManager)ci;
            IContributionItem[] items = cm.getItems();
            int i = items.length - 1;
            while (i >= 0) {
                if (IDLProductizer.find(items[i], id) != null) {
                    return items[i];
                }
                --i;
            }
        } else {
            if (ci instanceof SubContributionItem) {
                SubContributionItem sci = (SubContributionItem)ci;
                IContributionItem ii = sci.getInnerItem();
                return IDLProductizer.find(ii, id);
            }
            if (ci instanceof SubMenuManager) {
                SubMenuManager smm = (SubMenuManager)ci;
                IMenuManager mm = (IMenuManager)smm.getParent();
                return IDLProductizer.find((IContributionItem)mm, id);
            }
            if (ci instanceof ActionContributionItem && IDLProductizer.matches(ci, id)) {
                return ci;
            }
        }
        return null;
    }

    private static boolean matches(IContributionItem ci, Object id) {
        if (id instanceof String) {
            String ciid = ci.getId();
            return ciid != null && ciid.equalsIgnoreCase((String)id);
        }
        if (ci instanceof ActionContributionItem) {
            ActionContributionItem aci = (ActionContributionItem)ci;
            IAction a = aci.getAction();
            Class c = (Class)id;
            return c.isInstance(a);
        }
        return false;
    }

    public static boolean seekAndDestroy(IContributionItem ci, String[] id) {
        block6: {
            String itemId;
            block7: {
                block5: {
                    if (!(ci instanceof IContributionManager)) break block5;
                    IContributionManager cm = (IContributionManager)ci;
                    IContributionItem[] items = cm.getItems();
                    int i = items.length - 1;
                    while (i >= 0) {
                        if (IDLProductizer.seekAndDestroy(items[i], id)) {
                            cm.remove(items[i]);
                        }
                        --i;
                    }
                    break block6;
                }
                if (ci instanceof SubContributionItem) {
                    SubContributionItem sci = (SubContributionItem)ci;
                    IContributionItem ii = sci.getInnerItem();
                    return IDLProductizer.seekAndDestroy(ii, id);
                }
                if (!(ci instanceof SubMenuManager)) break block7;
                SubMenuManager smm = (SubMenuManager)ci;
                IMenuManager mm = (IMenuManager)smm.getParent();
                IDLProductizer.seekAndDestroy((IContributionItem)mm, id);
                break block6;
            }
            if (!(ci instanceof ActionContributionItem) || (itemId = ci.getId()) == null) break block6;
            int i = 0;
            while (i < id.length) {
                if (itemId.equalsIgnoreCase(id[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeletionInfo {
        public String m_viewId;
        public String[] m_itemIds;
        public Class<?>[] m_classIds;

        public DeletionInfo(String itemId) {
            this(null, itemId);
        }

        public DeletionInfo(String[] itemIds) {
            this(null, itemIds);
        }

        public DeletionInfo(String viewId, String itemId) {
            this.m_viewId = viewId;
            this.m_itemIds = new String[]{itemId};
            this.m_classIds = new Class[0];
        }

        public DeletionInfo(String viewId, String[] itemIds) {
            this.m_viewId = viewId;
            this.m_itemIds = (String[])itemIds.clone();
            this.m_classIds = new Class[0];
        }

        public DeletionInfo(String viewId, Class<?> classId) {
            this.m_viewId = viewId;
            this.m_itemIds = new String[0];
            this.m_classIds = new Class[]{classId};
        }

        public DeletionInfo(String viewId, Class<?>[] classIds) {
            this.m_viewId = viewId;
            this.m_itemIds = new String[0];
            this.m_classIds = classIds;
        }
    }

    private class IDLProductizerMenuListener
    implements IMenuListener {
        private String m_viewId;

        public IDLProductizerMenuListener(String viewId) {
            this.m_viewId = viewId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void menuAboutToShow(IMenuManager manager) {
            Vector<DeletionInfo> vector = m_contextMenuDeletions;
            synchronized (vector) {
                int i = 0;
                int n = m_contextMenuDeletions.size();
                while (i < n) {
                    DeletionInfo info = m_contextMenuDeletions.get(i);
                    if (info.m_viewId.compareToIgnoreCase(this.m_viewId) == 0) {
                        if (info.m_viewId.compareToIgnoreCase("org.eclipse.debug.ui.VariableView") == 0) {
                            IDLProductizer.seekAndDestroy((IContributionItem)manager, info.m_itemIds);
                        } else {
                            int j = 0;
                            while (j < info.m_itemIds.length) {
                                manager.remove(info.m_itemIds[j]);
                                ++j;
                            }
                            j = 0;
                            while (j < info.m_classIds.length) {
                                IContributionItem ci = IDLProductizer.find((IContributionItem)manager, info.m_classIds[j]);
                                if (ci != null) {
                                    manager.remove(ci);
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    class WorkbenchListener
    implements IPageListener,
    IPartListener2 {
        WorkbenchListener() {
        }

        public void pageActivated(IWorkbenchPage page) {
        }

        public void pageClosed(IWorkbenchPage page) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pageOpened(IWorkbenchPage page) {
            Vector<DeletionInfo> vector = m_toolbarDeletions;
            synchronized (vector) {
                int i = m_toolbarDeletions.size() - 1;
                while (i >= 0) {
                    DeletionInfo info = m_toolbarDeletions.get(i);
                    IWorkbenchPage workbenchPage = page;
                    IViewPart viewPart = workbenchPage.findView(info.m_viewId);
                    if (viewPart != null) {
                        IViewSite viewSite = viewPart.getViewSite();
                        this.doRemoveToolbarItems(viewSite, info.m_itemIds);
                        m_toolbarDeletions.remove(i);
                    }
                    --i;
                }
                if (m_toolbarDeletions.size() > 0) {
                    page.addPartListener((IPartListener2)this);
                }
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void partVisible(IWorkbenchPartReference partRef) {
            Vector<DeletionInfo> vector = m_toolbarDeletions;
            synchronized (vector) {
                String partId = partRef.getId();
                int i = m_toolbarDeletions.size() - 1;
                while (i >= 0) {
                    DeletionInfo info = m_toolbarDeletions.get(i);
                    if (partId.compareToIgnoreCase(info.m_viewId) == 0) {
                        IWorkbenchPage workbenchPage = partRef.getPage();
                        IViewPart viewPart = workbenchPage.findView(info.m_viewId);
                        IViewSite viewSite = viewPart.getViewSite();
                        this.doRemoveToolbarItems(viewSite, info.m_itemIds);
                        m_toolbarDeletions.remove(i);
                    }
                    --i;
                }
            }
        }

        private void doRemoveToolbarItems(IViewSite viewSite, String[] id) {
            IActionBars actionBars = viewSite.getActionBars();
            IToolBarManager toolBarManager = actionBars.getToolBarManager();
            int i = 0;
            while (i < id.length) {
                toolBarManager.remove(id[i]);
                ++i;
            }
            actionBars.updateActionBars();
        }
    }
}

