/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.ui;

import com.rsi.idldt.ui.IDLViewUtilities;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IIndex;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class IDLHelpUtilities {
    public static void helpTopic(String topic) {
        IDLHelpUtilities.helpTopic(topic, false);
    }

    public static void helpTopic(final String topic, boolean forceInfopop) {
        boolean hasSWTBrowser;
        Preferences pref = HelpBasePlugin.getDefault().getPluginPreferences();
        Display display = PlatformUI.getWorkbench().getDisplay();
        boolean winfopop = display.getActiveShell() == null ? true : pref.getBoolean("window_infopop");
        if (topic == null || topic.length() == 0) {
            if (winfopop) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp();
            } else {
                IDLViewUtilities.showView("org.eclipse.help.ui.HelpView", 1);
                PlatformUI.getWorkbench().getHelpSystem().displaySearch();
            }
            return;
        }
        String topicname = topic;
        int htmlIndex = topic.indexOf(".html");
        if (htmlIndex >= 0) {
            topicname = topic.substring(0, htmlIndex);
        }
        String topicpath = String.valueOf(topicname) + ".html";
        String topicpathUpper = String.valueOf(topicname.toUpperCase()) + ".html";
        int iAnchor = topic.indexOf(35);
        final String anchor = iAnchor >= 0 && iAnchor < topic.length() - 1 ? topic.substring(iAnchor) : "";
        Object iTopic = null;
        IToc[] tocs = HelpSystem.getTocs();
        int i = 0;
        while (i < tocs.length) {
            IToc toc = tocs[i];
            String href = null;
            String prevHref = null;
            ITopic[] topics = toc.getTopics();
            int j = 0;
            while (j < topics.length) {
                href = topics[j].getHref();
                if (href != null) {
                    int slash = href.indexOf(47, 1);
                    if (slash > 0) {
                        href = href.substring(0, slash + 1);
                    }
                    if (!href.equals(prevHref)) {
                        iTopic = toc.getTopic(String.valueOf(href) + topicpathUpper);
                        if (iTopic == null) {
                            iTopic = toc.getTopic(String.valueOf(href) + topicpath);
                        }
                        if (iTopic != null) break;
                    }
                    prevHref = href;
                }
                ++j;
            }
            if (iTopic != null) break;
            ++i;
        }
        if (iTopic == null) {
            IIndex index = HelpSystem.getIndex();
            IIndexEntry[] entries = index.getEntries();
            int i2 = 0;
            while (i2 < entries.length) {
                ITopic[] topics;
                IIndexEntry indexEntry = entries[i2];
                String keyword = indexEntry.getKeyword();
                if (keyword != null && keyword.equalsIgnoreCase(topicname.toUpperCase()) && (topics = indexEntry.getTopics()) != null && topics.length > 0) {
                    iTopic = topics[0];
                }
                ++i2;
            }
        }
        final ITopic myTopic = iTopic;
        if (iTopic == null) {
            iTopic = new ITopic(){

                public ITopic[] getSubtopics() {
                    return null;
                }

                public IUAElement[] getChildren() {
                    return null;
                }

                public boolean isEnabled(IEvaluationContext context) {
                    return false;
                }

                public String getHref() {
                    return "/com.rsi.idl.doc.base/TopicNotFound.html?notfound=" + topic;
                }

                public String getLabel() {
                    return topic;
                }
            };
        } else if (anchor.length() > 0) {
            iTopic = new ITopic(){

                public ITopic[] getSubtopics() {
                    return myTopic.getSubtopics();
                }

                public IUAElement[] getChildren() {
                    return myTopic.getChildren();
                }

                public boolean isEnabled(IEvaluationContext context) {
                    return myTopic.isEnabled(context);
                }

                public String getHref() {
                    return String.valueOf(myTopic.getHref()) + anchor;
                }

                public String getLabel() {
                    return myTopic.getLabel();
                }
            };
        }
        boolean bl = hasSWTBrowser = !"solaris".equalsIgnoreCase(Platform.getOS());
        if (!hasSWTBrowser && !winfopop || forceInfopop) {
            pref.setValue("window_infopop", true);
        }
        final IHelpResource[] helpResource = new IHelpResource[]{iTopic};
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(new IContext(){

            public IHelpResource[] getRelatedTopics() {
                return helpResource;
            }

            public String getText() {
                return null;
            }
        });
        if (!hasSWTBrowser && !winfopop || forceInfopop) {
            pref.setValue("window_infopop", false);
        }
    }
}

