/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.ui;

import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.dom.IDOMNode;
import com.rsi.idldt.core.dom.IIDLCUMember;
import com.rsi.idldt.core.dom.IIDLCompilationUnit;
import com.rsi.idldt.core.dom.IIDLDOMManager;
import com.rsi.idldt.core.dom.ISourceCodeRange;
import com.rsi.idldt.core.internal.dom.IDLDOMManager;
import com.rsi.idldt.core.utils.WorkspaceUtilities;
import com.rsi.idldt.internal.ui.Messages;
import com.rsi.idldt.ui.EditorMatchingStrategy;
import com.rsi.idldt.ui.UIPlugin;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class IDLEditorUtilities {
    public static IEditorPart openEditor(IEditorInput input, String editorID) {
        IWorkbenchPage p;
        if (input != null && (p = UIPlugin.getActivePage()) != null) {
            IEditorInput activeInput;
            EditorMatchingStrategy ms;
            IEditorPart activeEditor = p.getActiveEditor();
            if (activeEditor != null && (ms = new EditorMatchingStrategy()).matches(activeInput = activeEditor.getEditorInput(), input)) {
                return activeEditor;
            }
            try {
                IEditorPart editorPart = p.openEditor(input, editorID, true);
                return editorPart;
            }
            catch (PartInitException partInitException) {}
        }
        return null;
    }

    public static IEditorPart openNativeFileInEditor(String fullPath) {
        return IDLEditorUtilities.openNativeFileInEditor(fullPath, null);
    }

    public static IEditorPart openNativeFileInEditor(String thePath, String editorID) {
        String id = editorID;
        IFileStore fs = EFS.getLocalFileSystem().getStore((IPath)new Path(thePath));
        IFileInfo info = fs.fetchInfo();
        if (!info.exists() || info.isDirectory()) {
            IDLProcessManager.getLogWindowHandler().idlOutput(IDLProcessManager.getActiveProcess(), 1, String.valueOf(Messages.bind(Messages.FileDoesNotExist, thePath)) + "\n");
            return null;
        }
        IEditorInput input = IDLEditorUtilities.getEditorInput(fs);
        if (input != null) {
            if (id == null) {
                try {
                    IEditorDescriptor desc = IDE.getEditorDescriptor((String)thePath);
                    if (desc != null) {
                        id = desc.getId();
                    }
                }
                catch (PartInitException partInitException) {}
            }
            if (id != null) {
                return IDLEditorUtilities.openEditor(input, id);
            }
        }
        return null;
    }

    public static IEditorPart openFileInAssociatedEditor(IFile file) throws PartInitException {
        IWorkbenchPage page;
        if (file != null && (page = UIPlugin.getActivePage()) != null) {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            return editorPart;
        }
        return null;
    }

    public static void highlightEditorArea(IEditorPart editor, ISourceCodeRange range) {
        if (editor != null && range != null) {
            IDLEditorUtilities.highlightEditorArea(editor, range.getOffset(), range.getLength());
        }
    }

    public static void highlightEditorArea(IEditorPart editor, int offset, int length) {
        if (editor instanceof ITextEditor) {
            ((ITextEditor)editor).selectAndReveal(offset, length);
            return;
        }
    }

    public static IEditorPart[] getEditors() {
        IEditorPart[] editors;
        try {
            IWorkbenchWindow workbenchWindow = UIPlugin.getActiveWorkbenchWindow();
            IWorkbenchPage activePage = workbenchWindow.getActivePage();
            IEditorReference[] editorRefs = activePage.getEditorReferences();
            editors = new IEditorPart[editorRefs.length];
            int i = 0;
            while (i < editors.length) {
                editors[i] = editorRefs[i].getEditor(false);
                ++i;
            }
        }
        catch (NullPointerException nullPointerException) {
            editors = new IEditorPart[]{};
        }
        return editors;
    }

    public static IEditorInput getEditorInput(IFileStore fileStore) {
        IFile workspaceFile = WorkspaceUtilities.getWorkspaceFile((IFileStore)fileStore);
        if (workspaceFile != null) {
            return new FileEditorInput(workspaceFile);
        }
        return new FileStoreEditorInput(fileStore);
    }

    public static IEditorInput getEditorInput(Object input) {
        if (input instanceof IIDLCUMember) {
            return IDLEditorUtilities.getEditorInput((IDOMNode)((IIDLCUMember)input));
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        return null;
    }

    public static Object getEditorsFile(IEditorInput editor) {
        ILocationProvider loc;
        Object f = null;
        if (editor != null && (f = editor.getAdapter(IFile.class)) == null && (loc = (ILocationProvider)editor.getAdapter(ILocationProvider.class)) != null) {
            IPath p = loc.getPath((Object)editor);
            try {
                f = p.toFile().getCanonicalFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return f;
    }

    public static IPath getEditorsAbsolutePath(IEditorInput editor) {
        IPath path = null;
        if (editor != null) {
            ILocationProvider loc;
            IFile file = (IFile)editor.getAdapter(IFile.class);
            if (file != null) {
                path = file.getRawLocation();
            }
            if (path == null && (loc = (ILocationProvider)editor.getAdapter(ILocationProvider.class)) != null) {
                path = loc.getPath((Object)editor);
            }
        }
        return path;
    }

    public static IDOMNode getEditorsNode(IEditorInput editor, int offset) {
        IIDLCompilationUnit cu = IDLEditorUtilities.getEditorsCompilationUnit(editor);
        IDOMNode node = null;
        if (cu != null) {
            node = cu.getElementAt(offset);
        }
        return node;
    }

    public static IIDLCompilationUnit getEditorsCompilationUnit(IEditorInput editor) {
        IIDLCompilationUnit cu = null;
        if (editor != null) {
            IIDLDOMManager domManager = IDLDOMManager.getActiveManager();
            Object f = IDLEditorUtilities.getEditorsFile(editor);
            if (domManager != null && f != null) {
                cu = f instanceof IFile ? domManager.getCompilationUnit((IFile)f) : domManager.getCompilationUnit((File)f);
            }
        }
        return cu;
    }

    public static IEditorInput getEditorInput(IDOMNode element) {
        IDOMNode e = element;
        while (e != null) {
            IIDLCompilationUnit cu;
            IResource resource;
            if (e instanceof IIDLCompilationUnit && (resource = (cu = (IIDLCompilationUnit)e).getResource()) instanceof IFile) {
                return new FileEditorInput((IFile)resource);
            }
            e = e.getParent();
        }
        return null;
    }

    public static String getPathAsString(IPath path) {
        if (path == null) {
            return "null";
        }
        return path.toOSString();
    }

    public static boolean doesFileExist(IEditorInput input) {
        assert (input != null) : "input was null";
        IPath path = IDLEditorUtilities.getEditorsAbsolutePath(input);
        if (path == null) {
            return false;
        }
        return path.toFile().exists();
    }

    public static int getDocOffsetFromPoint(StyledText styledText, Point point) {
        assert (styledText != null) : "null styledText";
        assert (point != null) : "null point";
        int offset = -1;
        try {
            offset = styledText.getOffsetAtLocation(point);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                offset = styledText.getOffsetAtLocation(new Point(0, point.y));
                int lineNumber = styledText.getContent().getLineAtOffset(offset);
                if (point.x >= 0) {
                    offset += styledText.getContent().getLine(lineNumber).length();
                }
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return styledText.getCharCount();
            }
        }
        return offset;
    }
}

