/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.ui;

import com.rsi.idldt.core.IDLDTCorePlugin;
import com.rsi.idldt.core.IDLProcessManager;
import com.rsi.idldt.core.IIDLProcessListener;
import com.rsi.idldt.core.IIDLProcessProxy;
import com.rsi.idldt.debug.model.IIDLDebugTargetListener;
import com.rsi.idldt.internal.ui.views.CommandLineView;
import com.rsi.idldt.ui.UIPlugin;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public class IDLContextManager
extends PerspectiveAdapter
implements IIDLProcessListener,
IPartListener2,
IIDLDebugTargetListener {
    IContextService m_contextService;
    HashMap<String, IContextActivation> m_contextActivations;
    private boolean isIDLWorkbenchProduct;
    private boolean inDebugPerspective;
    private boolean inIDLPerspective;
    private boolean inIDLPart;
    private boolean isDebugging;
    private boolean lastRequestedSuspendState;
    Vector<ContextJob> m_queue = new Vector(4);

    public IDLContextManager() {
        IWorkbench wb = UIPlugin.getDefault().getWorkbench();
        this.m_contextService = (IContextService)wb.getAdapter(IContextService.class);
        this.m_contextActivations = new HashMap(4);
        IWorkbenchWindow wbw = UIPlugin.getActiveWorkbenchWindow();
        if (wbw != null) {
            wbw.addPerspectiveListener((IPerspectiveListener)this);
            wbw.getPartService().addPartListener((IPartListener2)this);
            IDLProcessManager.addProcessListener((IIDLProcessListener)this);
        }
        this.handleActivatedProcess(IDLProcessManager.getActiveProcess());
        this.isIDLWorkbenchProduct = IDLDTCorePlugin.isIDLWorkbenchProduct();
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        String id = perspective.getId();
        if (id.equals("org.eclipse.debug.ui.DebugPerspective")) {
            this.inDebugPerspective = true;
            this.updateContext();
        } else if (id.equals("com.rsi.idldt.ui.IDLPerspective") || id.equals("com.rsi.idldt.toolpalette.ui.VisualizePerspective")) {
            this.inIDLPerspective = true;
            this.updateContext();
        }
    }

    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        String id = perspective.getId();
        if (id.equals("org.eclipse.debug.ui.DebugPerspective")) {
            this.inDebugPerspective = false;
            this.updateContext();
        } else if (id.equals("com.rsi.idldt.ui.IDLPerspective")) {
            this.inIDLPerspective = false;
            this.updateContext();
        }
    }

    public void handleActivatedProcess(IIDLProcessProxy idl) {
        if (idl != null) {
            idl.addIDLDebugTargetListener((IIDLDebugTargetListener)this);
        }
    }

    public void handleDeletedProcess(IIDLProcessProxy idl) {
    }

    public void handleNewProcess(IIDLProcessProxy idl) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        this.inIDLPart = partRef.getId().startsWith("com.rsi.idldt");
        this.updateSuspendContext(partRef, true);
        this.updateContext();
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
        this.inIDLPart = false;
        this.updateSuspendContext(partRef, false);
        this.updateContext();
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void targetResumed() {
        this.isDebugging = true;
        this.updateContext();
    }

    public void targetSuspended() {
        this.isDebugging = true;
        this.updateContext();
    }

    public void targetTerminated() {
        this.isDebugging = false;
        this.updateContext();
    }

    private void updateContext() {
        boolean activate = !this.isDebugging;
        this.activateContext("com.rsi.idldt.ui.runContext", activate);
        activate = this.inIDLPerspective || this.inIDLPart ? true : this.isIDLWorkbenchProduct && (this.isDebugging || this.inDebugPerspective);
        this.activateContext("com.rsi.idldt.ui.baseContext", activate);
    }

    public void requestActivateSuspendContext(boolean activate) {
        this.lastRequestedSuspendState = activate;
        this.updateSuspendContext(UIPlugin.getActivePage().getActivePartReference(), true);
    }

    private void updateSuspendContext(IWorkbenchPartReference partRef, boolean activated) {
        IWorkbenchPart activePart = partRef.getPart(false);
        if (activePart != null && activePart instanceof CommandLineView) {
            if (activated) {
                this.activateContext("com.rsi.idldt.ui.cmdLineSuspend", this.lastRequestedSuspendState);
            } else {
                this.activateContext("com.rsi.idldt.ui.cmdLineSuspend", false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateContext(String contextName, boolean activate) {
        if (!PlatformUI.getWorkbench().getDisplay().isDisposed()) {
            Vector<ContextJob> vector = this.m_queue;
            synchronized (vector) {
                this.m_queue.add(new ContextJob(contextName, activate));
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Vector<ContextJob> vector = IDLContextManager.this.m_queue;
                    synchronized (vector) {
                        int i = 0;
                        int n = IDLContextManager.this.m_queue.size();
                        while (i < n) {
                            this.doWork(IDLContextManager.this.m_queue.get(i));
                            ++i;
                        }
                        IDLContextManager.this.m_queue.removeAllElements();
                    }
                }

                private void doWork(ContextJob job) {
                    IContextActivation ca = IDLContextManager.this.m_contextActivations.get(job.m_contextName);
                    if (job.m_activate) {
                        if (ca == null) {
                            ca = IDLContextManager.this.m_contextService.activateContext(job.m_contextName);
                            IDLContextManager.this.m_contextActivations.put(job.m_contextName, ca);
                        }
                    } else if (ca != null) {
                        IDLContextManager.this.m_contextService.deactivateContext(ca);
                        IDLContextManager.this.m_contextActivations.put(job.m_contextName, null);
                    }
                }
            });
        }
    }

    public class ContextJob {
        String m_contextName;
        boolean m_activate;

        public ContextJob(String name, boolean activate) {
            this.m_contextName = name;
            this.m_activate = activate;
        }
    }
}

