/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.ui;

import com.rsi.idldt.ui.IDLEditorUtilities;
import java.io.File;
import java.io.IOException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;

public class EditorMatchingStrategy
implements IEditorMatchingStrategy {
    public boolean matches(IEditorInput editorRefInput, IEditorInput input) {
        IEditorInput editorInput = editorRefInput;
        if (editorInput == null) {
            return false;
        }
        if (input == null) {
            return false;
        }
        if (input instanceof CompareEditorInput) {
            return false;
        }
        IPath p1_path = IDLEditorUtilities.getEditorsAbsolutePath(editorInput);
        IPath p2_path = IDLEditorUtilities.getEditorsAbsolutePath(input);
        if (p1_path == null || p2_path == null) {
            return false;
        }
        try {
            File f1 = new File(p1_path.toPortableString());
            File f1_canonical = f1.getCanonicalFile();
            File f2 = new File(p2_path.toPortableString());
            File f2_canonical = f2.getCanonicalFile();
            return f1_canonical.equals(f2_canonical);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        IEditorInput editorInput = null;
        try {
            editorInput = editorRef.getEditorInput();
        }
        catch (PartInitException ex) {
            ex.printStackTrace();
            return false;
        }
        return this.matches(editorInput, input);
    }
}

