/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.idldt.ui;

import java.io.PrintWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMWriter
extends PrintWriter {
    private int tab = 0;
    private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public DOMWriter(Writer output) {
        super(output);
        this.println(XML_VERSION);
    }

    public void print(Element element) {
        boolean hasChildren = element.hasChildNodes();
        this.startTag(element, hasChildren);
        if (hasChildren) {
            ++this.tab;
            boolean prevWasText = false;
            NodeList children = element.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node node = children.item(i);
                if (node instanceof Element) {
                    if (!prevWasText) {
                        this.println();
                        this.printTabulation();
                    }
                    this.print((Element)children.item(i));
                    prevWasText = false;
                } else if (node instanceof Text) {
                    this.print(DOMWriter.getEscaped(node.getNodeValue()));
                    prevWasText = true;
                }
                ++i;
            }
            --this.tab;
            if (!prevWasText) {
                this.println();
                this.printTabulation();
            }
            this.endTag(element);
        }
    }

    private void printTabulation() {
        int i = 0;
        while (i < this.tab) {
            super.print("   ");
            ++i;
        }
    }

    private void startTag(Element element, boolean hasChildren) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(element.getTagName());
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attribute = (Attr)attributes.item(i);
            sb.append(" ");
            sb.append(attribute.getName());
            sb.append("=\"");
            sb.append(DOMWriter.getEscaped(String.valueOf(attribute.getValue())));
            sb.append("\"");
            ++i;
        }
        sb.append(hasChildren ? ">" : "/>");
        this.print(sb.toString());
    }

    private void endTag(Element element) {
        StringBuffer sb = new StringBuffer();
        sb.append("</");
        sb.append(element.getNodeName());
        sb.append(">");
        this.print(sb.toString());
    }

    private static void appendEscapedChar(StringBuffer buffer, char c) {
        String replacement = DOMWriter.getReplacement(c);
        if (replacement != null) {
            buffer.append('&');
            buffer.append(replacement);
            buffer.append(';');
        } else {
            buffer.append(c);
        }
    }

    private static String getEscaped(String s) {
        StringBuffer result = new StringBuffer(s.length() + 10);
        int i = 0;
        while (i < s.length()) {
            DOMWriter.appendEscapedChar(result, s.charAt(i));
            ++i;
        }
        return result.toString();
    }

    private static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
            case '\r': {
                return "#x0D";
            }
            case '\n': {
                return "#x0A";
            }
            case '\t': {
                return "#x09";
            }
        }
        return null;
    }
}

